/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.nimble.NimbleAsyncClient;
import software.amazon.awssdk.services.nimble.model.LaunchProfile;
import software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest;
import software.amazon.awssdk.services.nimble.model.ListLaunchProfilesResponse;

public class ListLaunchProfilesPublisher
implements SdkPublisher<ListLaunchProfilesResponse> {
    private final NimbleAsyncClient client;
    private final ListLaunchProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLaunchProfilesPublisher(NimbleAsyncClient client, ListLaunchProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLaunchProfilesPublisher(NimbleAsyncClient client, ListLaunchProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLaunchProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLaunchProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LaunchProfile> launchProfiles() {
        Function<ListLaunchProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.launchProfiles() != null) {
                return response.launchProfiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLaunchProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLaunchProfilesResponseFetcher
    implements AsyncPageFetcher<ListLaunchProfilesResponse> {
        private ListLaunchProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListLaunchProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLaunchProfilesResponse> nextPage(ListLaunchProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListLaunchProfilesPublisher.this.client.listLaunchProfiles(ListLaunchProfilesPublisher.this.firstRequest);
            }
            return ListLaunchProfilesPublisher.this.client.listLaunchProfiles((ListLaunchProfilesRequest)((Object)ListLaunchProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

