/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.nimble.NimbleClient;
import software.amazon.awssdk.services.nimble.model.ListStudiosRequest;
import software.amazon.awssdk.services.nimble.model.ListStudiosResponse;
import software.amazon.awssdk.services.nimble.model.Studio;

public class ListStudiosIterable
implements SdkIterable<ListStudiosResponse> {
    private final NimbleClient client;
    private final ListStudiosRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStudiosIterable(NimbleClient client, ListStudiosRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStudiosResponseFetcher();
    }

    public Iterator<ListStudiosResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Studio> studios() {
        Function<ListStudiosResponse, Iterator> getIterator = response -> {
            if (response != null && response.studios() != null) {
                return response.studios().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStudiosResponseFetcher
    implements SyncPageFetcher<ListStudiosResponse> {
        private ListStudiosResponseFetcher() {
        }

        public boolean hasNextPage(ListStudiosResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStudiosResponse nextPage(ListStudiosResponse previousPage) {
            if (previousPage == null) {
                return ListStudiosIterable.this.client.listStudios(ListStudiosIterable.this.firstRequest);
            }
            return ListStudiosIterable.this.client.listStudios((ListStudiosRequest)((Object)ListStudiosIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

