/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.nimble.NimbleAsyncClient;
import software.amazon.awssdk.services.nimble.internal.UserAgentUtils;
import software.amazon.awssdk.services.nimble.model.Eula;
import software.amazon.awssdk.services.nimble.model.ListEulasRequest;
import software.amazon.awssdk.services.nimble.model.ListEulasResponse;

public class ListEulasPublisher
implements SdkPublisher<ListEulasResponse> {
    private final NimbleAsyncClient client;
    private final ListEulasRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEulasPublisher(NimbleAsyncClient client, ListEulasRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEulasPublisher(NimbleAsyncClient client, ListEulasRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEulasResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEulasResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Eula> eulas() {
        Function<ListEulasResponse, Iterator> getIterator = response -> {
            if (response != null && response.eulas() != null) {
                return response.eulas().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEulasResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEulasResponseFetcher
    implements AsyncPageFetcher<ListEulasResponse> {
        private ListEulasResponseFetcher() {
        }

        public boolean hasNextPage(ListEulasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEulasResponse> nextPage(ListEulasResponse previousPage) {
            if (previousPage == null) {
                return ListEulasPublisher.this.client.listEulas(ListEulasPublisher.this.firstRequest);
            }
            return ListEulasPublisher.this.client.listEulas((ListEulasRequest)((Object)ListEulasPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

