/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAnnotationStoreVersionResponse extends OmicsResponse implements
        ToCopyableBuilder<CreateAnnotationStoreVersionResponse.Builder, CreateAnnotationStoreVersionResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateAnnotationStoreVersionResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionName").getter(getter(CreateAnnotationStoreVersionResponse::versionName))
            .setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()).build();

    private static final SdkField<String> STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storeId").getter(getter(CreateAnnotationStoreVersionResponse::storeId)).setter(setter(Builder::storeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeId").build()).build();

    private static final SdkField<VersionOptions> VERSION_OPTIONS_FIELD = SdkField
            .<VersionOptions> builder(MarshallingType.SDK_POJO).memberName("versionOptions")
            .getter(getter(CreateAnnotationStoreVersionResponse::versionOptions)).setter(setter(Builder::versionOptions))
            .constructor(VersionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionOptions").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAnnotationStoreVersionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateAnnotationStoreVersionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(CreateAnnotationStoreVersionResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, VERSION_NAME_FIELD,
            STORE_ID_FIELD, VERSION_OPTIONS_FIELD, NAME_FIELD, STATUS_FIELD, CREATION_TIME_FIELD));

    private final String id;

    private final String versionName;

    private final String storeId;

    private final VersionOptions versionOptions;

    private final String name;

    private final String status;

    private final Instant creationTime;

    private CreateAnnotationStoreVersionResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.versionName = builder.versionName;
        this.storeId = builder.storeId;
        this.versionOptions = builder.versionOptions;
        this.name = builder.name;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * A generated ID for the annotation store
     * </p>
     * 
     * @return A generated ID for the annotation store
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name given to an annotation store version to distinguish it from other versions.
     * </p>
     * 
     * @return The name given to an annotation store version to distinguish it from other versions.
     */
    public final String versionName() {
        return versionName;
    }

    /**
     * <p>
     * The ID for the annotation store from which new versions are being created.
     * </p>
     * 
     * @return The ID for the annotation store from which new versions are being created.
     */
    public final String storeId() {
        return storeId;
    }

    /**
     * <p>
     * The options for an annotation store version.
     * </p>
     * 
     * @return The options for an annotation store version.
     */
    public final VersionOptions versionOptions() {
        return versionOptions;
    }

    /**
     * <p>
     * The name given to an annotation store version to distinguish it from other versions.
     * </p>
     * 
     * @return The name given to an annotation store version to distinguish it from other versions.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of a annotation store version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a annotation store version.
     * @see VersionStatus
     */
    public final VersionStatus status() {
        return VersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a annotation store version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a annotation store version.
     * @see VersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time stamp for the creation of an annotation store version.
     * </p>
     * 
     * @return The time stamp for the creation of an annotation store version.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(storeId());
        hashCode = 31 * hashCode + Objects.hashCode(versionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnnotationStoreVersionResponse)) {
            return false;
        }
        CreateAnnotationStoreVersionResponse other = (CreateAnnotationStoreVersionResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(versionName(), other.versionName())
                && Objects.equals(storeId(), other.storeId()) && Objects.equals(versionOptions(), other.versionOptions())
                && Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAnnotationStoreVersionResponse").add("Id", id()).add("VersionName", versionName())
                .add("StoreId", storeId()).add("VersionOptions", versionOptions()).add("Name", name())
                .add("Status", statusAsString()).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "versionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "storeId":
            return Optional.ofNullable(clazz.cast(storeId()));
        case "versionOptions":
            return Optional.ofNullable(clazz.cast(versionOptions()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAnnotationStoreVersionResponse, T> g) {
        return obj -> g.apply((CreateAnnotationStoreVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAnnotationStoreVersionResponse> {
        /**
         * <p>
         * A generated ID for the annotation store
         * </p>
         * 
         * @param id
         *        A generated ID for the annotation store
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name given to an annotation store version to distinguish it from other versions.
         * </p>
         * 
         * @param versionName
         *        The name given to an annotation store version to distinguish it from other versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * The ID for the annotation store from which new versions are being created.
         * </p>
         * 
         * @param storeId
         *        The ID for the annotation store from which new versions are being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storeId(String storeId);

        /**
         * <p>
         * The options for an annotation store version.
         * </p>
         * 
         * @param versionOptions
         *        The options for an annotation store version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionOptions(VersionOptions versionOptions);

        /**
         * <p>
         * The options for an annotation store version.
         * </p>
         * This is a convenience method that creates an instance of the {@link VersionOptions.Builder} avoiding the need
         * to create one manually via {@link VersionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VersionOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #versionOptions(VersionOptions)}.
         * 
         * @param versionOptions
         *        a consumer that will call methods on {@link VersionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #versionOptions(VersionOptions)
         */
        default Builder versionOptions(Consumer<VersionOptions.Builder> versionOptions) {
            return versionOptions(VersionOptions.builder().applyMutation(versionOptions).build());
        }

        /**
         * <p>
         * The name given to an annotation store version to distinguish it from other versions.
         * </p>
         * 
         * @param name
         *        The name given to an annotation store version to distinguish it from other versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of a annotation store version.
         * </p>
         * 
         * @param status
         *        The status of a annotation store version.
         * @see VersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a annotation store version.
         * </p>
         * 
         * @param status
         *        The status of a annotation store version.
         * @see VersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VersionStatus
         */
        Builder status(VersionStatus status);

        /**
         * <p>
         * The time stamp for the creation of an annotation store version.
         * </p>
         * 
         * @param creationTime
         *        The time stamp for the creation of an annotation store version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private String id;

        private String versionName;

        private String storeId;

        private VersionOptions versionOptions;

        private String name;

        private String status;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnnotationStoreVersionResponse model) {
            super(model);
            id(model.id);
            versionName(model.versionName);
            storeId(model.storeId);
            versionOptions(model.versionOptions);
            name(model.name);
            status(model.status);
            creationTime(model.creationTime);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getStoreId() {
            return storeId;
        }

        public final void setStoreId(String storeId) {
            this.storeId = storeId;
        }

        @Override
        public final Builder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public final VersionOptions.Builder getVersionOptions() {
            return versionOptions != null ? versionOptions.toBuilder() : null;
        }

        public final void setVersionOptions(VersionOptions.BuilderImpl versionOptions) {
            this.versionOptions = versionOptions != null ? versionOptions.build() : null;
        }

        @Override
        public final Builder versionOptions(VersionOptions versionOptions) {
            this.versionOptions = versionOptions;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public CreateAnnotationStoreVersionResponse build() {
            return new CreateAnnotationStoreVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
