/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAnnotationImportJobsResponse extends OmicsResponse implements
        ToCopyableBuilder<ListAnnotationImportJobsResponse.Builder, ListAnnotationImportJobsResponse> {
    private static final SdkField<List<AnnotationImportJobItem>> ANNOTATION_IMPORT_JOBS_FIELD = SdkField
            .<List<AnnotationImportJobItem>> builder(MarshallingType.LIST)
            .memberName("annotationImportJobs")
            .getter(getter(ListAnnotationImportJobsResponse::annotationImportJobs))
            .setter(setter(Builder::annotationImportJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotationImportJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnnotationImportJobItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnnotationImportJobItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAnnotationImportJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANNOTATION_IMPORT_JOBS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AnnotationImportJobItem> annotationImportJobs;

    private final String nextToken;

    private ListAnnotationImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.annotationImportJobs = builder.annotationImportJobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnnotationImportJobs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnnotationImportJobs() {
        return annotationImportJobs != null && !(annotationImportJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnnotationImportJobs} method.
     * </p>
     * 
     * @return A list of jobs.
     */
    public final List<AnnotationImportJobItem> annotationImportJobs() {
        return annotationImportJobs;
    }

    /**
     * <p>
     * Specifies the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specifies the pagination token from a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAnnotationImportJobs() ? annotationImportJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnnotationImportJobsResponse)) {
            return false;
        }
        ListAnnotationImportJobsResponse other = (ListAnnotationImportJobsResponse) obj;
        return hasAnnotationImportJobs() == other.hasAnnotationImportJobs()
                && Objects.equals(annotationImportJobs(), other.annotationImportJobs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAnnotationImportJobsResponse")
                .add("AnnotationImportJobs", hasAnnotationImportJobs() ? annotationImportJobs() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "annotationImportJobs":
            return Optional.ofNullable(clazz.cast(annotationImportJobs()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnnotationImportJobsResponse, T> g) {
        return obj -> g.apply((ListAnnotationImportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAnnotationImportJobsResponse> {
        /**
         * <p>
         * A list of jobs.
         * </p>
         * 
         * @param annotationImportJobs
         *        A list of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotationImportJobs(Collection<AnnotationImportJobItem> annotationImportJobs);

        /**
         * <p>
         * A list of jobs.
         * </p>
         * 
         * @param annotationImportJobs
         *        A list of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotationImportJobs(AnnotationImportJobItem... annotationImportJobs);

        /**
         * <p>
         * A list of jobs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.omics.model.AnnotationImportJobItem.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.omics.model.AnnotationImportJobItem#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.omics.model.AnnotationImportJobItem.Builder#build()} is called
         * immediately and its result is passed to {@link #annotationImportJobs(List<AnnotationImportJobItem>)}.
         * 
         * @param annotationImportJobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.omics.model.AnnotationImportJobItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #annotationImportJobs(java.util.Collection<AnnotationImportJobItem>)
         */
        Builder annotationImportJobs(Consumer<AnnotationImportJobItem.Builder>... annotationImportJobs);

        /**
         * <p>
         * Specifies the pagination token from a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specifies the pagination token from a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private List<AnnotationImportJobItem> annotationImportJobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnnotationImportJobsResponse model) {
            super(model);
            annotationImportJobs(model.annotationImportJobs);
            nextToken(model.nextToken);
        }

        public final List<AnnotationImportJobItem.Builder> getAnnotationImportJobs() {
            List<AnnotationImportJobItem.Builder> result = AnnotationImportJobItemsCopier
                    .copyToBuilder(this.annotationImportJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnnotationImportJobs(Collection<AnnotationImportJobItem.BuilderImpl> annotationImportJobs) {
            this.annotationImportJobs = AnnotationImportJobItemsCopier.copyFromBuilder(annotationImportJobs);
        }

        @Override
        public final Builder annotationImportJobs(Collection<AnnotationImportJobItem> annotationImportJobs) {
            this.annotationImportJobs = AnnotationImportJobItemsCopier.copy(annotationImportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotationImportJobs(AnnotationImportJobItem... annotationImportJobs) {
            annotationImportJobs(Arrays.asList(annotationImportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotationImportJobs(Consumer<AnnotationImportJobItem.Builder>... annotationImportJobs) {
            annotationImportJobs(Stream.of(annotationImportJobs)
                    .map(c -> AnnotationImportJobItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAnnotationImportJobsResponse build() {
            return new ListAnnotationImportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
