/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class TsvVersionOptionsSchemaListCopier {
    static List<Map<String, String>> copy(Collection<? extends Map<String, String>> tsvVersionOptionsSchemaListParam) {
        List<Map<String, String>> list;
        if (tsvVersionOptionsSchemaListParam == null || tsvVersionOptionsSchemaListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Map<String, String>> modifiableList = new ArrayList<>();
            tsvVersionOptionsSchemaListParam.forEach(entry -> {
                Map<String, String> map;
                if (entry == null || entry instanceof SdkAutoConstructMap) {
                    map = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, String> modifiableMap = new LinkedHashMap<>();
                    entry.forEach((key, value) -> {
                        modifiableMap.put(key, value);
                    });
                    map = Collections.unmodifiableMap(modifiableMap);
                }
                modifiableList.add(map);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Map<String, String>> copyEnumToString(
            Collection<? extends Map<String, SchemaValueType>> tsvVersionOptionsSchemaListParam) {
        List<Map<String, String>> list;
        if (tsvVersionOptionsSchemaListParam == null || tsvVersionOptionsSchemaListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Map<String, String>> modifiableList = new ArrayList<>();
            tsvVersionOptionsSchemaListParam.forEach(entry -> {
                Map<String, String> map;
                if (entry == null || entry instanceof SdkAutoConstructMap) {
                    map = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, String> modifiableMap = new LinkedHashMap<>();
                    entry.forEach((key, value) -> {
                        String result = value.toString();
                        modifiableMap.put(key, result);
                    });
                    map = Collections.unmodifiableMap(modifiableMap);
                }
                modifiableList.add(map);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Map<String, SchemaValueType>> copyStringToEnum(
            Collection<? extends Map<String, String>> tsvVersionOptionsSchemaListParam) {
        List<Map<String, SchemaValueType>> list;
        if (tsvVersionOptionsSchemaListParam == null || tsvVersionOptionsSchemaListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Map<String, SchemaValueType>> modifiableList = new ArrayList<>();
            tsvVersionOptionsSchemaListParam.forEach(entry -> {
                Map<String, SchemaValueType> map;
                if (entry == null || entry instanceof SdkAutoConstructMap) {
                    map = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, SchemaValueType> modifiableMap = new LinkedHashMap<>();
                    entry.forEach((key, value) -> {
                        SchemaValueType result = SchemaValueType.fromValue(value);
                        modifiableMap.put(key, result);
                    });
                    map = Collections.unmodifiableMap(modifiableMap);
                }
                modifiableList.add(map);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
