/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an inbound cross-cluster connection for Amazon OpenSearch Service. For more information, see <a
 * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html">Cross-cluster
 * search for Amazon OpenSearch Service</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InboundConnection implements SdkPojo, Serializable,
        ToCopyableBuilder<InboundConnection.Builder, InboundConnection> {
    private static final SdkField<DomainInformationContainer> LOCAL_DOMAIN_INFO_FIELD = SdkField
            .<DomainInformationContainer> builder(MarshallingType.SDK_POJO).memberName("LocalDomainInfo")
            .getter(getter(InboundConnection::localDomainInfo)).setter(setter(Builder::localDomainInfo))
            .constructor(DomainInformationContainer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalDomainInfo").build()).build();

    private static final SdkField<DomainInformationContainer> REMOTE_DOMAIN_INFO_FIELD = SdkField
            .<DomainInformationContainer> builder(MarshallingType.SDK_POJO).memberName("RemoteDomainInfo")
            .getter(getter(InboundConnection::remoteDomainInfo)).setter(setter(Builder::remoteDomainInfo))
            .constructor(DomainInformationContainer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDomainInfo").build()).build();

    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionId").getter(getter(InboundConnection::connectionId)).setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionId").build()).build();

    private static final SdkField<InboundConnectionStatus> CONNECTION_STATUS_FIELD = SdkField
            .<InboundConnectionStatus> builder(MarshallingType.SDK_POJO).memberName("ConnectionStatus")
            .getter(getter(InboundConnection::connectionStatus)).setter(setter(Builder::connectionStatus))
            .constructor(InboundConnectionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_DOMAIN_INFO_FIELD,
            REMOTE_DOMAIN_INFO_FIELD, CONNECTION_ID_FIELD, CONNECTION_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final DomainInformationContainer localDomainInfo;

    private final DomainInformationContainer remoteDomainInfo;

    private final String connectionId;

    private final InboundConnectionStatus connectionStatus;

    private InboundConnection(BuilderImpl builder) {
        this.localDomainInfo = builder.localDomainInfo;
        this.remoteDomainInfo = builder.remoteDomainInfo;
        this.connectionId = builder.connectionId;
        this.connectionStatus = builder.connectionStatus;
    }

    /**
     * <p>
     * Information about the source (local) domain.
     * </p>
     * 
     * @return Information about the source (local) domain.
     */
    public final DomainInformationContainer localDomainInfo() {
        return localDomainInfo;
    }

    /**
     * <p>
     * Information about the destination (remote) domain.
     * </p>
     * 
     * @return Information about the destination (remote) domain.
     */
    public final DomainInformationContainer remoteDomainInfo() {
        return remoteDomainInfo;
    }

    /**
     * <p>
     * The unique identifier of the connection.
     * </p>
     * 
     * @return The unique identifier of the connection.
     */
    public final String connectionId() {
        return connectionId;
    }

    /**
     * <p>
     * The current status of the connection.
     * </p>
     * 
     * @return The current status of the connection.
     */
    public final InboundConnectionStatus connectionStatus() {
        return connectionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(remoteDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InboundConnection)) {
            return false;
        }
        InboundConnection other = (InboundConnection) obj;
        return Objects.equals(localDomainInfo(), other.localDomainInfo())
                && Objects.equals(remoteDomainInfo(), other.remoteDomainInfo())
                && Objects.equals(connectionId(), other.connectionId())
                && Objects.equals(connectionStatus(), other.connectionStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InboundConnection").add("LocalDomainInfo", localDomainInfo())
                .add("RemoteDomainInfo", remoteDomainInfo()).add("ConnectionId", connectionId())
                .add("ConnectionStatus", connectionStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalDomainInfo":
            return Optional.ofNullable(clazz.cast(localDomainInfo()));
        case "RemoteDomainInfo":
            return Optional.ofNullable(clazz.cast(remoteDomainInfo()));
        case "ConnectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "ConnectionStatus":
            return Optional.ofNullable(clazz.cast(connectionStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InboundConnection, T> g) {
        return obj -> g.apply((InboundConnection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InboundConnection> {
        /**
         * <p>
         * Information about the source (local) domain.
         * </p>
         * 
         * @param localDomainInfo
         *        Information about the source (local) domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localDomainInfo(DomainInformationContainer localDomainInfo);

        /**
         * <p>
         * Information about the source (local) domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainInformationContainer.Builder}
         * avoiding the need to create one manually via {@link DomainInformationContainer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainInformationContainer.Builder#build()} is called immediately
         * and its result is passed to {@link #localDomainInfo(DomainInformationContainer)}.
         * 
         * @param localDomainInfo
         *        a consumer that will call methods on {@link DomainInformationContainer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localDomainInfo(DomainInformationContainer)
         */
        default Builder localDomainInfo(Consumer<DomainInformationContainer.Builder> localDomainInfo) {
            return localDomainInfo(DomainInformationContainer.builder().applyMutation(localDomainInfo).build());
        }

        /**
         * <p>
         * Information about the destination (remote) domain.
         * </p>
         * 
         * @param remoteDomainInfo
         *        Information about the destination (remote) domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteDomainInfo(DomainInformationContainer remoteDomainInfo);

        /**
         * <p>
         * Information about the destination (remote) domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainInformationContainer.Builder}
         * avoiding the need to create one manually via {@link DomainInformationContainer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainInformationContainer.Builder#build()} is called immediately
         * and its result is passed to {@link #remoteDomainInfo(DomainInformationContainer)}.
         * 
         * @param remoteDomainInfo
         *        a consumer that will call methods on {@link DomainInformationContainer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteDomainInfo(DomainInformationContainer)
         */
        default Builder remoteDomainInfo(Consumer<DomainInformationContainer.Builder> remoteDomainInfo) {
            return remoteDomainInfo(DomainInformationContainer.builder().applyMutation(remoteDomainInfo).build());
        }

        /**
         * <p>
         * The unique identifier of the connection.
         * </p>
         * 
         * @param connectionId
         *        The unique identifier of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * The current status of the connection.
         * </p>
         * 
         * @param connectionStatus
         *        The current status of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionStatus(InboundConnectionStatus connectionStatus);

        /**
         * <p>
         * The current status of the connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link InboundConnectionStatus.Builder} avoiding
         * the need to create one manually via {@link InboundConnectionStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InboundConnectionStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #connectionStatus(InboundConnectionStatus)}.
         * 
         * @param connectionStatus
         *        a consumer that will call methods on {@link InboundConnectionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionStatus(InboundConnectionStatus)
         */
        default Builder connectionStatus(Consumer<InboundConnectionStatus.Builder> connectionStatus) {
            return connectionStatus(InboundConnectionStatus.builder().applyMutation(connectionStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DomainInformationContainer localDomainInfo;

        private DomainInformationContainer remoteDomainInfo;

        private String connectionId;

        private InboundConnectionStatus connectionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(InboundConnection model) {
            localDomainInfo(model.localDomainInfo);
            remoteDomainInfo(model.remoteDomainInfo);
            connectionId(model.connectionId);
            connectionStatus(model.connectionStatus);
        }

        public final DomainInformationContainer.Builder getLocalDomainInfo() {
            return localDomainInfo != null ? localDomainInfo.toBuilder() : null;
        }

        public final void setLocalDomainInfo(DomainInformationContainer.BuilderImpl localDomainInfo) {
            this.localDomainInfo = localDomainInfo != null ? localDomainInfo.build() : null;
        }

        @Override
        public final Builder localDomainInfo(DomainInformationContainer localDomainInfo) {
            this.localDomainInfo = localDomainInfo;
            return this;
        }

        public final DomainInformationContainer.Builder getRemoteDomainInfo() {
            return remoteDomainInfo != null ? remoteDomainInfo.toBuilder() : null;
        }

        public final void setRemoteDomainInfo(DomainInformationContainer.BuilderImpl remoteDomainInfo) {
            this.remoteDomainInfo = remoteDomainInfo != null ? remoteDomainInfo.build() : null;
        }

        @Override
        public final Builder remoteDomainInfo(DomainInformationContainer remoteDomainInfo) {
            this.remoteDomainInfo = remoteDomainInfo;
            return this;
        }

        public final String getConnectionId() {
            return connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final InboundConnectionStatus.Builder getConnectionStatus() {
            return connectionStatus != null ? connectionStatus.toBuilder() : null;
        }

        public final void setConnectionStatus(InboundConnectionStatus.BuilderImpl connectionStatus) {
            this.connectionStatus = connectionStatus != null ? connectionStatus.build() : null;
        }

        @Override
        public final Builder connectionStatus(InboundConnectionStatus connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        @Override
        public InboundConnection build() {
            return new InboundConnection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
