/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for information about an OpenSearch Service domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainInformationContainer implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainInformationContainer.Builder, DomainInformationContainer> {
    private static final SdkField<AWSDomainInformation> AWS_DOMAIN_INFORMATION_FIELD = SdkField
            .<AWSDomainInformation> builder(MarshallingType.SDK_POJO).memberName("AWSDomainInformation")
            .getter(getter(DomainInformationContainer::awsDomainInformation)).setter(setter(Builder::awsDomainInformation))
            .constructor(AWSDomainInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSDomainInformation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_DOMAIN_INFORMATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AWSDomainInformation awsDomainInformation;

    private DomainInformationContainer(BuilderImpl builder) {
        this.awsDomainInformation = builder.awsDomainInformation;
    }

    /**
     * <p>
     * Information about an Amazon OpenSearch Service domain.
     * </p>
     * 
     * @return Information about an Amazon OpenSearch Service domain.
     */
    public final AWSDomainInformation awsDomainInformation() {
        return awsDomainInformation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsDomainInformation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainInformationContainer)) {
            return false;
        }
        DomainInformationContainer other = (DomainInformationContainer) obj;
        return Objects.equals(awsDomainInformation(), other.awsDomainInformation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainInformationContainer").add("AWSDomainInformation", awsDomainInformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AWSDomainInformation":
            return Optional.ofNullable(clazz.cast(awsDomainInformation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainInformationContainer, T> g) {
        return obj -> g.apply((DomainInformationContainer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainInformationContainer> {
        /**
         * <p>
         * Information about an Amazon OpenSearch Service domain.
         * </p>
         * 
         * @param awsDomainInformation
         *        Information about an Amazon OpenSearch Service domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsDomainInformation(AWSDomainInformation awsDomainInformation);

        /**
         * <p>
         * Information about an Amazon OpenSearch Service domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link AWSDomainInformation.Builder} avoiding
         * the need to create one manually via {@link AWSDomainInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AWSDomainInformation.Builder#build()} is called immediately and
         * its result is passed to {@link #awsDomainInformation(AWSDomainInformation)}.
         * 
         * @param awsDomainInformation
         *        a consumer that will call methods on {@link AWSDomainInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsDomainInformation(AWSDomainInformation)
         */
        default Builder awsDomainInformation(Consumer<AWSDomainInformation.Builder> awsDomainInformation) {
            return awsDomainInformation(AWSDomainInformation.builder().applyMutation(awsDomainInformation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AWSDomainInformation awsDomainInformation;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainInformationContainer model) {
            awsDomainInformation(model.awsDomainInformation);
        }

        public final AWSDomainInformation.Builder getAwsDomainInformation() {
            return awsDomainInformation != null ? awsDomainInformation.toBuilder() : null;
        }

        public final void setAwsDomainInformation(AWSDomainInformation.BuilderImpl awsDomainInformation) {
            this.awsDomainInformation = awsDomainInformation != null ? awsDomainInformation.build() : null;
        }

        @Override
        public final Builder awsDomainInformation(AWSDomainInformation awsDomainInformation) {
            this.awsDomainInformation = awsDomainInformation;
            return this;
        }

        @Override
        public DomainInformationContainer build() {
            return new DomainInformationContainer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
