/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Error information for an OpenSearch Serverless request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecyclePolicyErrorDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<LifecyclePolicyErrorDetail.Builder, LifecyclePolicyErrorDetail> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(LifecyclePolicyErrorDetail::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(LifecyclePolicyErrorDetail::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(LifecyclePolicyErrorDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(LifecyclePolicyErrorDetail::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            ERROR_MESSAGE_FIELD, NAME_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String errorCode;

    private final String errorMessage;

    private final String name;

    private final String type;

    private LifecyclePolicyErrorDetail(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.name = builder.name;
        this.type = builder.type;
    }

    /**
     * <p>
     * The error code for the request. For example, <code>NOT_FOUND</code>.
     * </p>
     * 
     * @return The error code for the request. For example, <code>NOT_FOUND</code>.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * A description of the error. For example, <code>The specified Lifecycle Policy is not found</code>.
     * </p>
     * 
     * @return A description of the error. For example, <code>The specified Lifecycle Policy is not found</code>.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The name of the lifecycle policy.
     * </p>
     * 
     * @return The name of the lifecycle policy.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of lifecycle policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LifecyclePolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of lifecycle policy.
     * @see LifecyclePolicyType
     */
    public final LifecyclePolicyType type() {
        return LifecyclePolicyType.fromValue(type);
    }

    /**
     * <p>
     * The type of lifecycle policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LifecyclePolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of lifecycle policy.
     * @see LifecyclePolicyType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicyErrorDetail)) {
            return false;
        }
        LifecyclePolicyErrorDetail other = (LifecyclePolicyErrorDetail) obj;
        return Objects.equals(errorCode(), other.errorCode()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifecyclePolicyErrorDetail").add("ErrorCode", errorCode()).add("ErrorMessage", errorMessage())
                .add("Name", name()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicyErrorDetail, T> g) {
        return obj -> g.apply((LifecyclePolicyErrorDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecyclePolicyErrorDetail> {
        /**
         * <p>
         * The error code for the request. For example, <code>NOT_FOUND</code>.
         * </p>
         * 
         * @param errorCode
         *        The error code for the request. For example, <code>NOT_FOUND</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * A description of the error. For example, <code>The specified Lifecycle Policy is not found</code>.
         * </p>
         * 
         * @param errorMessage
         *        A description of the error. For example, <code>The specified Lifecycle Policy is not found</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The name of the lifecycle policy.
         * </p>
         * 
         * @param name
         *        The name of the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of lifecycle policy.
         * </p>
         * 
         * @param type
         *        The type of lifecycle policy.
         * @see LifecyclePolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of lifecycle policy.
         * </p>
         * 
         * @param type
         *        The type of lifecycle policy.
         * @see LifecyclePolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyType
         */
        Builder type(LifecyclePolicyType type);
    }

    static final class BuilderImpl implements Builder {
        private String errorCode;

        private String errorMessage;

        private String name;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicyErrorDetail model) {
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
            name(model.name);
            type(model.type);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LifecyclePolicyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public LifecyclePolicyErrorDetail build() {
            return new LifecyclePolicyErrorDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
