/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLifecyclePoliciesRequest extends OpenSearchServerlessRequest implements
        ToCopyableBuilder<ListLifecyclePoliciesRequest.Builder, ListLifecyclePoliciesRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListLifecyclePoliciesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListLifecyclePoliciesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<String>> RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resources")
            .getter(getter(ListLifecyclePoliciesRequest::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ListLifecyclePoliciesRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, RESOURCES_FIELD, TYPE_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> resources;

    private final String type;

    private ListLifecyclePoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.resources = builder.resources;
        this.type = builder.type;
    }

    /**
     * <p>
     * An optional parameter that specifies the maximum number of results to return. You can use use
     * <code>nextToken</code> to get the next page of results. The default is 10.
     * </p>
     * 
     * @return An optional parameter that specifies the maximum number of results to return. You can use use
     *         <code>nextToken</code> to get the next page of results. The default is 10.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If your initial <code>ListLifecyclePolicies</code> operation returns a <code>nextToken</code>, you can include
     * the returned <code>nextToken</code> in subsequent <code>ListLifecyclePolicies</code> operations, which returns
     * results in the next page.
     * </p>
     * 
     * @return If your initial <code>ListLifecyclePolicies</code> operation returns a <code>nextToken</code>, you can
     *         include the returned <code>nextToken</code> in subsequent <code>ListLifecyclePolicies</code> operations,
     *         which returns results in the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Resource filters that policies can apply to. Currently, the only supported resource type is <code>index</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return Resource filters that policies can apply to. Currently, the only supported resource type is
     *         <code>index</code>.
     */
    public final List<String> resources() {
        return resources;
    }

    /**
     * <p>
     * The type of lifecycle policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LifecyclePolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of lifecycle policy.
     * @see LifecyclePolicyType
     */
    public final LifecyclePolicyType type() {
        return LifecyclePolicyType.fromValue(type);
    }

    /**
     * <p>
     * The type of lifecycle policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LifecyclePolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of lifecycle policy.
     * @see LifecyclePolicyType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLifecyclePoliciesRequest)) {
            return false;
        }
        ListLifecyclePoliciesRequest other = (ListLifecyclePoliciesRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasResources() == other.hasResources() && Objects.equals(resources(), other.resources())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLifecyclePoliciesRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("Resources", hasResources() ? resources() : null).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLifecyclePoliciesRequest, T> g) {
        return obj -> g.apply((ListLifecyclePoliciesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchServerlessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListLifecyclePoliciesRequest> {
        /**
         * <p>
         * An optional parameter that specifies the maximum number of results to return. You can use use
         * <code>nextToken</code> to get the next page of results. The default is 10.
         * </p>
         * 
         * @param maxResults
         *        An optional parameter that specifies the maximum number of results to return. You can use use
         *        <code>nextToken</code> to get the next page of results. The default is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If your initial <code>ListLifecyclePolicies</code> operation returns a <code>nextToken</code>, you can
         * include the returned <code>nextToken</code> in subsequent <code>ListLifecyclePolicies</code> operations,
         * which returns results in the next page.
         * </p>
         * 
         * @param nextToken
         *        If your initial <code>ListLifecyclePolicies</code> operation returns a <code>nextToken</code>, you can
         *        include the returned <code>nextToken</code> in subsequent <code>ListLifecyclePolicies</code>
         *        operations, which returns results in the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Resource filters that policies can apply to. Currently, the only supported resource type is
         * <code>index</code>.
         * </p>
         * 
         * @param resources
         *        Resource filters that policies can apply to. Currently, the only supported resource type is
         *        <code>index</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<String> resources);

        /**
         * <p>
         * Resource filters that policies can apply to. Currently, the only supported resource type is
         * <code>index</code>.
         * </p>
         * 
         * @param resources
         *        Resource filters that policies can apply to. Currently, the only supported resource type is
         *        <code>index</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(String... resources);

        /**
         * <p>
         * The type of lifecycle policy.
         * </p>
         * 
         * @param type
         *        The type of lifecycle policy.
         * @see LifecyclePolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of lifecycle policy.
         * </p>
         * 
         * @param type
         *        The type of lifecycle policy.
         * @see LifecyclePolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyType
         */
        Builder type(LifecyclePolicyType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchServerlessRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private List<String> resources = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLifecyclePoliciesRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            resources(model.resources);
            type(model.type);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getResources() {
            if (resources instanceof SdkAutoConstructList) {
                return null;
            }
            return resources;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = ListLifecyclePoliciesRequestResourcesListCopier.copy(resources);
        }

        @Override
        public final Builder resources(Collection<String> resources) {
            this.resources = ListLifecyclePoliciesRequestResourcesListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(String... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LifecyclePolicyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLifecyclePoliciesRequest build() {
            return new ListLifecyclePoliciesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
