/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a policy, but does not include the content. To see the content of a policy, see
 * <a>DescribePolicy</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicySummary implements SdkPojo, Serializable, ToCopyableBuilder<PolicySummary.Builder, PolicySummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(PolicySummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(PolicySummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PolicySummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(PolicySummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(PolicySummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Boolean> AWS_MANAGED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AwsManaged").getter(getter(PolicySummary::awsManaged)).setter(setter(Builder::awsManaged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsManaged").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, AWS_MANAGED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String description;

    private final String type;

    private final Boolean awsManaged;

    private PolicySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.awsManaged = builder.awsManaged;
    }

    /**
     * <p>
     * The unique identifier (ID) of the policy.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed by
     * from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).
     * </p>
     * 
     * @return The unique identifier (ID) of the policy.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-"
     *         followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the policy.
     * </p>
     * <p>
     * For more information about ARNs in Organizations, see <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies"
     * >ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the policy.</p>
     *         <p>
     *         For more information about ARNs in Organizations, see <a href=
     *         "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies"
     *         >ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization
     *         Reference</i>.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The friendly name of the policy.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a
     * string of any of the characters in the ASCII character range.
     * </p>
     * 
     * @return The friendly name of the policy.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter
     *         is a string of any of the characters in the ASCII character range.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the policy.
     * </p>
     * 
     * @return The description of the policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of policy.
     * @see PolicyType
     */
    public final PolicyType type() {
        return PolicyType.fromValue(type);
    }

    /**
     * <p>
     * The type of policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of policy.
     * @see PolicyType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A boolean value that indicates whether the specified policy is an Amazon Web Services managed policy. If true,
     * then you can attach the policy to roots, OUs, or accounts, but you cannot edit it.
     * </p>
     * 
     * @return A boolean value that indicates whether the specified policy is an Amazon Web Services managed policy. If
     *         true, then you can attach the policy to roots, OUs, or accounts, but you cannot edit it.
     */
    public final Boolean awsManaged() {
        return awsManaged;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(awsManaged());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicySummary)) {
            return false;
        }
        PolicySummary other = (PolicySummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(awsManaged(), other.awsManaged());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicySummary").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("Description", description()).add("Type", typeAsString()).add("AwsManaged", awsManaged()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "AwsManaged":
            return Optional.ofNullable(clazz.cast(awsManaged()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicySummary, T> g) {
        return obj -> g.apply((PolicySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicySummary> {
        /**
         * <p>
         * The unique identifier (ID) of the policy.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-" followed
         * by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).
         * </p>
         * 
         * @param id
         *        The unique identifier (ID) of the policy.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> for a policy ID string requires "p-"
         *        followed by from 8 to 128 lowercase or uppercase letters, digits, or the underscore character (_).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the policy.
         * </p>
         * <p>
         * For more information about ARNs in Organizations, see <a href=
         * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies"
         * >ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization
         * Reference</i>.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the policy.</p>
         *        <p>
         *        For more information about ARNs in Organizations, see <a href=
         *        "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies"
         *        >ARN Formats Supported by Organizations</a> in the <i>Amazon Web Services Service Authorization
         *        Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The friendly name of the policy.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a
         * string of any of the characters in the ASCII character range.
         * </p>
         * 
         * @param name
         *        The friendly name of the policy.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this
         *        parameter is a string of any of the characters in the ASCII character range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the policy.
         * </p>
         * 
         * @param description
         *        The description of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of policy.
         * </p>
         * 
         * @param type
         *        The type of policy.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of policy.
         * </p>
         * 
         * @param type
         *        The type of policy.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder type(PolicyType type);

        /**
         * <p>
         * A boolean value that indicates whether the specified policy is an Amazon Web Services managed policy. If
         * true, then you can attach the policy to roots, OUs, or accounts, but you cannot edit it.
         * </p>
         * 
         * @param awsManaged
         *        A boolean value that indicates whether the specified policy is an Amazon Web Services managed policy.
         *        If true, then you can attach the policy to roots, OUs, or accounts, but you cannot edit it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsManaged(Boolean awsManaged);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String description;

        private String type;

        private Boolean awsManaged;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicySummary model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            description(model.description);
            type(model.type);
            awsManaged(model.awsManaged);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PolicyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Boolean getAwsManaged() {
            return awsManaged;
        }

        public final void setAwsManaged(Boolean awsManaged) {
            this.awsManaged = awsManaged;
        }

        @Override
        public final Builder awsManaged(Boolean awsManaged) {
            this.awsManaged = awsManaged;
            return this;
        }

        @Override
        public PolicySummary build() {
            return new PolicySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
