/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartConnectionRequest extends OutpostsRequest implements
        ToCopyableBuilder<StartConnectionRequest.Builder, StartConnectionRequest> {
    private static final SdkField<String> DEVICE_SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceSerialNumber").getter(getter(StartConnectionRequest::deviceSerialNumber))
            .setter(setter(Builder::deviceSerialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceSerialNumber").build())
            .build();

    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssetId").getter(getter(StartConnectionRequest::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetId").build()).build();

    private static final SdkField<String> CLIENT_PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientPublicKey").getter(getter(StartConnectionRequest::clientPublicKey))
            .setter(setter(Builder::clientPublicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientPublicKey").build()).build();

    private static final SdkField<Integer> NETWORK_INTERFACE_DEVICE_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NetworkInterfaceDeviceIndex")
            .getter(getter(StartConnectionRequest::networkInterfaceDeviceIndex))
            .setter(setter(Builder::networkInterfaceDeviceIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceDeviceIndex")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_SERIAL_NUMBER_FIELD,
            ASSET_ID_FIELD, CLIENT_PUBLIC_KEY_FIELD, NETWORK_INTERFACE_DEVICE_INDEX_FIELD));

    private final String deviceSerialNumber;

    private final String assetId;

    private final String clientPublicKey;

    private final Integer networkInterfaceDeviceIndex;

    private StartConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.deviceSerialNumber = builder.deviceSerialNumber;
        this.assetId = builder.assetId;
        this.clientPublicKey = builder.clientPublicKey;
        this.networkInterfaceDeviceIndex = builder.networkInterfaceDeviceIndex;
    }

    /**
     * <p>
     * The serial number of the dongle.
     * </p>
     * 
     * @return The serial number of the dongle.
     */
    public final String deviceSerialNumber() {
        return deviceSerialNumber;
    }

    /**
     * <p>
     * The ID of the Outpost server.
     * </p>
     * 
     * @return The ID of the Outpost server.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The public key of the client.
     * </p>
     * 
     * @return The public key of the client.
     */
    public final String clientPublicKey() {
        return clientPublicKey;
    }

    /**
     * <p>
     * The device index of the network interface on the Outpost server.
     * </p>
     * 
     * @return The device index of the network interface on the Outpost server.
     */
    public final Integer networkInterfaceDeviceIndex() {
        return networkInterfaceDeviceIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceSerialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(clientPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceDeviceIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartConnectionRequest)) {
            return false;
        }
        StartConnectionRequest other = (StartConnectionRequest) obj;
        return Objects.equals(deviceSerialNumber(), other.deviceSerialNumber()) && Objects.equals(assetId(), other.assetId())
                && Objects.equals(clientPublicKey(), other.clientPublicKey())
                && Objects.equals(networkInterfaceDeviceIndex(), other.networkInterfaceDeviceIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartConnectionRequest").add("DeviceSerialNumber", deviceSerialNumber())
                .add("AssetId", assetId()).add("ClientPublicKey", clientPublicKey())
                .add("NetworkInterfaceDeviceIndex", networkInterfaceDeviceIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceSerialNumber":
            return Optional.ofNullable(clazz.cast(deviceSerialNumber()));
        case "AssetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "ClientPublicKey":
            return Optional.ofNullable(clazz.cast(clientPublicKey()));
        case "NetworkInterfaceDeviceIndex":
            return Optional.ofNullable(clazz.cast(networkInterfaceDeviceIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartConnectionRequest, T> g) {
        return obj -> g.apply((StartConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartConnectionRequest> {
        /**
         * <p>
         * The serial number of the dongle.
         * </p>
         * 
         * @param deviceSerialNumber
         *        The serial number of the dongle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceSerialNumber(String deviceSerialNumber);

        /**
         * <p>
         * The ID of the Outpost server.
         * </p>
         * 
         * @param assetId
         *        The ID of the Outpost server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The public key of the client.
         * </p>
         * 
         * @param clientPublicKey
         *        The public key of the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientPublicKey(String clientPublicKey);

        /**
         * <p>
         * The device index of the network interface on the Outpost server.
         * </p>
         * 
         * @param networkInterfaceDeviceIndex
         *        The device index of the network interface on the Outpost server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceDeviceIndex(Integer networkInterfaceDeviceIndex);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OutpostsRequest.BuilderImpl implements Builder {
        private String deviceSerialNumber;

        private String assetId;

        private String clientPublicKey;

        private Integer networkInterfaceDeviceIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(StartConnectionRequest model) {
            super(model);
            deviceSerialNumber(model.deviceSerialNumber);
            assetId(model.assetId);
            clientPublicKey(model.clientPublicKey);
            networkInterfaceDeviceIndex(model.networkInterfaceDeviceIndex);
        }

        public final String getDeviceSerialNumber() {
            return deviceSerialNumber;
        }

        public final void setDeviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
        }

        @Override
        public final Builder deviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
            return this;
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getClientPublicKey() {
            return clientPublicKey;
        }

        public final void setClientPublicKey(String clientPublicKey) {
            this.clientPublicKey = clientPublicKey;
        }

        @Override
        public final Builder clientPublicKey(String clientPublicKey) {
            this.clientPublicKey = clientPublicKey;
            return this;
        }

        public final Integer getNetworkInterfaceDeviceIndex() {
            return networkInterfaceDeviceIndex;
        }

        public final void setNetworkInterfaceDeviceIndex(Integer networkInterfaceDeviceIndex) {
            this.networkInterfaceDeviceIndex = networkInterfaceDeviceIndex;
        }

        @Override
        public final Builder networkInterfaceDeviceIndex(Integer networkInterfaceDeviceIndex) {
            this.networkInterfaceDeviceIndex = networkInterfaceDeviceIndex;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartConnectionRequest build() {
            return new StartConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
