/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionDetails.Builder, ConnectionDetails> {
    private static final SdkField<String> CLIENT_PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientPublicKey").getter(getter(ConnectionDetails::clientPublicKey))
            .setter(setter(Builder::clientPublicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientPublicKey").build()).build();

    private static final SdkField<String> SERVER_PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerPublicKey").getter(getter(ConnectionDetails::serverPublicKey))
            .setter(setter(Builder::serverPublicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerPublicKey").build()).build();

    private static final SdkField<String> SERVER_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerEndpoint").getter(getter(ConnectionDetails::serverEndpoint))
            .setter(setter(Builder::serverEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerEndpoint").build()).build();

    private static final SdkField<String> CLIENT_TUNNEL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientTunnelAddress").getter(getter(ConnectionDetails::clientTunnelAddress))
            .setter(setter(Builder::clientTunnelAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientTunnelAddress").build())
            .build();

    private static final SdkField<String> SERVER_TUNNEL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerTunnelAddress").getter(getter(ConnectionDetails::serverTunnelAddress))
            .setter(setter(Builder::serverTunnelAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerTunnelAddress").build())
            .build();

    private static final SdkField<List<String>> ALLOWED_IPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedIps")
            .getter(getter(ConnectionDetails::allowedIps))
            .setter(setter(Builder::allowedIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedIps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_PUBLIC_KEY_FIELD,
            SERVER_PUBLIC_KEY_FIELD, SERVER_ENDPOINT_FIELD, CLIENT_TUNNEL_ADDRESS_FIELD, SERVER_TUNNEL_ADDRESS_FIELD,
            ALLOWED_IPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientPublicKey;

    private final String serverPublicKey;

    private final String serverEndpoint;

    private final String clientTunnelAddress;

    private final String serverTunnelAddress;

    private final List<String> allowedIps;

    private ConnectionDetails(BuilderImpl builder) {
        this.clientPublicKey = builder.clientPublicKey;
        this.serverPublicKey = builder.serverPublicKey;
        this.serverEndpoint = builder.serverEndpoint;
        this.clientTunnelAddress = builder.clientTunnelAddress;
        this.serverTunnelAddress = builder.serverTunnelAddress;
        this.allowedIps = builder.allowedIps;
    }

    /**
     * <p>
     * The public key of the client.
     * </p>
     * 
     * @return The public key of the client.
     */
    public final String clientPublicKey() {
        return clientPublicKey;
    }

    /**
     * <p>
     * The public key of the server.
     * </p>
     * 
     * @return The public key of the server.
     */
    public final String serverPublicKey() {
        return serverPublicKey;
    }

    /**
     * <p>
     * The endpoint for the server.
     * </p>
     * 
     * @return The endpoint for the server.
     */
    public final String serverEndpoint() {
        return serverEndpoint;
    }

    /**
     * <p>
     * The client tunnel address.
     * </p>
     * 
     * @return The client tunnel address.
     */
    public final String clientTunnelAddress() {
        return clientTunnelAddress;
    }

    /**
     * <p>
     * The server tunnel address.
     * </p>
     * 
     * @return The server tunnel address.
     */
    public final String serverTunnelAddress() {
        return serverTunnelAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedIps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAllowedIps() {
        return allowedIps != null && !(allowedIps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The allowed IP addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedIps} method.
     * </p>
     * 
     * @return The allowed IP addresses.
     */
    public final List<String> allowedIps() {
        return allowedIps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(serverPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(serverEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(clientTunnelAddress());
        hashCode = 31 * hashCode + Objects.hashCode(serverTunnelAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedIps() ? allowedIps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionDetails)) {
            return false;
        }
        ConnectionDetails other = (ConnectionDetails) obj;
        return Objects.equals(clientPublicKey(), other.clientPublicKey())
                && Objects.equals(serverPublicKey(), other.serverPublicKey())
                && Objects.equals(serverEndpoint(), other.serverEndpoint())
                && Objects.equals(clientTunnelAddress(), other.clientTunnelAddress())
                && Objects.equals(serverTunnelAddress(), other.serverTunnelAddress()) && hasAllowedIps() == other.hasAllowedIps()
                && Objects.equals(allowedIps(), other.allowedIps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionDetails").add("ClientPublicKey", clientPublicKey())
                .add("ServerPublicKey", serverPublicKey()).add("ServerEndpoint", serverEndpoint())
                .add("ClientTunnelAddress", clientTunnelAddress()).add("ServerTunnelAddress", serverTunnelAddress())
                .add("AllowedIps", hasAllowedIps() ? allowedIps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientPublicKey":
            return Optional.ofNullable(clazz.cast(clientPublicKey()));
        case "ServerPublicKey":
            return Optional.ofNullable(clazz.cast(serverPublicKey()));
        case "ServerEndpoint":
            return Optional.ofNullable(clazz.cast(serverEndpoint()));
        case "ClientTunnelAddress":
            return Optional.ofNullable(clazz.cast(clientTunnelAddress()));
        case "ServerTunnelAddress":
            return Optional.ofNullable(clazz.cast(serverTunnelAddress()));
        case "AllowedIps":
            return Optional.ofNullable(clazz.cast(allowedIps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionDetails, T> g) {
        return obj -> g.apply((ConnectionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionDetails> {
        /**
         * <p>
         * The public key of the client.
         * </p>
         * 
         * @param clientPublicKey
         *        The public key of the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientPublicKey(String clientPublicKey);

        /**
         * <p>
         * The public key of the server.
         * </p>
         * 
         * @param serverPublicKey
         *        The public key of the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverPublicKey(String serverPublicKey);

        /**
         * <p>
         * The endpoint for the server.
         * </p>
         * 
         * @param serverEndpoint
         *        The endpoint for the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverEndpoint(String serverEndpoint);

        /**
         * <p>
         * The client tunnel address.
         * </p>
         * 
         * @param clientTunnelAddress
         *        The client tunnel address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientTunnelAddress(String clientTunnelAddress);

        /**
         * <p>
         * The server tunnel address.
         * </p>
         * 
         * @param serverTunnelAddress
         *        The server tunnel address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverTunnelAddress(String serverTunnelAddress);

        /**
         * <p>
         * The allowed IP addresses.
         * </p>
         * 
         * @param allowedIps
         *        The allowed IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedIps(Collection<String> allowedIps);

        /**
         * <p>
         * The allowed IP addresses.
         * </p>
         * 
         * @param allowedIps
         *        The allowed IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedIps(String... allowedIps);
    }

    static final class BuilderImpl implements Builder {
        private String clientPublicKey;

        private String serverPublicKey;

        private String serverEndpoint;

        private String clientTunnelAddress;

        private String serverTunnelAddress;

        private List<String> allowedIps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionDetails model) {
            clientPublicKey(model.clientPublicKey);
            serverPublicKey(model.serverPublicKey);
            serverEndpoint(model.serverEndpoint);
            clientTunnelAddress(model.clientTunnelAddress);
            serverTunnelAddress(model.serverTunnelAddress);
            allowedIps(model.allowedIps);
        }

        public final String getClientPublicKey() {
            return clientPublicKey;
        }

        public final void setClientPublicKey(String clientPublicKey) {
            this.clientPublicKey = clientPublicKey;
        }

        @Override
        public final Builder clientPublicKey(String clientPublicKey) {
            this.clientPublicKey = clientPublicKey;
            return this;
        }

        public final String getServerPublicKey() {
            return serverPublicKey;
        }

        public final void setServerPublicKey(String serverPublicKey) {
            this.serverPublicKey = serverPublicKey;
        }

        @Override
        public final Builder serverPublicKey(String serverPublicKey) {
            this.serverPublicKey = serverPublicKey;
            return this;
        }

        public final String getServerEndpoint() {
            return serverEndpoint;
        }

        public final void setServerEndpoint(String serverEndpoint) {
            this.serverEndpoint = serverEndpoint;
        }

        @Override
        public final Builder serverEndpoint(String serverEndpoint) {
            this.serverEndpoint = serverEndpoint;
            return this;
        }

        public final String getClientTunnelAddress() {
            return clientTunnelAddress;
        }

        public final void setClientTunnelAddress(String clientTunnelAddress) {
            this.clientTunnelAddress = clientTunnelAddress;
        }

        @Override
        public final Builder clientTunnelAddress(String clientTunnelAddress) {
            this.clientTunnelAddress = clientTunnelAddress;
            return this;
        }

        public final String getServerTunnelAddress() {
            return serverTunnelAddress;
        }

        public final void setServerTunnelAddress(String serverTunnelAddress) {
            this.serverTunnelAddress = serverTunnelAddress;
        }

        @Override
        public final Builder serverTunnelAddress(String serverTunnelAddress) {
            this.serverTunnelAddress = serverTunnelAddress;
            return this;
        }

        public final Collection<String> getAllowedIps() {
            if (allowedIps instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedIps;
        }

        public final void setAllowedIps(Collection<String> allowedIps) {
            this.allowedIps = CIDRListCopier.copy(allowedIps);
        }

        @Override
        public final Builder allowedIps(Collection<String> allowedIps) {
            this.allowedIps = CIDRListCopier.copy(allowedIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedIps(String... allowedIps) {
            allowedIps(Arrays.asList(allowedIps));
            return this;
        }

        @Override
        public ConnectionDetails build() {
            return new ConnectionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
