/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Device implements SdkPojo, Serializable, ToCopyableBuilder<Device.Builder, Device> {
    private static final SdkField<String> BRAND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Brand")
            .getter(getter(Device::brandAsString)).setter(setter(Builder::brand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Brand").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(Device::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> CURRENT_SOFTWARE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentSoftware").getter(getter(Device::currentSoftware)).setter(setter(Builder::currentSoftware))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentSoftware").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Device::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DEVICE_AGGREGATED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceAggregatedStatus").getter(getter(Device::deviceAggregatedStatusAsString))
            .setter(setter(Builder::deviceAggregatedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceAggregatedStatus").build())
            .build();

    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(Device::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(Device::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<LatestDeviceJob> LATEST_DEVICE_JOB_FIELD = SdkField
            .<LatestDeviceJob> builder(MarshallingType.SDK_POJO).memberName("LatestDeviceJob")
            .getter(getter(Device::latestDeviceJob)).setter(setter(Builder::latestDeviceJob))
            .constructor(LatestDeviceJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestDeviceJob").build()).build();

    private static final SdkField<Instant> LEASE_EXPIRATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LeaseExpirationTime").getter(getter(Device::leaseExpirationTime))
            .setter(setter(Builder::leaseExpirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeaseExpirationTime").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Device::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PROVISIONING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningStatus").getter(getter(Device::provisioningStatusAsString))
            .setter(setter(Builder::provisioningStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningStatus").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(Device::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Device::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRAND_FIELD,
            CREATED_TIME_FIELD, CURRENT_SOFTWARE_FIELD, DESCRIPTION_FIELD, DEVICE_AGGREGATED_STATUS_FIELD, DEVICE_ID_FIELD,
            LAST_UPDATED_TIME_FIELD, LATEST_DEVICE_JOB_FIELD, LEASE_EXPIRATION_TIME_FIELD, NAME_FIELD, PROVISIONING_STATUS_FIELD,
            TAGS_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String brand;

    private final Instant createdTime;

    private final String currentSoftware;

    private final String description;

    private final String deviceAggregatedStatus;

    private final String deviceId;

    private final Instant lastUpdatedTime;

    private final LatestDeviceJob latestDeviceJob;

    private final Instant leaseExpirationTime;

    private final String name;

    private final String provisioningStatus;

    private final Map<String, String> tags;

    private final String type;

    private Device(BuilderImpl builder) {
        this.brand = builder.brand;
        this.createdTime = builder.createdTime;
        this.currentSoftware = builder.currentSoftware;
        this.description = builder.description;
        this.deviceAggregatedStatus = builder.deviceAggregatedStatus;
        this.deviceId = builder.deviceId;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.latestDeviceJob = builder.latestDeviceJob;
        this.leaseExpirationTime = builder.leaseExpirationTime;
        this.name = builder.name;
        this.provisioningStatus = builder.provisioningStatus;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    /**
     * <p>
     * The device's maker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #brand} will return
     * {@link DeviceBrand#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #brandAsString}.
     * </p>
     * 
     * @return The device's maker.
     * @see DeviceBrand
     */
    public final DeviceBrand brand() {
        return DeviceBrand.fromValue(brand);
    }

    /**
     * <p>
     * The device's maker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #brand} will return
     * {@link DeviceBrand#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #brandAsString}.
     * </p>
     * 
     * @return The device's maker.
     * @see DeviceBrand
     */
    public final String brandAsString() {
        return brand;
    }

    /**
     * <p>
     * When the device was created.
     * </p>
     * 
     * @return When the device was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * A device's current software.
     * </p>
     * 
     * @return A device's current software.
     */
    public final String currentSoftware() {
        return currentSoftware;
    }

    /**
     * <p>
     * A description for the device.
     * </p>
     * 
     * @return A description for the device.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A device's aggregated status. Including the device's connection status, provisioning status, and lease status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceAggregatedStatus} will return {@link DeviceAggregatedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deviceAggregatedStatusAsString}.
     * </p>
     * 
     * @return A device's aggregated status. Including the device's connection status, provisioning status, and lease
     *         status.
     * @see DeviceAggregatedStatus
     */
    public final DeviceAggregatedStatus deviceAggregatedStatus() {
        return DeviceAggregatedStatus.fromValue(deviceAggregatedStatus);
    }

    /**
     * <p>
     * A device's aggregated status. Including the device's connection status, provisioning status, and lease status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceAggregatedStatus} will return {@link DeviceAggregatedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deviceAggregatedStatusAsString}.
     * </p>
     * 
     * @return A device's aggregated status. Including the device's connection status, provisioning status, and lease
     *         status.
     * @see DeviceAggregatedStatus
     */
    public final String deviceAggregatedStatusAsString() {
        return deviceAggregatedStatus;
    }

    /**
     * <p>
     * The device's ID.
     * </p>
     * 
     * @return The device's ID.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * When the device was updated.
     * </p>
     * 
     * @return When the device was updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * A device's latest job. Includes the target image version, and the update job status.
     * </p>
     * 
     * @return A device's latest job. Includes the target image version, and the update job status.
     */
    public final LatestDeviceJob latestDeviceJob() {
        return latestDeviceJob;
    }

    /**
     * <p>
     * The device's lease expiration time.
     * </p>
     * 
     * @return The device's lease expiration time.
     */
    public final Instant leaseExpirationTime() {
        return leaseExpirationTime;
    }

    /**
     * <p>
     * The device's name.
     * </p>
     * 
     * @return The device's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The device's provisioning status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisioningStatus} will return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #provisioningStatusAsString}.
     * </p>
     * 
     * @return The device's provisioning status.
     * @see DeviceStatus
     */
    public final DeviceStatus provisioningStatus() {
        return DeviceStatus.fromValue(provisioningStatus);
    }

    /**
     * <p>
     * The device's provisioning status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisioningStatus} will return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #provisioningStatusAsString}.
     * </p>
     * 
     * @return The device's provisioning status.
     * @see DeviceStatus
     */
    public final String provisioningStatusAsString() {
        return provisioningStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The device's tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The device's tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The device's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The device's type.
     * @see DeviceType
     */
    public final DeviceType type() {
        return DeviceType.fromValue(type);
    }

    /**
     * <p>
     * The device's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The device's type.
     * @see DeviceType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(brandAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(currentSoftware());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deviceAggregatedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestDeviceJob());
        hashCode = 31 * hashCode + Objects.hashCode(leaseExpirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device) obj;
        return Objects.equals(brandAsString(), other.brandAsString()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(currentSoftware(), other.currentSoftware())
                && Objects.equals(description(), other.description())
                && Objects.equals(deviceAggregatedStatusAsString(), other.deviceAggregatedStatusAsString())
                && Objects.equals(deviceId(), other.deviceId()) && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(latestDeviceJob(), other.latestDeviceJob())
                && Objects.equals(leaseExpirationTime(), other.leaseExpirationTime()) && Objects.equals(name(), other.name())
                && Objects.equals(provisioningStatusAsString(), other.provisioningStatusAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Device").add("Brand", brandAsString()).add("CreatedTime", createdTime())
                .add("CurrentSoftware", currentSoftware()).add("Description", description())
                .add("DeviceAggregatedStatus", deviceAggregatedStatusAsString()).add("DeviceId", deviceId())
                .add("LastUpdatedTime", lastUpdatedTime()).add("LatestDeviceJob", latestDeviceJob())
                .add("LeaseExpirationTime", leaseExpirationTime()).add("Name", name())
                .add("ProvisioningStatus", provisioningStatusAsString()).add("Tags", hasTags() ? tags() : null)
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Brand":
            return Optional.ofNullable(clazz.cast(brandAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "CurrentSoftware":
            return Optional.ofNullable(clazz.cast(currentSoftware()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DeviceAggregatedStatus":
            return Optional.ofNullable(clazz.cast(deviceAggregatedStatusAsString()));
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "LatestDeviceJob":
            return Optional.ofNullable(clazz.cast(latestDeviceJob()));
        case "LeaseExpirationTime":
            return Optional.ofNullable(clazz.cast(leaseExpirationTime()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ProvisioningStatus":
            return Optional.ofNullable(clazz.cast(provisioningStatusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Device, T> g) {
        return obj -> g.apply((Device) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Device> {
        /**
         * <p>
         * The device's maker.
         * </p>
         * 
         * @param brand
         *        The device's maker.
         * @see DeviceBrand
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceBrand
         */
        Builder brand(String brand);

        /**
         * <p>
         * The device's maker.
         * </p>
         * 
         * @param brand
         *        The device's maker.
         * @see DeviceBrand
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceBrand
         */
        Builder brand(DeviceBrand brand);

        /**
         * <p>
         * When the device was created.
         * </p>
         * 
         * @param createdTime
         *        When the device was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * A device's current software.
         * </p>
         * 
         * @param currentSoftware
         *        A device's current software.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentSoftware(String currentSoftware);

        /**
         * <p>
         * A description for the device.
         * </p>
         * 
         * @param description
         *        A description for the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A device's aggregated status. Including the device's connection status, provisioning status, and lease
         * status.
         * </p>
         * 
         * @param deviceAggregatedStatus
         *        A device's aggregated status. Including the device's connection status, provisioning status, and lease
         *        status.
         * @see DeviceAggregatedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceAggregatedStatus
         */
        Builder deviceAggregatedStatus(String deviceAggregatedStatus);

        /**
         * <p>
         * A device's aggregated status. Including the device's connection status, provisioning status, and lease
         * status.
         * </p>
         * 
         * @param deviceAggregatedStatus
         *        A device's aggregated status. Including the device's connection status, provisioning status, and lease
         *        status.
         * @see DeviceAggregatedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceAggregatedStatus
         */
        Builder deviceAggregatedStatus(DeviceAggregatedStatus deviceAggregatedStatus);

        /**
         * <p>
         * The device's ID.
         * </p>
         * 
         * @param deviceId
         *        The device's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * When the device was updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        When the device was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * A device's latest job. Includes the target image version, and the update job status.
         * </p>
         * 
         * @param latestDeviceJob
         *        A device's latest job. Includes the target image version, and the update job status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestDeviceJob(LatestDeviceJob latestDeviceJob);

        /**
         * <p>
         * A device's latest job. Includes the target image version, and the update job status.
         * </p>
         * This is a convenience method that creates an instance of the {@link LatestDeviceJob.Builder} avoiding the
         * need to create one manually via {@link LatestDeviceJob#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LatestDeviceJob.Builder#build()} is called immediately and its
         * result is passed to {@link #latestDeviceJob(LatestDeviceJob)}.
         * 
         * @param latestDeviceJob
         *        a consumer that will call methods on {@link LatestDeviceJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestDeviceJob(LatestDeviceJob)
         */
        default Builder latestDeviceJob(Consumer<LatestDeviceJob.Builder> latestDeviceJob) {
            return latestDeviceJob(LatestDeviceJob.builder().applyMutation(latestDeviceJob).build());
        }

        /**
         * <p>
         * The device's lease expiration time.
         * </p>
         * 
         * @param leaseExpirationTime
         *        The device's lease expiration time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder leaseExpirationTime(Instant leaseExpirationTime);

        /**
         * <p>
         * The device's name.
         * </p>
         * 
         * @param name
         *        The device's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The device's provisioning status.
         * </p>
         * 
         * @param provisioningStatus
         *        The device's provisioning status.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder provisioningStatus(String provisioningStatus);

        /**
         * <p>
         * The device's provisioning status.
         * </p>
         * 
         * @param provisioningStatus
         *        The device's provisioning status.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder provisioningStatus(DeviceStatus provisioningStatus);

        /**
         * <p>
         * The device's tags.
         * </p>
         * 
         * @param tags
         *        The device's tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The device's type.
         * </p>
         * 
         * @param type
         *        The device's type.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder type(String type);

        /**
         * <p>
         * The device's type.
         * </p>
         * 
         * @param type
         *        The device's type.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder type(DeviceType type);
    }

    static final class BuilderImpl implements Builder {
        private String brand;

        private Instant createdTime;

        private String currentSoftware;

        private String description;

        private String deviceAggregatedStatus;

        private String deviceId;

        private Instant lastUpdatedTime;

        private LatestDeviceJob latestDeviceJob;

        private Instant leaseExpirationTime;

        private String name;

        private String provisioningStatus;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Device model) {
            brand(model.brand);
            createdTime(model.createdTime);
            currentSoftware(model.currentSoftware);
            description(model.description);
            deviceAggregatedStatus(model.deviceAggregatedStatus);
            deviceId(model.deviceId);
            lastUpdatedTime(model.lastUpdatedTime);
            latestDeviceJob(model.latestDeviceJob);
            leaseExpirationTime(model.leaseExpirationTime);
            name(model.name);
            provisioningStatus(model.provisioningStatus);
            tags(model.tags);
            type(model.type);
        }

        public final String getBrand() {
            return brand;
        }

        public final void setBrand(String brand) {
            this.brand = brand;
        }

        @Override
        public final Builder brand(String brand) {
            this.brand = brand;
            return this;
        }

        @Override
        public final Builder brand(DeviceBrand brand) {
            this.brand(brand == null ? null : brand.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getCurrentSoftware() {
            return currentSoftware;
        }

        public final void setCurrentSoftware(String currentSoftware) {
            this.currentSoftware = currentSoftware;
        }

        @Override
        public final Builder currentSoftware(String currentSoftware) {
            this.currentSoftware = currentSoftware;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDeviceAggregatedStatus() {
            return deviceAggregatedStatus;
        }

        public final void setDeviceAggregatedStatus(String deviceAggregatedStatus) {
            this.deviceAggregatedStatus = deviceAggregatedStatus;
        }

        @Override
        public final Builder deviceAggregatedStatus(String deviceAggregatedStatus) {
            this.deviceAggregatedStatus = deviceAggregatedStatus;
            return this;
        }

        @Override
        public final Builder deviceAggregatedStatus(DeviceAggregatedStatus deviceAggregatedStatus) {
            this.deviceAggregatedStatus(deviceAggregatedStatus == null ? null : deviceAggregatedStatus.toString());
            return this;
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final LatestDeviceJob.Builder getLatestDeviceJob() {
            return latestDeviceJob != null ? latestDeviceJob.toBuilder() : null;
        }

        public final void setLatestDeviceJob(LatestDeviceJob.BuilderImpl latestDeviceJob) {
            this.latestDeviceJob = latestDeviceJob != null ? latestDeviceJob.build() : null;
        }

        @Override
        public final Builder latestDeviceJob(LatestDeviceJob latestDeviceJob) {
            this.latestDeviceJob = latestDeviceJob;
            return this;
        }

        public final Instant getLeaseExpirationTime() {
            return leaseExpirationTime;
        }

        public final void setLeaseExpirationTime(Instant leaseExpirationTime) {
            this.leaseExpirationTime = leaseExpirationTime;
        }

        @Override
        public final Builder leaseExpirationTime(Instant leaseExpirationTime) {
            this.leaseExpirationTime = leaseExpirationTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvisioningStatus() {
            return provisioningStatus;
        }

        public final void setProvisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
        }

        @Override
        public final Builder provisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
            return this;
        }

        @Override
        public final Builder provisioningStatus(DeviceStatus provisioningStatus) {
            this.provisioningStatus(provisioningStatus == null ? null : provisioningStatus.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DeviceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Device build() {
            return new Device(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
