/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetParametersForImportRequest extends PaymentCryptographyRequest implements
        ToCopyableBuilder<GetParametersForImportRequest.Builder, GetParametersForImportRequest> {
    private static final SdkField<String> KEY_MATERIAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyMaterialType").getter(getter(GetParametersForImportRequest::keyMaterialTypeAsString))
            .setter(setter(Builder::keyMaterialType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMaterialType").build()).build();

    private static final SdkField<String> WRAPPING_KEY_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WrappingKeyAlgorithm").getter(getter(GetParametersForImportRequest::wrappingKeyAlgorithmAsString))
            .setter(setter(Builder::wrappingKeyAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeyAlgorithm").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_MATERIAL_TYPE_FIELD,
            WRAPPING_KEY_ALGORITHM_FIELD));

    private final String keyMaterialType;

    private final String wrappingKeyAlgorithm;

    private GetParametersForImportRequest(BuilderImpl builder) {
        super(builder);
        this.keyMaterialType = builder.keyMaterialType;
        this.wrappingKeyAlgorithm = builder.wrappingKeyAlgorithm;
    }

    /**
     * <p>
     * The method to use for key material import. Import token is only required for TR-34 WrappedKeyBlock (
     * <code>TR34_KEY_BLOCK</code>).
     * </p>
     * <p>
     * Import token is not required for TR-31, root public key cerificate or trusted public key certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyMaterialType}
     * will return {@link KeyMaterialType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #keyMaterialTypeAsString}.
     * </p>
     * 
     * @return The method to use for key material import. Import token is only required for TR-34 WrappedKeyBlock (
     *         <code>TR34_KEY_BLOCK</code>).</p>
     *         <p>
     *         Import token is not required for TR-31, root public key cerificate or trusted public key certificate.
     * @see KeyMaterialType
     */
    public final KeyMaterialType keyMaterialType() {
        return KeyMaterialType.fromValue(keyMaterialType);
    }

    /**
     * <p>
     * The method to use for key material import. Import token is only required for TR-34 WrappedKeyBlock (
     * <code>TR34_KEY_BLOCK</code>).
     * </p>
     * <p>
     * Import token is not required for TR-31, root public key cerificate or trusted public key certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyMaterialType}
     * will return {@link KeyMaterialType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #keyMaterialTypeAsString}.
     * </p>
     * 
     * @return The method to use for key material import. Import token is only required for TR-34 WrappedKeyBlock (
     *         <code>TR34_KEY_BLOCK</code>).</p>
     *         <p>
     *         Import token is not required for TR-31, root public key cerificate or trusted public key certificate.
     * @see KeyMaterialType
     */
    public final String keyMaterialTypeAsString() {
        return keyMaterialType;
    }

    /**
     * <p>
     * The wrapping key algorithm to generate a wrapping key certificate. This certificate wraps the key under import.
     * </p>
     * <p>
     * At this time, <code>RSA_2048</code>, <code>RSA_3072</code>, <code>RSA_4096</code> are the only allowed algorithms
     * for TR-34 WrappedKeyBlock import.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #wrappingKeyAlgorithm} will return {@link KeyAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #wrappingKeyAlgorithmAsString}.
     * </p>
     * 
     * @return The wrapping key algorithm to generate a wrapping key certificate. This certificate wraps the key under
     *         import.</p>
     *         <p>
     *         At this time, <code>RSA_2048</code>, <code>RSA_3072</code>, <code>RSA_4096</code> are the only allowed
     *         algorithms for TR-34 WrappedKeyBlock import.
     * @see KeyAlgorithm
     */
    public final KeyAlgorithm wrappingKeyAlgorithm() {
        return KeyAlgorithm.fromValue(wrappingKeyAlgorithm);
    }

    /**
     * <p>
     * The wrapping key algorithm to generate a wrapping key certificate. This certificate wraps the key under import.
     * </p>
     * <p>
     * At this time, <code>RSA_2048</code>, <code>RSA_3072</code>, <code>RSA_4096</code> are the only allowed algorithms
     * for TR-34 WrappedKeyBlock import.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #wrappingKeyAlgorithm} will return {@link KeyAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #wrappingKeyAlgorithmAsString}.
     * </p>
     * 
     * @return The wrapping key algorithm to generate a wrapping key certificate. This certificate wraps the key under
     *         import.</p>
     *         <p>
     *         At this time, <code>RSA_2048</code>, <code>RSA_3072</code>, <code>RSA_4096</code> are the only allowed
     *         algorithms for TR-34 WrappedKeyBlock import.
     * @see KeyAlgorithm
     */
    public final String wrappingKeyAlgorithmAsString() {
        return wrappingKeyAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyMaterialTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(wrappingKeyAlgorithmAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersForImportRequest)) {
            return false;
        }
        GetParametersForImportRequest other = (GetParametersForImportRequest) obj;
        return Objects.equals(keyMaterialTypeAsString(), other.keyMaterialTypeAsString())
                && Objects.equals(wrappingKeyAlgorithmAsString(), other.wrappingKeyAlgorithmAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetParametersForImportRequest").add("KeyMaterialType", keyMaterialTypeAsString())
                .add("WrappingKeyAlgorithm", wrappingKeyAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyMaterialType":
            return Optional.ofNullable(clazz.cast(keyMaterialTypeAsString()));
        case "WrappingKeyAlgorithm":
            return Optional.ofNullable(clazz.cast(wrappingKeyAlgorithmAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetParametersForImportRequest, T> g) {
        return obj -> g.apply((GetParametersForImportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PaymentCryptographyRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetParametersForImportRequest> {
        /**
         * <p>
         * The method to use for key material import. Import token is only required for TR-34 WrappedKeyBlock (
         * <code>TR34_KEY_BLOCK</code>).
         * </p>
         * <p>
         * Import token is not required for TR-31, root public key cerificate or trusted public key certificate.
         * </p>
         * 
         * @param keyMaterialType
         *        The method to use for key material import. Import token is only required for TR-34 WrappedKeyBlock (
         *        <code>TR34_KEY_BLOCK</code>).</p>
         *        <p>
         *        Import token is not required for TR-31, root public key cerificate or trusted public key certificate.
         * @see KeyMaterialType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyMaterialType
         */
        Builder keyMaterialType(String keyMaterialType);

        /**
         * <p>
         * The method to use for key material import. Import token is only required for TR-34 WrappedKeyBlock (
         * <code>TR34_KEY_BLOCK</code>).
         * </p>
         * <p>
         * Import token is not required for TR-31, root public key cerificate or trusted public key certificate.
         * </p>
         * 
         * @param keyMaterialType
         *        The method to use for key material import. Import token is only required for TR-34 WrappedKeyBlock (
         *        <code>TR34_KEY_BLOCK</code>).</p>
         *        <p>
         *        Import token is not required for TR-31, root public key cerificate or trusted public key certificate.
         * @see KeyMaterialType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyMaterialType
         */
        Builder keyMaterialType(KeyMaterialType keyMaterialType);

        /**
         * <p>
         * The wrapping key algorithm to generate a wrapping key certificate. This certificate wraps the key under
         * import.
         * </p>
         * <p>
         * At this time, <code>RSA_2048</code>, <code>RSA_3072</code>, <code>RSA_4096</code> are the only allowed
         * algorithms for TR-34 WrappedKeyBlock import.
         * </p>
         * 
         * @param wrappingKeyAlgorithm
         *        The wrapping key algorithm to generate a wrapping key certificate. This certificate wraps the key
         *        under import.</p>
         *        <p>
         *        At this time, <code>RSA_2048</code>, <code>RSA_3072</code>, <code>RSA_4096</code> are the only allowed
         *        algorithms for TR-34 WrappedKeyBlock import.
         * @see KeyAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyAlgorithm
         */
        Builder wrappingKeyAlgorithm(String wrappingKeyAlgorithm);

        /**
         * <p>
         * The wrapping key algorithm to generate a wrapping key certificate. This certificate wraps the key under
         * import.
         * </p>
         * <p>
         * At this time, <code>RSA_2048</code>, <code>RSA_3072</code>, <code>RSA_4096</code> are the only allowed
         * algorithms for TR-34 WrappedKeyBlock import.
         * </p>
         * 
         * @param wrappingKeyAlgorithm
         *        The wrapping key algorithm to generate a wrapping key certificate. This certificate wraps the key
         *        under import.</p>
         *        <p>
         *        At this time, <code>RSA_2048</code>, <code>RSA_3072</code>, <code>RSA_4096</code> are the only allowed
         *        algorithms for TR-34 WrappedKeyBlock import.
         * @see KeyAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyAlgorithm
         */
        Builder wrappingKeyAlgorithm(KeyAlgorithm wrappingKeyAlgorithm);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PaymentCryptographyRequest.BuilderImpl implements Builder {
        private String keyMaterialType;

        private String wrappingKeyAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersForImportRequest model) {
            super(model);
            keyMaterialType(model.keyMaterialType);
            wrappingKeyAlgorithm(model.wrappingKeyAlgorithm);
        }

        public final String getKeyMaterialType() {
            return keyMaterialType;
        }

        public final void setKeyMaterialType(String keyMaterialType) {
            this.keyMaterialType = keyMaterialType;
        }

        @Override
        public final Builder keyMaterialType(String keyMaterialType) {
            this.keyMaterialType = keyMaterialType;
            return this;
        }

        @Override
        public final Builder keyMaterialType(KeyMaterialType keyMaterialType) {
            this.keyMaterialType(keyMaterialType == null ? null : keyMaterialType.toString());
            return this;
        }

        public final String getWrappingKeyAlgorithm() {
            return wrappingKeyAlgorithm;
        }

        public final void setWrappingKeyAlgorithm(String wrappingKeyAlgorithm) {
            this.wrappingKeyAlgorithm = wrappingKeyAlgorithm;
        }

        @Override
        public final Builder wrappingKeyAlgorithm(String wrappingKeyAlgorithm) {
            this.wrappingKeyAlgorithm = wrappingKeyAlgorithm;
            return this;
        }

        @Override
        public final Builder wrappingKeyAlgorithm(KeyAlgorithm wrappingKeyAlgorithm) {
            this.wrappingKeyAlgorithm(wrappingKeyAlgorithm == null ? null : wrappingKeyAlgorithm.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetParametersForImportRequest build() {
            return new GetParametersForImportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
