/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Card data parameters that are required to generate a Card Security Code (CSC2) for an AMEX payment card.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmexCardSecurityCodeVersion2 implements SdkPojo, Serializable,
        ToCopyableBuilder<AmexCardSecurityCodeVersion2.Builder, AmexCardSecurityCodeVersion2> {
    private static final SdkField<String> CARD_EXPIRY_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CardExpiryDate").getter(getter(AmexCardSecurityCodeVersion2::cardExpiryDate))
            .setter(setter(Builder::cardExpiryDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CardExpiryDate").build()).build();

    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceCode").getter(getter(AmexCardSecurityCodeVersion2::serviceCode))
            .setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CARD_EXPIRY_DATE_FIELD,
            SERVICE_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cardExpiryDate;

    private final String serviceCode;

    private AmexCardSecurityCodeVersion2(BuilderImpl builder) {
        this.cardExpiryDate = builder.cardExpiryDate;
        this.serviceCode = builder.serviceCode;
    }

    /**
     * <p>
     * The expiry date of a payment card.
     * </p>
     * 
     * @return The expiry date of a payment card.
     */
    public final String cardExpiryDate() {
        return cardExpiryDate;
    }

    /**
     * <p>
     * The service code of the AMEX payment card. This is different from the Card Security Code (CSC).
     * </p>
     * 
     * @return The service code of the AMEX payment card. This is different from the Card Security Code (CSC).
     */
    public final String serviceCode() {
        return serviceCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cardExpiryDate());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmexCardSecurityCodeVersion2)) {
            return false;
        }
        AmexCardSecurityCodeVersion2 other = (AmexCardSecurityCodeVersion2) obj;
        return Objects.equals(cardExpiryDate(), other.cardExpiryDate()) && Objects.equals(serviceCode(), other.serviceCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmexCardSecurityCodeVersion2").add("CardExpiryDate", cardExpiryDate())
                .add("ServiceCode", serviceCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CardExpiryDate":
            return Optional.ofNullable(clazz.cast(cardExpiryDate()));
        case "ServiceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AmexCardSecurityCodeVersion2, T> g) {
        return obj -> g.apply((AmexCardSecurityCodeVersion2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmexCardSecurityCodeVersion2> {
        /**
         * <p>
         * The expiry date of a payment card.
         * </p>
         * 
         * @param cardExpiryDate
         *        The expiry date of a payment card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cardExpiryDate(String cardExpiryDate);

        /**
         * <p>
         * The service code of the AMEX payment card. This is different from the Card Security Code (CSC).
         * </p>
         * 
         * @param serviceCode
         *        The service code of the AMEX payment card. This is different from the Card Security Code (CSC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);
    }

    static final class BuilderImpl implements Builder {
        private String cardExpiryDate;

        private String serviceCode;

        private BuilderImpl() {
        }

        private BuilderImpl(AmexCardSecurityCodeVersion2 model) {
            cardExpiryDate(model.cardExpiryDate);
            serviceCode(model.serviceCode);
        }

        public final String getCardExpiryDate() {
            return cardExpiryDate;
        }

        public final void setCardExpiryDate(String cardExpiryDate) {
            this.cardExpiryDate = cardExpiryDate;
        }

        @Override
        public final Builder cardExpiryDate(String cardExpiryDate) {
            this.cardExpiryDate = cardExpiryDate;
            return this;
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        @Override
        public AmexCardSecurityCodeVersion2 build() {
            return new AmexCardSecurityCodeVersion2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
