/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters that are required to generate, translate, or verify PIN data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PinData implements SdkPojo, Serializable, ToCopyableBuilder<PinData.Builder, PinData> {
    private static final SdkField<String> PIN_OFFSET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PinOffset").getter(getter(PinData::pinOffset)).setter(setter(Builder::pinOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinOffset").build()).build();

    private static final SdkField<String> VERIFICATION_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VerificationValue").getter(getter(PinData::verificationValue))
            .setter(setter(Builder::verificationValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIN_OFFSET_FIELD,
            VERIFICATION_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pinOffset;

    private final String verificationValue;

    private final Type type;

    private PinData(BuilderImpl builder) {
        this.pinOffset = builder.pinOffset;
        this.verificationValue = builder.verificationValue;
        this.type = builder.type;
    }

    /**
     * <p>
     * The PIN offset value.
     * </p>
     * 
     * @return The PIN offset value.
     */
    public final String pinOffset() {
        return pinOffset;
    }

    /**
     * <p>
     * The unique data to identify a cardholder. In most cases, this is the same as cardholder's Primary Account Number
     * (PAN). If a value is not provided, it defaults to PAN.
     * </p>
     * 
     * @return The unique data to identify a cardholder. In most cases, this is the same as cardholder's Primary Account
     *         Number (PAN). If a value is not provided, it defaults to PAN.
     */
    public final String verificationValue() {
        return verificationValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pinOffset());
        hashCode = 31 * hashCode + Objects.hashCode(verificationValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PinData)) {
            return false;
        }
        PinData other = (PinData) obj;
        return Objects.equals(pinOffset(), other.pinOffset()) && Objects.equals(verificationValue(), other.verificationValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PinData").add("PinOffset", pinOffset()).add("VerificationValue", verificationValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PinOffset":
            return Optional.ofNullable(clazz.cast(pinOffset()));
        case "VerificationValue":
            return Optional.ofNullable(clazz.cast(verificationValue()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #pinOffset()} initialized to the given value.
     *
     * <p>
     * The PIN offset value.
     * </p>
     * 
     * @param pinOffset
     *        The PIN offset value.
     */
    public static PinData fromPinOffset(String pinOffset) {
        return builder().pinOffset(pinOffset).build();
    }

    /**
     * Create an instance of this class with {@link #verificationValue()} initialized to the given value.
     *
     * <p>
     * The unique data to identify a cardholder. In most cases, this is the same as cardholder's Primary Account Number
     * (PAN). If a value is not provided, it defaults to PAN.
     * </p>
     * 
     * @param verificationValue
     *        The unique data to identify a cardholder. In most cases, this is the same as cardholder's Primary Account
     *        Number (PAN). If a value is not provided, it defaults to PAN.
     */
    public static PinData fromVerificationValue(String verificationValue) {
        return builder().verificationValue(verificationValue).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PinData, T> g) {
        return obj -> g.apply((PinData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PinData> {
        /**
         * <p>
         * The PIN offset value.
         * </p>
         * 
         * @param pinOffset
         *        The PIN offset value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pinOffset(String pinOffset);

        /**
         * <p>
         * The unique data to identify a cardholder. In most cases, this is the same as cardholder's Primary Account
         * Number (PAN). If a value is not provided, it defaults to PAN.
         * </p>
         * 
         * @param verificationValue
         *        The unique data to identify a cardholder. In most cases, this is the same as cardholder's Primary
         *        Account Number (PAN). If a value is not provided, it defaults to PAN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationValue(String verificationValue);
    }

    static final class BuilderImpl implements Builder {
        private String pinOffset;

        private String verificationValue;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PinData model) {
            pinOffset(model.pinOffset);
            verificationValue(model.verificationValue);
        }

        public final String getPinOffset() {
            return pinOffset;
        }

        public final void setPinOffset(String pinOffset) {
            Object oldValue = this.pinOffset;
            this.pinOffset = pinOffset;
            handleUnionValueChange(Type.PIN_OFFSET, oldValue, this.pinOffset);
        }

        @Override
        public final Builder pinOffset(String pinOffset) {
            Object oldValue = this.pinOffset;
            this.pinOffset = pinOffset;
            handleUnionValueChange(Type.PIN_OFFSET, oldValue, this.pinOffset);
            return this;
        }

        public final String getVerificationValue() {
            return verificationValue;
        }

        public final void setVerificationValue(String verificationValue) {
            Object oldValue = this.verificationValue;
            this.verificationValue = verificationValue;
            handleUnionValueChange(Type.VERIFICATION_VALUE, oldValue, this.verificationValue);
        }

        @Override
        public final Builder verificationValue(String verificationValue) {
            Object oldValue = this.verificationValue;
            this.verificationValue = verificationValue;
            handleUnionValueChange(Type.VERIFICATION_VALUE, oldValue, this.verificationValue);
            return this;
        }

        @Override
        public PinData build() {
            return new PinData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PinData#type()
     */
    public enum Type {
        PIN_OFFSET,

        VERIFICATION_VALUE,

        UNKNOWN_TO_SDK_VERSION
    }
}
