/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters that are required for translation between ISO9564 PIN block formats 0,1,3,4.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TranslationIsoFormats implements SdkPojo, Serializable,
        ToCopyableBuilder<TranslationIsoFormats.Builder, TranslationIsoFormats> {
    private static final SdkField<TranslationPinDataIsoFormat034> ISO_FORMAT0_FIELD = SdkField
            .<TranslationPinDataIsoFormat034> builder(MarshallingType.SDK_POJO).memberName("IsoFormat0")
            .getter(getter(TranslationIsoFormats::isoFormat0)).setter(setter(Builder::isoFormat0))
            .constructor(TranslationPinDataIsoFormat034::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoFormat0").build()).build();

    private static final SdkField<TranslationPinDataIsoFormat1> ISO_FORMAT1_FIELD = SdkField
            .<TranslationPinDataIsoFormat1> builder(MarshallingType.SDK_POJO).memberName("IsoFormat1")
            .getter(getter(TranslationIsoFormats::isoFormat1)).setter(setter(Builder::isoFormat1))
            .constructor(TranslationPinDataIsoFormat1::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoFormat1").build()).build();

    private static final SdkField<TranslationPinDataIsoFormat034> ISO_FORMAT3_FIELD = SdkField
            .<TranslationPinDataIsoFormat034> builder(MarshallingType.SDK_POJO).memberName("IsoFormat3")
            .getter(getter(TranslationIsoFormats::isoFormat3)).setter(setter(Builder::isoFormat3))
            .constructor(TranslationPinDataIsoFormat034::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoFormat3").build()).build();

    private static final SdkField<TranslationPinDataIsoFormat034> ISO_FORMAT4_FIELD = SdkField
            .<TranslationPinDataIsoFormat034> builder(MarshallingType.SDK_POJO).memberName("IsoFormat4")
            .getter(getter(TranslationIsoFormats::isoFormat4)).setter(setter(Builder::isoFormat4))
            .constructor(TranslationPinDataIsoFormat034::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoFormat4").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISO_FORMAT0_FIELD,
            ISO_FORMAT1_FIELD, ISO_FORMAT3_FIELD, ISO_FORMAT4_FIELD));

    private static final long serialVersionUID = 1L;

    private final TranslationPinDataIsoFormat034 isoFormat0;

    private final TranslationPinDataIsoFormat1 isoFormat1;

    private final TranslationPinDataIsoFormat034 isoFormat3;

    private final TranslationPinDataIsoFormat034 isoFormat4;

    private final Type type;

    private TranslationIsoFormats(BuilderImpl builder) {
        this.isoFormat0 = builder.isoFormat0;
        this.isoFormat1 = builder.isoFormat1;
        this.isoFormat3 = builder.isoFormat3;
        this.isoFormat4 = builder.isoFormat4;
        this.type = builder.type;
    }

    /**
     * <p>
     * Parameters that are required for ISO9564 PIN format 0 tranlation.
     * </p>
     * 
     * @return Parameters that are required for ISO9564 PIN format 0 tranlation.
     */
    public final TranslationPinDataIsoFormat034 isoFormat0() {
        return isoFormat0;
    }

    /**
     * <p>
     * Parameters that are required for ISO9564 PIN format 1 tranlation.
     * </p>
     * 
     * @return Parameters that are required for ISO9564 PIN format 1 tranlation.
     */
    public final TranslationPinDataIsoFormat1 isoFormat1() {
        return isoFormat1;
    }

    /**
     * <p>
     * Parameters that are required for ISO9564 PIN format 3 tranlation.
     * </p>
     * 
     * @return Parameters that are required for ISO9564 PIN format 3 tranlation.
     */
    public final TranslationPinDataIsoFormat034 isoFormat3() {
        return isoFormat3;
    }

    /**
     * <p>
     * Parameters that are required for ISO9564 PIN format 4 tranlation.
     * </p>
     * 
     * @return Parameters that are required for ISO9564 PIN format 4 tranlation.
     */
    public final TranslationPinDataIsoFormat034 isoFormat4() {
        return isoFormat4;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isoFormat0());
        hashCode = 31 * hashCode + Objects.hashCode(isoFormat1());
        hashCode = 31 * hashCode + Objects.hashCode(isoFormat3());
        hashCode = 31 * hashCode + Objects.hashCode(isoFormat4());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranslationIsoFormats)) {
            return false;
        }
        TranslationIsoFormats other = (TranslationIsoFormats) obj;
        return Objects.equals(isoFormat0(), other.isoFormat0()) && Objects.equals(isoFormat1(), other.isoFormat1())
                && Objects.equals(isoFormat3(), other.isoFormat3()) && Objects.equals(isoFormat4(), other.isoFormat4());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TranslationIsoFormats").add("IsoFormat0", isoFormat0()).add("IsoFormat1", isoFormat1())
                .add("IsoFormat3", isoFormat3()).add("IsoFormat4", isoFormat4()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsoFormat0":
            return Optional.ofNullable(clazz.cast(isoFormat0()));
        case "IsoFormat1":
            return Optional.ofNullable(clazz.cast(isoFormat1()));
        case "IsoFormat3":
            return Optional.ofNullable(clazz.cast(isoFormat3()));
        case "IsoFormat4":
            return Optional.ofNullable(clazz.cast(isoFormat4()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #isoFormat0()} initialized to the given value.
     *
     * <p>
     * Parameters that are required for ISO9564 PIN format 0 tranlation.
     * </p>
     * 
     * @param isoFormat0
     *        Parameters that are required for ISO9564 PIN format 0 tranlation.
     */
    public static TranslationIsoFormats fromIsoFormat0(TranslationPinDataIsoFormat034 isoFormat0) {
        return builder().isoFormat0(isoFormat0).build();
    }

    /**
     * Create an instance of this class with {@link #isoFormat0()} initialized to the given value.
     *
     * <p>
     * Parameters that are required for ISO9564 PIN format 0 tranlation.
     * </p>
     * 
     * @param isoFormat0
     *        Parameters that are required for ISO9564 PIN format 0 tranlation.
     */
    public static TranslationIsoFormats fromIsoFormat0(Consumer<TranslationPinDataIsoFormat034.Builder> isoFormat0) {
        TranslationPinDataIsoFormat034.Builder builder = TranslationPinDataIsoFormat034.builder();
        isoFormat0.accept(builder);
        return fromIsoFormat0(builder.build());
    }

    /**
     * Create an instance of this class with {@link #isoFormat1()} initialized to the given value.
     *
     * <p>
     * Parameters that are required for ISO9564 PIN format 1 tranlation.
     * </p>
     * 
     * @param isoFormat1
     *        Parameters that are required for ISO9564 PIN format 1 tranlation.
     */
    public static TranslationIsoFormats fromIsoFormat1(TranslationPinDataIsoFormat1 isoFormat1) {
        return builder().isoFormat1(isoFormat1).build();
    }

    /**
     * Create an instance of this class with {@link #isoFormat1()} initialized to the given value.
     *
     * <p>
     * Parameters that are required for ISO9564 PIN format 1 tranlation.
     * </p>
     * 
     * @param isoFormat1
     *        Parameters that are required for ISO9564 PIN format 1 tranlation.
     */
    public static TranslationIsoFormats fromIsoFormat1(Consumer<TranslationPinDataIsoFormat1.Builder> isoFormat1) {
        TranslationPinDataIsoFormat1.Builder builder = TranslationPinDataIsoFormat1.builder();
        isoFormat1.accept(builder);
        return fromIsoFormat1(builder.build());
    }

    /**
     * Create an instance of this class with {@link #isoFormat3()} initialized to the given value.
     *
     * <p>
     * Parameters that are required for ISO9564 PIN format 3 tranlation.
     * </p>
     * 
     * @param isoFormat3
     *        Parameters that are required for ISO9564 PIN format 3 tranlation.
     */
    public static TranslationIsoFormats fromIsoFormat3(TranslationPinDataIsoFormat034 isoFormat3) {
        return builder().isoFormat3(isoFormat3).build();
    }

    /**
     * Create an instance of this class with {@link #isoFormat3()} initialized to the given value.
     *
     * <p>
     * Parameters that are required for ISO9564 PIN format 3 tranlation.
     * </p>
     * 
     * @param isoFormat3
     *        Parameters that are required for ISO9564 PIN format 3 tranlation.
     */
    public static TranslationIsoFormats fromIsoFormat3(Consumer<TranslationPinDataIsoFormat034.Builder> isoFormat3) {
        TranslationPinDataIsoFormat034.Builder builder = TranslationPinDataIsoFormat034.builder();
        isoFormat3.accept(builder);
        return fromIsoFormat3(builder.build());
    }

    /**
     * Create an instance of this class with {@link #isoFormat4()} initialized to the given value.
     *
     * <p>
     * Parameters that are required for ISO9564 PIN format 4 tranlation.
     * </p>
     * 
     * @param isoFormat4
     *        Parameters that are required for ISO9564 PIN format 4 tranlation.
     */
    public static TranslationIsoFormats fromIsoFormat4(TranslationPinDataIsoFormat034 isoFormat4) {
        return builder().isoFormat4(isoFormat4).build();
    }

    /**
     * Create an instance of this class with {@link #isoFormat4()} initialized to the given value.
     *
     * <p>
     * Parameters that are required for ISO9564 PIN format 4 tranlation.
     * </p>
     * 
     * @param isoFormat4
     *        Parameters that are required for ISO9564 PIN format 4 tranlation.
     */
    public static TranslationIsoFormats fromIsoFormat4(Consumer<TranslationPinDataIsoFormat034.Builder> isoFormat4) {
        TranslationPinDataIsoFormat034.Builder builder = TranslationPinDataIsoFormat034.builder();
        isoFormat4.accept(builder);
        return fromIsoFormat4(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TranslationIsoFormats, T> g) {
        return obj -> g.apply((TranslationIsoFormats) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TranslationIsoFormats> {
        /**
         * <p>
         * Parameters that are required for ISO9564 PIN format 0 tranlation.
         * </p>
         * 
         * @param isoFormat0
         *        Parameters that are required for ISO9564 PIN format 0 tranlation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isoFormat0(TranslationPinDataIsoFormat034 isoFormat0);

        /**
         * <p>
         * Parameters that are required for ISO9564 PIN format 0 tranlation.
         * </p>
         * This is a convenience method that creates an instance of the {@link TranslationPinDataIsoFormat034.Builder}
         * avoiding the need to create one manually via {@link TranslationPinDataIsoFormat034#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TranslationPinDataIsoFormat034.Builder#build()} is called
         * immediately and its result is passed to {@link #isoFormat0(TranslationPinDataIsoFormat034)}.
         * 
         * @param isoFormat0
         *        a consumer that will call methods on {@link TranslationPinDataIsoFormat034.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #isoFormat0(TranslationPinDataIsoFormat034)
         */
        default Builder isoFormat0(Consumer<TranslationPinDataIsoFormat034.Builder> isoFormat0) {
            return isoFormat0(TranslationPinDataIsoFormat034.builder().applyMutation(isoFormat0).build());
        }

        /**
         * <p>
         * Parameters that are required for ISO9564 PIN format 1 tranlation.
         * </p>
         * 
         * @param isoFormat1
         *        Parameters that are required for ISO9564 PIN format 1 tranlation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isoFormat1(TranslationPinDataIsoFormat1 isoFormat1);

        /**
         * <p>
         * Parameters that are required for ISO9564 PIN format 1 tranlation.
         * </p>
         * This is a convenience method that creates an instance of the {@link TranslationPinDataIsoFormat1.Builder}
         * avoiding the need to create one manually via {@link TranslationPinDataIsoFormat1#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TranslationPinDataIsoFormat1.Builder#build()} is called
         * immediately and its result is passed to {@link #isoFormat1(TranslationPinDataIsoFormat1)}.
         * 
         * @param isoFormat1
         *        a consumer that will call methods on {@link TranslationPinDataIsoFormat1.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #isoFormat1(TranslationPinDataIsoFormat1)
         */
        default Builder isoFormat1(Consumer<TranslationPinDataIsoFormat1.Builder> isoFormat1) {
            return isoFormat1(TranslationPinDataIsoFormat1.builder().applyMutation(isoFormat1).build());
        }

        /**
         * <p>
         * Parameters that are required for ISO9564 PIN format 3 tranlation.
         * </p>
         * 
         * @param isoFormat3
         *        Parameters that are required for ISO9564 PIN format 3 tranlation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isoFormat3(TranslationPinDataIsoFormat034 isoFormat3);

        /**
         * <p>
         * Parameters that are required for ISO9564 PIN format 3 tranlation.
         * </p>
         * This is a convenience method that creates an instance of the {@link TranslationPinDataIsoFormat034.Builder}
         * avoiding the need to create one manually via {@link TranslationPinDataIsoFormat034#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TranslationPinDataIsoFormat034.Builder#build()} is called
         * immediately and its result is passed to {@link #isoFormat3(TranslationPinDataIsoFormat034)}.
         * 
         * @param isoFormat3
         *        a consumer that will call methods on {@link TranslationPinDataIsoFormat034.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #isoFormat3(TranslationPinDataIsoFormat034)
         */
        default Builder isoFormat3(Consumer<TranslationPinDataIsoFormat034.Builder> isoFormat3) {
            return isoFormat3(TranslationPinDataIsoFormat034.builder().applyMutation(isoFormat3).build());
        }

        /**
         * <p>
         * Parameters that are required for ISO9564 PIN format 4 tranlation.
         * </p>
         * 
         * @param isoFormat4
         *        Parameters that are required for ISO9564 PIN format 4 tranlation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isoFormat4(TranslationPinDataIsoFormat034 isoFormat4);

        /**
         * <p>
         * Parameters that are required for ISO9564 PIN format 4 tranlation.
         * </p>
         * This is a convenience method that creates an instance of the {@link TranslationPinDataIsoFormat034.Builder}
         * avoiding the need to create one manually via {@link TranslationPinDataIsoFormat034#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TranslationPinDataIsoFormat034.Builder#build()} is called
         * immediately and its result is passed to {@link #isoFormat4(TranslationPinDataIsoFormat034)}.
         * 
         * @param isoFormat4
         *        a consumer that will call methods on {@link TranslationPinDataIsoFormat034.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #isoFormat4(TranslationPinDataIsoFormat034)
         */
        default Builder isoFormat4(Consumer<TranslationPinDataIsoFormat034.Builder> isoFormat4) {
            return isoFormat4(TranslationPinDataIsoFormat034.builder().applyMutation(isoFormat4).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TranslationPinDataIsoFormat034 isoFormat0;

        private TranslationPinDataIsoFormat1 isoFormat1;

        private TranslationPinDataIsoFormat034 isoFormat3;

        private TranslationPinDataIsoFormat034 isoFormat4;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TranslationIsoFormats model) {
            isoFormat0(model.isoFormat0);
            isoFormat1(model.isoFormat1);
            isoFormat3(model.isoFormat3);
            isoFormat4(model.isoFormat4);
        }

        public final TranslationPinDataIsoFormat034.Builder getIsoFormat0() {
            return isoFormat0 != null ? isoFormat0.toBuilder() : null;
        }

        public final void setIsoFormat0(TranslationPinDataIsoFormat034.BuilderImpl isoFormat0) {
            Object oldValue = this.isoFormat0;
            this.isoFormat0 = isoFormat0 != null ? isoFormat0.build() : null;
            handleUnionValueChange(Type.ISO_FORMAT0, oldValue, this.isoFormat0);
        }

        @Override
        public final Builder isoFormat0(TranslationPinDataIsoFormat034 isoFormat0) {
            Object oldValue = this.isoFormat0;
            this.isoFormat0 = isoFormat0;
            handleUnionValueChange(Type.ISO_FORMAT0, oldValue, this.isoFormat0);
            return this;
        }

        public final TranslationPinDataIsoFormat1.Builder getIsoFormat1() {
            return isoFormat1 != null ? isoFormat1.toBuilder() : null;
        }

        public final void setIsoFormat1(TranslationPinDataIsoFormat1.BuilderImpl isoFormat1) {
            Object oldValue = this.isoFormat1;
            this.isoFormat1 = isoFormat1 != null ? isoFormat1.build() : null;
            handleUnionValueChange(Type.ISO_FORMAT1, oldValue, this.isoFormat1);
        }

        @Override
        public final Builder isoFormat1(TranslationPinDataIsoFormat1 isoFormat1) {
            Object oldValue = this.isoFormat1;
            this.isoFormat1 = isoFormat1;
            handleUnionValueChange(Type.ISO_FORMAT1, oldValue, this.isoFormat1);
            return this;
        }

        public final TranslationPinDataIsoFormat034.Builder getIsoFormat3() {
            return isoFormat3 != null ? isoFormat3.toBuilder() : null;
        }

        public final void setIsoFormat3(TranslationPinDataIsoFormat034.BuilderImpl isoFormat3) {
            Object oldValue = this.isoFormat3;
            this.isoFormat3 = isoFormat3 != null ? isoFormat3.build() : null;
            handleUnionValueChange(Type.ISO_FORMAT3, oldValue, this.isoFormat3);
        }

        @Override
        public final Builder isoFormat3(TranslationPinDataIsoFormat034 isoFormat3) {
            Object oldValue = this.isoFormat3;
            this.isoFormat3 = isoFormat3;
            handleUnionValueChange(Type.ISO_FORMAT3, oldValue, this.isoFormat3);
            return this;
        }

        public final TranslationPinDataIsoFormat034.Builder getIsoFormat4() {
            return isoFormat4 != null ? isoFormat4.toBuilder() : null;
        }

        public final void setIsoFormat4(TranslationPinDataIsoFormat034.BuilderImpl isoFormat4) {
            Object oldValue = this.isoFormat4;
            this.isoFormat4 = isoFormat4 != null ? isoFormat4.build() : null;
            handleUnionValueChange(Type.ISO_FORMAT4, oldValue, this.isoFormat4);
        }

        @Override
        public final Builder isoFormat4(TranslationPinDataIsoFormat034 isoFormat4) {
            Object oldValue = this.isoFormat4;
            this.isoFormat4 = isoFormat4;
            handleUnionValueChange(Type.ISO_FORMAT4, oldValue, this.isoFormat4);
            return this;
        }

        @Override
        public TranslationIsoFormats build() {
            return new TranslationIsoFormats(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see TranslationIsoFormats#type()
     */
    public enum Type {
        ISO_FORMAT0,

        ISO_FORMAT1,

        ISO_FORMAT3,

        ISO_FORMAT4,

        UNKNOWN_TO_SDK_VERSION
    }
}
