/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters that are required to generate or verify Dynamic Card Verification Value (dCVV).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DynamicCardVerificationValue implements SdkPojo, Serializable,
        ToCopyableBuilder<DynamicCardVerificationValue.Builder, DynamicCardVerificationValue> {
    private static final SdkField<String> APPLICATION_TRANSACTION_COUNTER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApplicationTransactionCounter")
            .getter(getter(DynamicCardVerificationValue::applicationTransactionCounter))
            .setter(setter(Builder::applicationTransactionCounter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationTransactionCounter")
                    .build()).build();

    private static final SdkField<String> CARD_EXPIRY_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CardExpiryDate").getter(getter(DynamicCardVerificationValue::cardExpiryDate))
            .setter(setter(Builder::cardExpiryDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CardExpiryDate").build()).build();

    private static final SdkField<String> PAN_SEQUENCE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PanSequenceNumber").getter(getter(DynamicCardVerificationValue::panSequenceNumber))
            .setter(setter(Builder::panSequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PanSequenceNumber").build()).build();

    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceCode").getter(getter(DynamicCardVerificationValue::serviceCode))
            .setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPLICATION_TRANSACTION_COUNTER_FIELD, CARD_EXPIRY_DATE_FIELD, PAN_SEQUENCE_NUMBER_FIELD, SERVICE_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationTransactionCounter;

    private final String cardExpiryDate;

    private final String panSequenceNumber;

    private final String serviceCode;

    private DynamicCardVerificationValue(BuilderImpl builder) {
        this.applicationTransactionCounter = builder.applicationTransactionCounter;
        this.cardExpiryDate = builder.cardExpiryDate;
        this.panSequenceNumber = builder.panSequenceNumber;
        this.serviceCode = builder.serviceCode;
    }

    /**
     * <p>
     * The transaction counter value that comes from the terminal.
     * </p>
     * 
     * @return The transaction counter value that comes from the terminal.
     */
    public final String applicationTransactionCounter() {
        return applicationTransactionCounter;
    }

    /**
     * <p>
     * The expiry date of a payment card.
     * </p>
     * 
     * @return The expiry date of a payment card.
     */
    public final String cardExpiryDate() {
        return cardExpiryDate;
    }

    /**
     * <p>
     * A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     * </p>
     * 
     * @return A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     */
    public final String panSequenceNumber() {
        return panSequenceNumber;
    }

    /**
     * <p>
     * The service code of the payment card. This is different from Card Security Code (CSC).
     * </p>
     * 
     * @return The service code of the payment card. This is different from Card Security Code (CSC).
     */
    public final String serviceCode() {
        return serviceCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationTransactionCounter());
        hashCode = 31 * hashCode + Objects.hashCode(cardExpiryDate());
        hashCode = 31 * hashCode + Objects.hashCode(panSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamicCardVerificationValue)) {
            return false;
        }
        DynamicCardVerificationValue other = (DynamicCardVerificationValue) obj;
        return Objects.equals(applicationTransactionCounter(), other.applicationTransactionCounter())
                && Objects.equals(cardExpiryDate(), other.cardExpiryDate())
                && Objects.equals(panSequenceNumber(), other.panSequenceNumber())
                && Objects.equals(serviceCode(), other.serviceCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DynamicCardVerificationValue")
                .add("ApplicationTransactionCounter", applicationTransactionCounter()).add("CardExpiryDate", cardExpiryDate())
                .add("PanSequenceNumber", panSequenceNumber()).add("ServiceCode", serviceCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationTransactionCounter":
            return Optional.ofNullable(clazz.cast(applicationTransactionCounter()));
        case "CardExpiryDate":
            return Optional.ofNullable(clazz.cast(cardExpiryDate()));
        case "PanSequenceNumber":
            return Optional.ofNullable(clazz.cast(panSequenceNumber()));
        case "ServiceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DynamicCardVerificationValue, T> g) {
        return obj -> g.apply((DynamicCardVerificationValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DynamicCardVerificationValue> {
        /**
         * <p>
         * The transaction counter value that comes from the terminal.
         * </p>
         * 
         * @param applicationTransactionCounter
         *        The transaction counter value that comes from the terminal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationTransactionCounter(String applicationTransactionCounter);

        /**
         * <p>
         * The expiry date of a payment card.
         * </p>
         * 
         * @param cardExpiryDate
         *        The expiry date of a payment card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cardExpiryDate(String cardExpiryDate);

        /**
         * <p>
         * A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
         * </p>
         * 
         * @param panSequenceNumber
         *        A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder panSequenceNumber(String panSequenceNumber);

        /**
         * <p>
         * The service code of the payment card. This is different from Card Security Code (CSC).
         * </p>
         * 
         * @param serviceCode
         *        The service code of the payment card. This is different from Card Security Code (CSC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);
    }

    static final class BuilderImpl implements Builder {
        private String applicationTransactionCounter;

        private String cardExpiryDate;

        private String panSequenceNumber;

        private String serviceCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamicCardVerificationValue model) {
            applicationTransactionCounter(model.applicationTransactionCounter);
            cardExpiryDate(model.cardExpiryDate);
            panSequenceNumber(model.panSequenceNumber);
            serviceCode(model.serviceCode);
        }

        public final String getApplicationTransactionCounter() {
            return applicationTransactionCounter;
        }

        public final void setApplicationTransactionCounter(String applicationTransactionCounter) {
            this.applicationTransactionCounter = applicationTransactionCounter;
        }

        @Override
        public final Builder applicationTransactionCounter(String applicationTransactionCounter) {
            this.applicationTransactionCounter = applicationTransactionCounter;
            return this;
        }

        public final String getCardExpiryDate() {
            return cardExpiryDate;
        }

        public final void setCardExpiryDate(String cardExpiryDate) {
            this.cardExpiryDate = cardExpiryDate;
        }

        @Override
        public final Builder cardExpiryDate(String cardExpiryDate) {
            this.cardExpiryDate = cardExpiryDate;
            return this;
        }

        public final String getPanSequenceNumber() {
            return panSequenceNumber;
        }

        public final void setPanSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
        }

        @Override
        public final Builder panSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
            return this;
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        @Override
        public DynamicCardVerificationValue build() {
            return new DynamicCardVerificationValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
