/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * v3 template schema that uses Key Storage Providers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateV3 implements SdkPojo, Serializable, ToCopyableBuilder<TemplateV3.Builder, TemplateV3> {
    private static final SdkField<CertificateValidity> CERTIFICATE_VALIDITY_FIELD = SdkField
            .<CertificateValidity> builder(MarshallingType.SDK_POJO).memberName("CertificateValidity")
            .getter(getter(TemplateV3::certificateValidity)).setter(setter(Builder::certificateValidity))
            .constructor(CertificateValidity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateValidity").build())
            .build();

    private static final SdkField<EnrollmentFlagsV3> ENROLLMENT_FLAGS_FIELD = SdkField
            .<EnrollmentFlagsV3> builder(MarshallingType.SDK_POJO).memberName("EnrollmentFlags")
            .getter(getter(TemplateV3::enrollmentFlags)).setter(setter(Builder::enrollmentFlags))
            .constructor(EnrollmentFlagsV3::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnrollmentFlags").build()).build();

    private static final SdkField<ExtensionsV3> EXTENSIONS_FIELD = SdkField.<ExtensionsV3> builder(MarshallingType.SDK_POJO)
            .memberName("Extensions").getter(getter(TemplateV3::extensions)).setter(setter(Builder::extensions))
            .constructor(ExtensionsV3::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Extensions").build()).build();

    private static final SdkField<GeneralFlagsV3> GENERAL_FLAGS_FIELD = SdkField
            .<GeneralFlagsV3> builder(MarshallingType.SDK_POJO).memberName("GeneralFlags")
            .getter(getter(TemplateV3::generalFlags)).setter(setter(Builder::generalFlags)).constructor(GeneralFlagsV3::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneralFlags").build()).build();

    private static final SdkField<String> HASH_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HashAlgorithm").getter(getter(TemplateV3::hashAlgorithmAsString)).setter(setter(Builder::hashAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HashAlgorithm").build()).build();

    private static final SdkField<PrivateKeyAttributesV3> PRIVATE_KEY_ATTRIBUTES_FIELD = SdkField
            .<PrivateKeyAttributesV3> builder(MarshallingType.SDK_POJO).memberName("PrivateKeyAttributes")
            .getter(getter(TemplateV3::privateKeyAttributes)).setter(setter(Builder::privateKeyAttributes))
            .constructor(PrivateKeyAttributesV3::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKeyAttributes").build())
            .build();

    private static final SdkField<PrivateKeyFlagsV3> PRIVATE_KEY_FLAGS_FIELD = SdkField
            .<PrivateKeyFlagsV3> builder(MarshallingType.SDK_POJO).memberName("PrivateKeyFlags")
            .getter(getter(TemplateV3::privateKeyFlags)).setter(setter(Builder::privateKeyFlags))
            .constructor(PrivateKeyFlagsV3::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKeyFlags").build()).build();

    private static final SdkField<SubjectNameFlagsV3> SUBJECT_NAME_FLAGS_FIELD = SdkField
            .<SubjectNameFlagsV3> builder(MarshallingType.SDK_POJO).memberName("SubjectNameFlags")
            .getter(getter(TemplateV3::subjectNameFlags)).setter(setter(Builder::subjectNameFlags))
            .constructor(SubjectNameFlagsV3::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectNameFlags").build()).build();

    private static final SdkField<List<String>> SUPERSEDED_TEMPLATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupersededTemplates")
            .getter(getter(TemplateV3::supersededTemplates))
            .setter(setter(Builder::supersededTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupersededTemplates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_VALIDITY_FIELD,
            ENROLLMENT_FLAGS_FIELD, EXTENSIONS_FIELD, GENERAL_FLAGS_FIELD, HASH_ALGORITHM_FIELD, PRIVATE_KEY_ATTRIBUTES_FIELD,
            PRIVATE_KEY_FLAGS_FIELD, SUBJECT_NAME_FLAGS_FIELD, SUPERSEDED_TEMPLATES_FIELD));

    private static final long serialVersionUID = 1L;

    private final CertificateValidity certificateValidity;

    private final EnrollmentFlagsV3 enrollmentFlags;

    private final ExtensionsV3 extensions;

    private final GeneralFlagsV3 generalFlags;

    private final String hashAlgorithm;

    private final PrivateKeyAttributesV3 privateKeyAttributes;

    private final PrivateKeyFlagsV3 privateKeyFlags;

    private final SubjectNameFlagsV3 subjectNameFlags;

    private final List<String> supersededTemplates;

    private TemplateV3(BuilderImpl builder) {
        this.certificateValidity = builder.certificateValidity;
        this.enrollmentFlags = builder.enrollmentFlags;
        this.extensions = builder.extensions;
        this.generalFlags = builder.generalFlags;
        this.hashAlgorithm = builder.hashAlgorithm;
        this.privateKeyAttributes = builder.privateKeyAttributes;
        this.privateKeyFlags = builder.privateKeyFlags;
        this.subjectNameFlags = builder.subjectNameFlags;
        this.supersededTemplates = builder.supersededTemplates;
    }

    /**
     * <p>
     * Certificate validity describes the validity and renewal periods of a certificate.
     * </p>
     * 
     * @return Certificate validity describes the validity and renewal periods of a certificate.
     */
    public final CertificateValidity certificateValidity() {
        return certificateValidity;
    }

    /**
     * <p>
     * Enrollment flags describe the enrollment settings for certificates such as using the existing private key and
     * deleting expired or revoked certificates.
     * </p>
     * 
     * @return Enrollment flags describe the enrollment settings for certificates such as using the existing private key
     *         and deleting expired or revoked certificates.
     */
    public final EnrollmentFlagsV3 enrollmentFlags() {
        return enrollmentFlags;
    }

    /**
     * <p>
     * Extensions describe the key usage extensions and application policies for a template.
     * </p>
     * 
     * @return Extensions describe the key usage extensions and application policies for a template.
     */
    public final ExtensionsV3 extensions() {
        return extensions;
    }

    /**
     * <p>
     * General flags describe whether the template is used for computers or users and if the template can be used with
     * autoenrollment.
     * </p>
     * 
     * @return General flags describe whether the template is used for computers or users and if the template can be
     *         used with autoenrollment.
     */
    public final GeneralFlagsV3 generalFlags() {
        return generalFlags;
    }

    /**
     * <p>
     * Specifies the hash algorithm used to hash the private key.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hashAlgorithm}
     * will return {@link HashAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hashAlgorithmAsString}.
     * </p>
     * 
     * @return Specifies the hash algorithm used to hash the private key.
     * @see HashAlgorithm
     */
    public final HashAlgorithm hashAlgorithm() {
        return HashAlgorithm.fromValue(hashAlgorithm);
    }

    /**
     * <p>
     * Specifies the hash algorithm used to hash the private key.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hashAlgorithm}
     * will return {@link HashAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hashAlgorithmAsString}.
     * </p>
     * 
     * @return Specifies the hash algorithm used to hash the private key.
     * @see HashAlgorithm
     */
    public final String hashAlgorithmAsString() {
        return hashAlgorithm;
    }

    /**
     * <p>
     * Private key attributes allow you to specify the algorithm, minimal key length, key spec, key usage, and
     * cryptographic providers for the private key of a certificate for v3 templates. V3 templates allow you to use Key
     * Storage Providers.
     * </p>
     * 
     * @return Private key attributes allow you to specify the algorithm, minimal key length, key spec, key usage, and
     *         cryptographic providers for the private key of a certificate for v3 templates. V3 templates allow you to
     *         use Key Storage Providers.
     */
    public final PrivateKeyAttributesV3 privateKeyAttributes() {
        return privateKeyAttributes;
    }

    /**
     * <p>
     * Private key flags for v3 templates specify the client compatibility, if the private key can be exported, if user
     * input is required when using a private key, and if an alternate signature algorithm should be used.
     * </p>
     * 
     * @return Private key flags for v3 templates specify the client compatibility, if the private key can be exported,
     *         if user input is required when using a private key, and if an alternate signature algorithm should be
     *         used.
     */
    public final PrivateKeyFlagsV3 privateKeyFlags() {
        return privateKeyFlags;
    }

    /**
     * <p>
     * Subject name flags describe the subject name and subject alternate name that is included in a certificate.
     * </p>
     * 
     * @return Subject name flags describe the subject name and subject alternate name that is included in a
     *         certificate.
     */
    public final SubjectNameFlagsV3 subjectNameFlags() {
        return subjectNameFlags;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupersededTemplates property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupersededTemplates() {
        return supersededTemplates != null && !(supersededTemplates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of templates in Active Directory that are superseded by this template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupersededTemplates} method.
     * </p>
     * 
     * @return List of templates in Active Directory that are superseded by this template.
     */
    public final List<String> supersededTemplates() {
        return supersededTemplates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateValidity());
        hashCode = 31 * hashCode + Objects.hashCode(enrollmentFlags());
        hashCode = 31 * hashCode + Objects.hashCode(extensions());
        hashCode = 31 * hashCode + Objects.hashCode(generalFlags());
        hashCode = 31 * hashCode + Objects.hashCode(hashAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(privateKeyAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(privateKeyFlags());
        hashCode = 31 * hashCode + Objects.hashCode(subjectNameFlags());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupersededTemplates() ? supersededTemplates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateV3)) {
            return false;
        }
        TemplateV3 other = (TemplateV3) obj;
        return Objects.equals(certificateValidity(), other.certificateValidity())
                && Objects.equals(enrollmentFlags(), other.enrollmentFlags()) && Objects.equals(extensions(), other.extensions())
                && Objects.equals(generalFlags(), other.generalFlags())
                && Objects.equals(hashAlgorithmAsString(), other.hashAlgorithmAsString())
                && Objects.equals(privateKeyAttributes(), other.privateKeyAttributes())
                && Objects.equals(privateKeyFlags(), other.privateKeyFlags())
                && Objects.equals(subjectNameFlags(), other.subjectNameFlags())
                && hasSupersededTemplates() == other.hasSupersededTemplates()
                && Objects.equals(supersededTemplates(), other.supersededTemplates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateV3").add("CertificateValidity", certificateValidity())
                .add("EnrollmentFlags", enrollmentFlags()).add("Extensions", extensions()).add("GeneralFlags", generalFlags())
                .add("HashAlgorithm", hashAlgorithmAsString()).add("PrivateKeyAttributes", privateKeyAttributes())
                .add("PrivateKeyFlags", privateKeyFlags()).add("SubjectNameFlags", subjectNameFlags())
                .add("SupersededTemplates", hasSupersededTemplates() ? supersededTemplates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateValidity":
            return Optional.ofNullable(clazz.cast(certificateValidity()));
        case "EnrollmentFlags":
            return Optional.ofNullable(clazz.cast(enrollmentFlags()));
        case "Extensions":
            return Optional.ofNullable(clazz.cast(extensions()));
        case "GeneralFlags":
            return Optional.ofNullable(clazz.cast(generalFlags()));
        case "HashAlgorithm":
            return Optional.ofNullable(clazz.cast(hashAlgorithmAsString()));
        case "PrivateKeyAttributes":
            return Optional.ofNullable(clazz.cast(privateKeyAttributes()));
        case "PrivateKeyFlags":
            return Optional.ofNullable(clazz.cast(privateKeyFlags()));
        case "SubjectNameFlags":
            return Optional.ofNullable(clazz.cast(subjectNameFlags()));
        case "SupersededTemplates":
            return Optional.ofNullable(clazz.cast(supersededTemplates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateV3, T> g) {
        return obj -> g.apply((TemplateV3) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateV3> {
        /**
         * <p>
         * Certificate validity describes the validity and renewal periods of a certificate.
         * </p>
         * 
         * @param certificateValidity
         *        Certificate validity describes the validity and renewal periods of a certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateValidity(CertificateValidity certificateValidity);

        /**
         * <p>
         * Certificate validity describes the validity and renewal periods of a certificate.
         * </p>
         * This is a convenience method that creates an instance of the {@link CertificateValidity.Builder} avoiding the
         * need to create one manually via {@link CertificateValidity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CertificateValidity.Builder#build()} is called immediately and
         * its result is passed to {@link #certificateValidity(CertificateValidity)}.
         * 
         * @param certificateValidity
         *        a consumer that will call methods on {@link CertificateValidity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificateValidity(CertificateValidity)
         */
        default Builder certificateValidity(Consumer<CertificateValidity.Builder> certificateValidity) {
            return certificateValidity(CertificateValidity.builder().applyMutation(certificateValidity).build());
        }

        /**
         * <p>
         * Enrollment flags describe the enrollment settings for certificates such as using the existing private key and
         * deleting expired or revoked certificates.
         * </p>
         * 
         * @param enrollmentFlags
         *        Enrollment flags describe the enrollment settings for certificates such as using the existing private
         *        key and deleting expired or revoked certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enrollmentFlags(EnrollmentFlagsV3 enrollmentFlags);

        /**
         * <p>
         * Enrollment flags describe the enrollment settings for certificates such as using the existing private key and
         * deleting expired or revoked certificates.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnrollmentFlagsV3.Builder} avoiding the
         * need to create one manually via {@link EnrollmentFlagsV3#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnrollmentFlagsV3.Builder#build()} is called immediately and its
         * result is passed to {@link #enrollmentFlags(EnrollmentFlagsV3)}.
         * 
         * @param enrollmentFlags
         *        a consumer that will call methods on {@link EnrollmentFlagsV3.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enrollmentFlags(EnrollmentFlagsV3)
         */
        default Builder enrollmentFlags(Consumer<EnrollmentFlagsV3.Builder> enrollmentFlags) {
            return enrollmentFlags(EnrollmentFlagsV3.builder().applyMutation(enrollmentFlags).build());
        }

        /**
         * <p>
         * Extensions describe the key usage extensions and application policies for a template.
         * </p>
         * 
         * @param extensions
         *        Extensions describe the key usage extensions and application policies for a template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extensions(ExtensionsV3 extensions);

        /**
         * <p>
         * Extensions describe the key usage extensions and application policies for a template.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExtensionsV3.Builder} avoiding the need
         * to create one manually via {@link ExtensionsV3#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExtensionsV3.Builder#build()} is called immediately and its
         * result is passed to {@link #extensions(ExtensionsV3)}.
         * 
         * @param extensions
         *        a consumer that will call methods on {@link ExtensionsV3.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extensions(ExtensionsV3)
         */
        default Builder extensions(Consumer<ExtensionsV3.Builder> extensions) {
            return extensions(ExtensionsV3.builder().applyMutation(extensions).build());
        }

        /**
         * <p>
         * General flags describe whether the template is used for computers or users and if the template can be used
         * with autoenrollment.
         * </p>
         * 
         * @param generalFlags
         *        General flags describe whether the template is used for computers or users and if the template can be
         *        used with autoenrollment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generalFlags(GeneralFlagsV3 generalFlags);

        /**
         * <p>
         * General flags describe whether the template is used for computers or users and if the template can be used
         * with autoenrollment.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeneralFlagsV3.Builder} avoiding the need
         * to create one manually via {@link GeneralFlagsV3#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeneralFlagsV3.Builder#build()} is called immediately and its
         * result is passed to {@link #generalFlags(GeneralFlagsV3)}.
         * 
         * @param generalFlags
         *        a consumer that will call methods on {@link GeneralFlagsV3.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generalFlags(GeneralFlagsV3)
         */
        default Builder generalFlags(Consumer<GeneralFlagsV3.Builder> generalFlags) {
            return generalFlags(GeneralFlagsV3.builder().applyMutation(generalFlags).build());
        }

        /**
         * <p>
         * Specifies the hash algorithm used to hash the private key.
         * </p>
         * 
         * @param hashAlgorithm
         *        Specifies the hash algorithm used to hash the private key.
         * @see HashAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HashAlgorithm
         */
        Builder hashAlgorithm(String hashAlgorithm);

        /**
         * <p>
         * Specifies the hash algorithm used to hash the private key.
         * </p>
         * 
         * @param hashAlgorithm
         *        Specifies the hash algorithm used to hash the private key.
         * @see HashAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HashAlgorithm
         */
        Builder hashAlgorithm(HashAlgorithm hashAlgorithm);

        /**
         * <p>
         * Private key attributes allow you to specify the algorithm, minimal key length, key spec, key usage, and
         * cryptographic providers for the private key of a certificate for v3 templates. V3 templates allow you to use
         * Key Storage Providers.
         * </p>
         * 
         * @param privateKeyAttributes
         *        Private key attributes allow you to specify the algorithm, minimal key length, key spec, key usage,
         *        and cryptographic providers for the private key of a certificate for v3 templates. V3 templates allow
         *        you to use Key Storage Providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKeyAttributes(PrivateKeyAttributesV3 privateKeyAttributes);

        /**
         * <p>
         * Private key attributes allow you to specify the algorithm, minimal key length, key spec, key usage, and
         * cryptographic providers for the private key of a certificate for v3 templates. V3 templates allow you to use
         * Key Storage Providers.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrivateKeyAttributesV3.Builder} avoiding
         * the need to create one manually via {@link PrivateKeyAttributesV3#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrivateKeyAttributesV3.Builder#build()} is called immediately and
         * its result is passed to {@link #privateKeyAttributes(PrivateKeyAttributesV3)}.
         * 
         * @param privateKeyAttributes
         *        a consumer that will call methods on {@link PrivateKeyAttributesV3.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateKeyAttributes(PrivateKeyAttributesV3)
         */
        default Builder privateKeyAttributes(Consumer<PrivateKeyAttributesV3.Builder> privateKeyAttributes) {
            return privateKeyAttributes(PrivateKeyAttributesV3.builder().applyMutation(privateKeyAttributes).build());
        }

        /**
         * <p>
         * Private key flags for v3 templates specify the client compatibility, if the private key can be exported, if
         * user input is required when using a private key, and if an alternate signature algorithm should be used.
         * </p>
         * 
         * @param privateKeyFlags
         *        Private key flags for v3 templates specify the client compatibility, if the private key can be
         *        exported, if user input is required when using a private key, and if an alternate signature algorithm
         *        should be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKeyFlags(PrivateKeyFlagsV3 privateKeyFlags);

        /**
         * <p>
         * Private key flags for v3 templates specify the client compatibility, if the private key can be exported, if
         * user input is required when using a private key, and if an alternate signature algorithm should be used.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrivateKeyFlagsV3.Builder} avoiding the
         * need to create one manually via {@link PrivateKeyFlagsV3#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrivateKeyFlagsV3.Builder#build()} is called immediately and its
         * result is passed to {@link #privateKeyFlags(PrivateKeyFlagsV3)}.
         * 
         * @param privateKeyFlags
         *        a consumer that will call methods on {@link PrivateKeyFlagsV3.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateKeyFlags(PrivateKeyFlagsV3)
         */
        default Builder privateKeyFlags(Consumer<PrivateKeyFlagsV3.Builder> privateKeyFlags) {
            return privateKeyFlags(PrivateKeyFlagsV3.builder().applyMutation(privateKeyFlags).build());
        }

        /**
         * <p>
         * Subject name flags describe the subject name and subject alternate name that is included in a certificate.
         * </p>
         * 
         * @param subjectNameFlags
         *        Subject name flags describe the subject name and subject alternate name that is included in a
         *        certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectNameFlags(SubjectNameFlagsV3 subjectNameFlags);

        /**
         * <p>
         * Subject name flags describe the subject name and subject alternate name that is included in a certificate.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubjectNameFlagsV3.Builder} avoiding the
         * need to create one manually via {@link SubjectNameFlagsV3#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubjectNameFlagsV3.Builder#build()} is called immediately and its
         * result is passed to {@link #subjectNameFlags(SubjectNameFlagsV3)}.
         * 
         * @param subjectNameFlags
         *        a consumer that will call methods on {@link SubjectNameFlagsV3.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subjectNameFlags(SubjectNameFlagsV3)
         */
        default Builder subjectNameFlags(Consumer<SubjectNameFlagsV3.Builder> subjectNameFlags) {
            return subjectNameFlags(SubjectNameFlagsV3.builder().applyMutation(subjectNameFlags).build());
        }

        /**
         * <p>
         * List of templates in Active Directory that are superseded by this template.
         * </p>
         * 
         * @param supersededTemplates
         *        List of templates in Active Directory that are superseded by this template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supersededTemplates(Collection<String> supersededTemplates);

        /**
         * <p>
         * List of templates in Active Directory that are superseded by this template.
         * </p>
         * 
         * @param supersededTemplates
         *        List of templates in Active Directory that are superseded by this template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supersededTemplates(String... supersededTemplates);
    }

    static final class BuilderImpl implements Builder {
        private CertificateValidity certificateValidity;

        private EnrollmentFlagsV3 enrollmentFlags;

        private ExtensionsV3 extensions;

        private GeneralFlagsV3 generalFlags;

        private String hashAlgorithm;

        private PrivateKeyAttributesV3 privateKeyAttributes;

        private PrivateKeyFlagsV3 privateKeyFlags;

        private SubjectNameFlagsV3 subjectNameFlags;

        private List<String> supersededTemplates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateV3 model) {
            certificateValidity(model.certificateValidity);
            enrollmentFlags(model.enrollmentFlags);
            extensions(model.extensions);
            generalFlags(model.generalFlags);
            hashAlgorithm(model.hashAlgorithm);
            privateKeyAttributes(model.privateKeyAttributes);
            privateKeyFlags(model.privateKeyFlags);
            subjectNameFlags(model.subjectNameFlags);
            supersededTemplates(model.supersededTemplates);
        }

        public final CertificateValidity.Builder getCertificateValidity() {
            return certificateValidity != null ? certificateValidity.toBuilder() : null;
        }

        public final void setCertificateValidity(CertificateValidity.BuilderImpl certificateValidity) {
            this.certificateValidity = certificateValidity != null ? certificateValidity.build() : null;
        }

        @Override
        public final Builder certificateValidity(CertificateValidity certificateValidity) {
            this.certificateValidity = certificateValidity;
            return this;
        }

        public final EnrollmentFlagsV3.Builder getEnrollmentFlags() {
            return enrollmentFlags != null ? enrollmentFlags.toBuilder() : null;
        }

        public final void setEnrollmentFlags(EnrollmentFlagsV3.BuilderImpl enrollmentFlags) {
            this.enrollmentFlags = enrollmentFlags != null ? enrollmentFlags.build() : null;
        }

        @Override
        public final Builder enrollmentFlags(EnrollmentFlagsV3 enrollmentFlags) {
            this.enrollmentFlags = enrollmentFlags;
            return this;
        }

        public final ExtensionsV3.Builder getExtensions() {
            return extensions != null ? extensions.toBuilder() : null;
        }

        public final void setExtensions(ExtensionsV3.BuilderImpl extensions) {
            this.extensions = extensions != null ? extensions.build() : null;
        }

        @Override
        public final Builder extensions(ExtensionsV3 extensions) {
            this.extensions = extensions;
            return this;
        }

        public final GeneralFlagsV3.Builder getGeneralFlags() {
            return generalFlags != null ? generalFlags.toBuilder() : null;
        }

        public final void setGeneralFlags(GeneralFlagsV3.BuilderImpl generalFlags) {
            this.generalFlags = generalFlags != null ? generalFlags.build() : null;
        }

        @Override
        public final Builder generalFlags(GeneralFlagsV3 generalFlags) {
            this.generalFlags = generalFlags;
            return this;
        }

        public final String getHashAlgorithm() {
            return hashAlgorithm;
        }

        public final void setHashAlgorithm(String hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
        }

        @Override
        public final Builder hashAlgorithm(String hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
            return this;
        }

        @Override
        public final Builder hashAlgorithm(HashAlgorithm hashAlgorithm) {
            this.hashAlgorithm(hashAlgorithm == null ? null : hashAlgorithm.toString());
            return this;
        }

        public final PrivateKeyAttributesV3.Builder getPrivateKeyAttributes() {
            return privateKeyAttributes != null ? privateKeyAttributes.toBuilder() : null;
        }

        public final void setPrivateKeyAttributes(PrivateKeyAttributesV3.BuilderImpl privateKeyAttributes) {
            this.privateKeyAttributes = privateKeyAttributes != null ? privateKeyAttributes.build() : null;
        }

        @Override
        public final Builder privateKeyAttributes(PrivateKeyAttributesV3 privateKeyAttributes) {
            this.privateKeyAttributes = privateKeyAttributes;
            return this;
        }

        public final PrivateKeyFlagsV3.Builder getPrivateKeyFlags() {
            return privateKeyFlags != null ? privateKeyFlags.toBuilder() : null;
        }

        public final void setPrivateKeyFlags(PrivateKeyFlagsV3.BuilderImpl privateKeyFlags) {
            this.privateKeyFlags = privateKeyFlags != null ? privateKeyFlags.build() : null;
        }

        @Override
        public final Builder privateKeyFlags(PrivateKeyFlagsV3 privateKeyFlags) {
            this.privateKeyFlags = privateKeyFlags;
            return this;
        }

        public final SubjectNameFlagsV3.Builder getSubjectNameFlags() {
            return subjectNameFlags != null ? subjectNameFlags.toBuilder() : null;
        }

        public final void setSubjectNameFlags(SubjectNameFlagsV3.BuilderImpl subjectNameFlags) {
            this.subjectNameFlags = subjectNameFlags != null ? subjectNameFlags.build() : null;
        }

        @Override
        public final Builder subjectNameFlags(SubjectNameFlagsV3 subjectNameFlags) {
            this.subjectNameFlags = subjectNameFlags;
            return this;
        }

        public final Collection<String> getSupersededTemplates() {
            if (supersededTemplates instanceof SdkAutoConstructList) {
                return null;
            }
            return supersededTemplates;
        }

        public final void setSupersededTemplates(Collection<String> supersededTemplates) {
            this.supersededTemplates = TemplateNameListCopier.copy(supersededTemplates);
        }

        @Override
        public final Builder supersededTemplates(Collection<String> supersededTemplates) {
            this.supersededTemplates = TemplateNameListCopier.copy(supersededTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supersededTemplates(String... supersededTemplates) {
            supersededTemplates(Arrays.asList(supersededTemplates));
            return this;
        }

        @Override
        public TemplateV3 build() {
            return new TemplateV3(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
