/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information describing the end of the validity period of the certificate. This parameter sets the “Not After” date
 * for the certificate. Certificate validity is the period of time during which a certificate is valid. Validity can be
 * expressed as an explicit date and time when the certificate expires, or as a span of time after issuance, stated in
 * hours, days, months, or years. For more information, see Validity in RFC 5280. This value is unaffected when
 * ValidityNotBefore is also specified. For example, if Validity is set to 20 days in the future, the certificate will
 * expire 20 days from issuance time regardless of the ValidityNotBefore value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidityPeriod implements SdkPojo, Serializable, ToCopyableBuilder<ValidityPeriod.Builder, ValidityPeriod> {
    private static final SdkField<Long> PERIOD_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Period")
            .getter(getter(ValidityPeriod::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()).build();

    private static final SdkField<String> PERIOD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PeriodType").getter(getter(ValidityPeriod::periodTypeAsString)).setter(setter(Builder::periodType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERIOD_FIELD,
            PERIOD_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long period;

    private final String periodType;

    private ValidityPeriod(BuilderImpl builder) {
        this.period = builder.period;
        this.periodType = builder.periodType;
    }

    /**
     * <p>
     * The numeric value for the validity period.
     * </p>
     * 
     * @return The numeric value for the validity period.
     */
    public final Long period() {
        return period;
    }

    /**
     * <p>
     * The unit of time. You can select hours, days, weeks, months, and years.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #periodType} will
     * return {@link ValidityPeriodType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodTypeAsString}.
     * </p>
     * 
     * @return The unit of time. You can select hours, days, weeks, months, and years.
     * @see ValidityPeriodType
     */
    public final ValidityPeriodType periodType() {
        return ValidityPeriodType.fromValue(periodType);
    }

    /**
     * <p>
     * The unit of time. You can select hours, days, weeks, months, and years.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #periodType} will
     * return {@link ValidityPeriodType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodTypeAsString}.
     * </p>
     * 
     * @return The unit of time. You can select hours, days, weeks, months, and years.
     * @see ValidityPeriodType
     */
    public final String periodTypeAsString() {
        return periodType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(periodTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidityPeriod)) {
            return false;
        }
        ValidityPeriod other = (ValidityPeriod) obj;
        return Objects.equals(period(), other.period()) && Objects.equals(periodTypeAsString(), other.periodTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidityPeriod").add("Period", period()).add("PeriodType", periodTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Period":
            return Optional.ofNullable(clazz.cast(period()));
        case "PeriodType":
            return Optional.ofNullable(clazz.cast(periodTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidityPeriod, T> g) {
        return obj -> g.apply((ValidityPeriod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidityPeriod> {
        /**
         * <p>
         * The numeric value for the validity period.
         * </p>
         * 
         * @param period
         *        The numeric value for the validity period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Long period);

        /**
         * <p>
         * The unit of time. You can select hours, days, weeks, months, and years.
         * </p>
         * 
         * @param periodType
         *        The unit of time. You can select hours, days, weeks, months, and years.
         * @see ValidityPeriodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidityPeriodType
         */
        Builder periodType(String periodType);

        /**
         * <p>
         * The unit of time. You can select hours, days, weeks, months, and years.
         * </p>
         * 
         * @param periodType
         *        The unit of time. You can select hours, days, weeks, months, and years.
         * @see ValidityPeriodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidityPeriodType
         */
        Builder periodType(ValidityPeriodType periodType);
    }

    static final class BuilderImpl implements Builder {
        private Long period;

        private String periodType;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidityPeriod model) {
            period(model.period);
            periodType(model.periodType);
        }

        public final Long getPeriod() {
            return period;
        }

        public final void setPeriod(Long period) {
            this.period = period;
        }

        @Override
        public final Builder period(Long period) {
            this.period = period;
            return this;
        }

        public final String getPeriodType() {
            return periodType;
        }

        public final void setPeriodType(String periodType) {
            this.periodType = periodType;
        }

        @Override
        public final Builder periodType(String periodType) {
            this.periodType = periodType;
            return this;
        }

        @Override
        public final Builder periodType(ValidityPeriodType periodType) {
            this.periodType(periodType == null ? null : periodType.toString());
            return this;
        }

        @Override
        public ValidityPeriod build() {
            return new ValidityPeriod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
