/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServicePrincipalNameRequest extends PcaConnectorAdRequest implements
        ToCopyableBuilder<CreateServicePrincipalNameRequest.Builder, CreateServicePrincipalNameRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateServicePrincipalNameRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorArn").getter(getter(CreateServicePrincipalNameRequest::connectorArn))
            .setter(setter(Builder::connectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConnectorArn").build()).build();

    private static final SdkField<String> DIRECTORY_REGISTRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryRegistrationArn").getter(getter(CreateServicePrincipalNameRequest::directoryRegistrationArn))
            .setter(setter(Builder::directoryRegistrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DirectoryRegistrationArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            CONNECTOR_ARN_FIELD, DIRECTORY_REGISTRATION_ARN_FIELD));

    private final String clientToken;

    private final String connectorArn;

    private final String directoryRegistrationArn;

    private CreateServicePrincipalNameRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.connectorArn = builder.connectorArn;
        this.directoryRegistrationArn = builder.directoryRegistrationArn;
    }

    /**
     * <p>
     * Idempotency token.
     * </p>
     * 
     * @return Idempotency token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that was returned when you called <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html"
     * >CreateConnector</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that was returned when you called <a
     *         href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html"
     *         >CreateConnector</a>.
     */
    public final String connectorArn() {
        return connectorArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that was returned when you called <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html"
     * >CreateDirectoryRegistration</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that was returned when you called <a
     *         href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html"
     *         >CreateDirectoryRegistration</a>.
     */
    public final String directoryRegistrationArn() {
        return directoryRegistrationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(directoryRegistrationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServicePrincipalNameRequest)) {
            return false;
        }
        CreateServicePrincipalNameRequest other = (CreateServicePrincipalNameRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(connectorArn(), other.connectorArn())
                && Objects.equals(directoryRegistrationArn(), other.directoryRegistrationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateServicePrincipalNameRequest").add("ClientToken", clientToken())
                .add("ConnectorArn", connectorArn()).add("DirectoryRegistrationArn", directoryRegistrationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ConnectorArn":
            return Optional.ofNullable(clazz.cast(connectorArn()));
        case "DirectoryRegistrationArn":
            return Optional.ofNullable(clazz.cast(directoryRegistrationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServicePrincipalNameRequest, T> g) {
        return obj -> g.apply((CreateServicePrincipalNameRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PcaConnectorAdRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateServicePrincipalNameRequest> {
        /**
         * <p>
         * Idempotency token.
         * </p>
         * 
         * @param clientToken
         *        Idempotency token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that was returned when you called <a
         * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html"
         * >CreateConnector</a>.
         * </p>
         * 
         * @param connectorArn
         *        The Amazon Resource Name (ARN) that was returned when you called <a
         *        href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html"
         *        >CreateConnector</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorArn(String connectorArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that was returned when you called <a href=
         * "https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html"
         * >CreateDirectoryRegistration</a>.
         * </p>
         * 
         * @param directoryRegistrationArn
         *        The Amazon Resource Name (ARN) that was returned when you called <a href=
         *        "https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html"
         *        >CreateDirectoryRegistration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryRegistrationArn(String directoryRegistrationArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PcaConnectorAdRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String connectorArn;

        private String directoryRegistrationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServicePrincipalNameRequest model) {
            super(model);
            clientToken(model.clientToken);
            connectorArn(model.connectorArn);
            directoryRegistrationArn(model.directoryRegistrationArn);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getConnectorArn() {
            return connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final String getDirectoryRegistrationArn() {
            return directoryRegistrationArn;
        }

        public final void setDirectoryRegistrationArn(String directoryRegistrationArn) {
            this.directoryRegistrationArn = directoryRegistrationArn;
        }

        @Override
        public final Builder directoryRegistrationArn(String directoryRegistrationArn) {
            this.directoryRegistrationArn = directoryRegistrationArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServicePrincipalNameRequest build() {
            return new CreateServicePrincipalNameRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
