/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The key usage extension defines the purpose (e.g., encipherment, signature) of the key contained in the certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyUsage implements SdkPojo, Serializable, ToCopyableBuilder<KeyUsage.Builder, KeyUsage> {
    private static final SdkField<Boolean> CRITICAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Critical").getter(getter(KeyUsage::critical)).setter(setter(Builder::critical))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Critical").build()).build();

    private static final SdkField<KeyUsageFlags> USAGE_FLAGS_FIELD = SdkField.<KeyUsageFlags> builder(MarshallingType.SDK_POJO)
            .memberName("UsageFlags").getter(getter(KeyUsage::usageFlags)).setter(setter(Builder::usageFlags))
            .constructor(KeyUsageFlags::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageFlags").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRITICAL_FIELD,
            USAGE_FLAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean critical;

    private final KeyUsageFlags usageFlags;

    private KeyUsage(BuilderImpl builder) {
        this.critical = builder.critical;
        this.usageFlags = builder.usageFlags;
    }

    /**
     * <p>
     * Sets the key usage extension to critical.
     * </p>
     * 
     * @return Sets the key usage extension to critical.
     */
    public final Boolean critical() {
        return critical;
    }

    /**
     * <p>
     * The key usage flags represent the purpose (e.g., encipherment, signature) of the key contained in the
     * certificate.
     * </p>
     * 
     * @return The key usage flags represent the purpose (e.g., encipherment, signature) of the key contained in the
     *         certificate.
     */
    public final KeyUsageFlags usageFlags() {
        return usageFlags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(critical());
        hashCode = 31 * hashCode + Objects.hashCode(usageFlags());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyUsage)) {
            return false;
        }
        KeyUsage other = (KeyUsage) obj;
        return Objects.equals(critical(), other.critical()) && Objects.equals(usageFlags(), other.usageFlags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyUsage").add("Critical", critical()).add("UsageFlags", usageFlags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Critical":
            return Optional.ofNullable(clazz.cast(critical()));
        case "UsageFlags":
            return Optional.ofNullable(clazz.cast(usageFlags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyUsage, T> g) {
        return obj -> g.apply((KeyUsage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyUsage> {
        /**
         * <p>
         * Sets the key usage extension to critical.
         * </p>
         * 
         * @param critical
         *        Sets the key usage extension to critical.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder critical(Boolean critical);

        /**
         * <p>
         * The key usage flags represent the purpose (e.g., encipherment, signature) of the key contained in the
         * certificate.
         * </p>
         * 
         * @param usageFlags
         *        The key usage flags represent the purpose (e.g., encipherment, signature) of the key contained in the
         *        certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageFlags(KeyUsageFlags usageFlags);

        /**
         * <p>
         * The key usage flags represent the purpose (e.g., encipherment, signature) of the key contained in the
         * certificate.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyUsageFlags.Builder} avoiding the need
         * to create one manually via {@link KeyUsageFlags#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyUsageFlags.Builder#build()} is called immediately and its
         * result is passed to {@link #usageFlags(KeyUsageFlags)}.
         * 
         * @param usageFlags
         *        a consumer that will call methods on {@link KeyUsageFlags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usageFlags(KeyUsageFlags)
         */
        default Builder usageFlags(Consumer<KeyUsageFlags.Builder> usageFlags) {
            return usageFlags(KeyUsageFlags.builder().applyMutation(usageFlags).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean critical;

        private KeyUsageFlags usageFlags;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyUsage model) {
            critical(model.critical);
            usageFlags(model.usageFlags);
        }

        public final Boolean getCritical() {
            return critical;
        }

        public final void setCritical(Boolean critical) {
            this.critical = critical;
        }

        @Override
        public final Builder critical(Boolean critical) {
            this.critical = critical;
            return this;
        }

        public final KeyUsageFlags.Builder getUsageFlags() {
            return usageFlags != null ? usageFlags.toBuilder() : null;
        }

        public final void setUsageFlags(KeyUsageFlags.BuilderImpl usageFlags) {
            this.usageFlags = usageFlags != null ? usageFlags.build() : null;
        }

        @Override
        public final Builder usageFlags(KeyUsageFlags usageFlags) {
            this.usageFlags = usageFlags;
            return this;
        }

        @Override
        public KeyUsage build() {
            return new KeyUsage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
