/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Private key flags for v4 templates specify the client compatibility, if the private key can be exported, if user
 * input is required when using a private key, if an alternate signature algorithm should be used, and if certificates
 * are renewed using the same private key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivateKeyFlagsV4 implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivateKeyFlagsV4.Builder, PrivateKeyFlagsV4> {
    private static final SdkField<String> CLIENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientVersion").getter(getter(PrivateKeyFlagsV4::clientVersionAsString))
            .setter(setter(Builder::clientVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVersion").build()).build();

    private static final SdkField<Boolean> EXPORTABLE_KEY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExportableKey").getter(getter(PrivateKeyFlagsV4::exportableKey)).setter(setter(Builder::exportableKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportableKey").build()).build();

    private static final SdkField<Boolean> REQUIRE_ALTERNATE_SIGNATURE_ALGORITHM_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireAlternateSignatureAlgorithm")
            .getter(getter(PrivateKeyFlagsV4::requireAlternateSignatureAlgorithm))
            .setter(setter(Builder::requireAlternateSignatureAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireAlternateSignatureAlgorithm")
                    .build()).build();

    private static final SdkField<Boolean> REQUIRE_SAME_KEY_RENEWAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireSameKeyRenewal").getter(getter(PrivateKeyFlagsV4::requireSameKeyRenewal))
            .setter(setter(Builder::requireSameKeyRenewal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireSameKeyRenewal").build())
            .build();

    private static final SdkField<Boolean> STRONG_KEY_PROTECTION_REQUIRED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StrongKeyProtectionRequired")
            .getter(getter(PrivateKeyFlagsV4::strongKeyProtectionRequired))
            .setter(setter(Builder::strongKeyProtectionRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StrongKeyProtectionRequired")
                    .build()).build();

    private static final SdkField<Boolean> USE_LEGACY_PROVIDER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseLegacyProvider").getter(getter(PrivateKeyFlagsV4::useLegacyProvider))
            .setter(setter(Builder::useLegacyProvider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseLegacyProvider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VERSION_FIELD,
            EXPORTABLE_KEY_FIELD, REQUIRE_ALTERNATE_SIGNATURE_ALGORITHM_FIELD, REQUIRE_SAME_KEY_RENEWAL_FIELD,
            STRONG_KEY_PROTECTION_REQUIRED_FIELD, USE_LEGACY_PROVIDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientVersion;

    private final Boolean exportableKey;

    private final Boolean requireAlternateSignatureAlgorithm;

    private final Boolean requireSameKeyRenewal;

    private final Boolean strongKeyProtectionRequired;

    private final Boolean useLegacyProvider;

    private PrivateKeyFlagsV4(BuilderImpl builder) {
        this.clientVersion = builder.clientVersion;
        this.exportableKey = builder.exportableKey;
        this.requireAlternateSignatureAlgorithm = builder.requireAlternateSignatureAlgorithm;
        this.requireSameKeyRenewal = builder.requireSameKeyRenewal;
        this.strongKeyProtectionRequired = builder.strongKeyProtectionRequired;
        this.useLegacyProvider = builder.useLegacyProvider;
    }

    /**
     * <p>
     * Defines the minimum client compatibility.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientVersion}
     * will return {@link ClientCompatibilityV4#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #clientVersionAsString}.
     * </p>
     * 
     * @return Defines the minimum client compatibility.
     * @see ClientCompatibilityV4
     */
    public final ClientCompatibilityV4 clientVersion() {
        return ClientCompatibilityV4.fromValue(clientVersion);
    }

    /**
     * <p>
     * Defines the minimum client compatibility.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientVersion}
     * will return {@link ClientCompatibilityV4#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #clientVersionAsString}.
     * </p>
     * 
     * @return Defines the minimum client compatibility.
     * @see ClientCompatibilityV4
     */
    public final String clientVersionAsString() {
        return clientVersion;
    }

    /**
     * <p>
     * Allows the private key to be exported.
     * </p>
     * 
     * @return Allows the private key to be exported.
     */
    public final Boolean exportableKey() {
        return exportableKey;
    }

    /**
     * <p>
     * Requires the PKCS #1 v2.1 signature format for certificates. You should verify that your CA, objects, and
     * applications can accept this signature format.
     * </p>
     * 
     * @return Requires the PKCS #1 v2.1 signature format for certificates. You should verify that your CA, objects, and
     *         applications can accept this signature format.
     */
    public final Boolean requireAlternateSignatureAlgorithm() {
        return requireAlternateSignatureAlgorithm;
    }

    /**
     * <p>
     * Renew certificate using the same private key.
     * </p>
     * 
     * @return Renew certificate using the same private key.
     */
    public final Boolean requireSameKeyRenewal() {
        return requireSameKeyRenewal;
    }

    /**
     * <p>
     * Require user input when using the private key for enrollment.
     * </p>
     * 
     * @return Require user input when using the private key for enrollment.
     */
    public final Boolean strongKeyProtectionRequired() {
        return strongKeyProtectionRequired;
    }

    /**
     * <p>
     * Specifies the cryptographic service provider category used to generate private keys. Set to TRUE to use Legacy
     * Cryptographic Service Providers and FALSE to use Key Storage Providers.
     * </p>
     * 
     * @return Specifies the cryptographic service provider category used to generate private keys. Set to TRUE to use
     *         Legacy Cryptographic Service Providers and FALSE to use Key Storage Providers.
     */
    public final Boolean useLegacyProvider() {
        return useLegacyProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportableKey());
        hashCode = 31 * hashCode + Objects.hashCode(requireAlternateSignatureAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(requireSameKeyRenewal());
        hashCode = 31 * hashCode + Objects.hashCode(strongKeyProtectionRequired());
        hashCode = 31 * hashCode + Objects.hashCode(useLegacyProvider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateKeyFlagsV4)) {
            return false;
        }
        PrivateKeyFlagsV4 other = (PrivateKeyFlagsV4) obj;
        return Objects.equals(clientVersionAsString(), other.clientVersionAsString())
                && Objects.equals(exportableKey(), other.exportableKey())
                && Objects.equals(requireAlternateSignatureAlgorithm(), other.requireAlternateSignatureAlgorithm())
                && Objects.equals(requireSameKeyRenewal(), other.requireSameKeyRenewal())
                && Objects.equals(strongKeyProtectionRequired(), other.strongKeyProtectionRequired())
                && Objects.equals(useLegacyProvider(), other.useLegacyProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrivateKeyFlagsV4").add("ClientVersion", clientVersionAsString())
                .add("ExportableKey", exportableKey())
                .add("RequireAlternateSignatureAlgorithm", requireAlternateSignatureAlgorithm())
                .add("RequireSameKeyRenewal", requireSameKeyRenewal())
                .add("StrongKeyProtectionRequired", strongKeyProtectionRequired()).add("UseLegacyProvider", useLegacyProvider())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientVersion":
            return Optional.ofNullable(clazz.cast(clientVersionAsString()));
        case "ExportableKey":
            return Optional.ofNullable(clazz.cast(exportableKey()));
        case "RequireAlternateSignatureAlgorithm":
            return Optional.ofNullable(clazz.cast(requireAlternateSignatureAlgorithm()));
        case "RequireSameKeyRenewal":
            return Optional.ofNullable(clazz.cast(requireSameKeyRenewal()));
        case "StrongKeyProtectionRequired":
            return Optional.ofNullable(clazz.cast(strongKeyProtectionRequired()));
        case "UseLegacyProvider":
            return Optional.ofNullable(clazz.cast(useLegacyProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PrivateKeyFlagsV4, T> g) {
        return obj -> g.apply((PrivateKeyFlagsV4) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivateKeyFlagsV4> {
        /**
         * <p>
         * Defines the minimum client compatibility.
         * </p>
         * 
         * @param clientVersion
         *        Defines the minimum client compatibility.
         * @see ClientCompatibilityV4
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientCompatibilityV4
         */
        Builder clientVersion(String clientVersion);

        /**
         * <p>
         * Defines the minimum client compatibility.
         * </p>
         * 
         * @param clientVersion
         *        Defines the minimum client compatibility.
         * @see ClientCompatibilityV4
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientCompatibilityV4
         */
        Builder clientVersion(ClientCompatibilityV4 clientVersion);

        /**
         * <p>
         * Allows the private key to be exported.
         * </p>
         * 
         * @param exportableKey
         *        Allows the private key to be exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportableKey(Boolean exportableKey);

        /**
         * <p>
         * Requires the PKCS #1 v2.1 signature format for certificates. You should verify that your CA, objects, and
         * applications can accept this signature format.
         * </p>
         * 
         * @param requireAlternateSignatureAlgorithm
         *        Requires the PKCS #1 v2.1 signature format for certificates. You should verify that your CA, objects,
         *        and applications can accept this signature format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireAlternateSignatureAlgorithm(Boolean requireAlternateSignatureAlgorithm);

        /**
         * <p>
         * Renew certificate using the same private key.
         * </p>
         * 
         * @param requireSameKeyRenewal
         *        Renew certificate using the same private key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireSameKeyRenewal(Boolean requireSameKeyRenewal);

        /**
         * <p>
         * Require user input when using the private key for enrollment.
         * </p>
         * 
         * @param strongKeyProtectionRequired
         *        Require user input when using the private key for enrollment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder strongKeyProtectionRequired(Boolean strongKeyProtectionRequired);

        /**
         * <p>
         * Specifies the cryptographic service provider category used to generate private keys. Set to TRUE to use
         * Legacy Cryptographic Service Providers and FALSE to use Key Storage Providers.
         * </p>
         * 
         * @param useLegacyProvider
         *        Specifies the cryptographic service provider category used to generate private keys. Set to TRUE to
         *        use Legacy Cryptographic Service Providers and FALSE to use Key Storage Providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useLegacyProvider(Boolean useLegacyProvider);
    }

    static final class BuilderImpl implements Builder {
        private String clientVersion;

        private Boolean exportableKey;

        private Boolean requireAlternateSignatureAlgorithm;

        private Boolean requireSameKeyRenewal;

        private Boolean strongKeyProtectionRequired;

        private Boolean useLegacyProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateKeyFlagsV4 model) {
            clientVersion(model.clientVersion);
            exportableKey(model.exportableKey);
            requireAlternateSignatureAlgorithm(model.requireAlternateSignatureAlgorithm);
            requireSameKeyRenewal(model.requireSameKeyRenewal);
            strongKeyProtectionRequired(model.strongKeyProtectionRequired);
            useLegacyProvider(model.useLegacyProvider);
        }

        public final String getClientVersion() {
            return clientVersion;
        }

        public final void setClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
        }

        @Override
        public final Builder clientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
            return this;
        }

        @Override
        public final Builder clientVersion(ClientCompatibilityV4 clientVersion) {
            this.clientVersion(clientVersion == null ? null : clientVersion.toString());
            return this;
        }

        public final Boolean getExportableKey() {
            return exportableKey;
        }

        public final void setExportableKey(Boolean exportableKey) {
            this.exportableKey = exportableKey;
        }

        @Override
        public final Builder exportableKey(Boolean exportableKey) {
            this.exportableKey = exportableKey;
            return this;
        }

        public final Boolean getRequireAlternateSignatureAlgorithm() {
            return requireAlternateSignatureAlgorithm;
        }

        public final void setRequireAlternateSignatureAlgorithm(Boolean requireAlternateSignatureAlgorithm) {
            this.requireAlternateSignatureAlgorithm = requireAlternateSignatureAlgorithm;
        }

        @Override
        public final Builder requireAlternateSignatureAlgorithm(Boolean requireAlternateSignatureAlgorithm) {
            this.requireAlternateSignatureAlgorithm = requireAlternateSignatureAlgorithm;
            return this;
        }

        public final Boolean getRequireSameKeyRenewal() {
            return requireSameKeyRenewal;
        }

        public final void setRequireSameKeyRenewal(Boolean requireSameKeyRenewal) {
            this.requireSameKeyRenewal = requireSameKeyRenewal;
        }

        @Override
        public final Builder requireSameKeyRenewal(Boolean requireSameKeyRenewal) {
            this.requireSameKeyRenewal = requireSameKeyRenewal;
            return this;
        }

        public final Boolean getStrongKeyProtectionRequired() {
            return strongKeyProtectionRequired;
        }

        public final void setStrongKeyProtectionRequired(Boolean strongKeyProtectionRequired) {
            this.strongKeyProtectionRequired = strongKeyProtectionRequired;
        }

        @Override
        public final Builder strongKeyProtectionRequired(Boolean strongKeyProtectionRequired) {
            this.strongKeyProtectionRequired = strongKeyProtectionRequired;
            return this;
        }

        public final Boolean getUseLegacyProvider() {
            return useLegacyProvider;
        }

        public final void setUseLegacyProvider(Boolean useLegacyProvider) {
            this.useLegacyProvider = useLegacyProvider;
        }

        @Override
        public final Builder useLegacyProvider(Boolean useLegacyProvider) {
            this.useLegacyProvider = useLegacyProvider;
            return this;
        }

        @Override
        public PrivateKeyFlagsV4 build() {
            return new PrivateKeyFlagsV4(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
