/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTemplateRequest extends PcaConnectorAdRequest implements
        ToCopyableBuilder<UpdateTemplateRequest.Builder, UpdateTemplateRequest> {
    private static final SdkField<TemplateDefinition> DEFINITION_FIELD = SdkField
            .<TemplateDefinition> builder(MarshallingType.SDK_POJO).memberName("Definition")
            .getter(getter(UpdateTemplateRequest::definition)).setter(setter(Builder::definition))
            .constructor(TemplateDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()).build();

    private static final SdkField<Boolean> REENROLL_ALL_CERTIFICATE_HOLDERS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReenrollAllCertificateHolders")
            .getter(getter(UpdateTemplateRequest::reenrollAllCertificateHolders))
            .setter(setter(Builder::reenrollAllCertificateHolders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReenrollAllCertificateHolders")
                    .build()).build();

    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateArn").getter(getter(UpdateTemplateRequest::templateArn)).setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD,
            REENROLL_ALL_CERTIFICATE_HOLDERS_FIELD, TEMPLATE_ARN_FIELD));

    private final TemplateDefinition definition;

    private final Boolean reenrollAllCertificateHolders;

    private final String templateArn;

    private UpdateTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.definition = builder.definition;
        this.reenrollAllCertificateHolders = builder.reenrollAllCertificateHolders;
        this.templateArn = builder.templateArn;
    }

    /**
     * <p>
     * Template configuration to define the information included in certificates. Define certificate validity and
     * renewal periods, certificate request handling and enrollment options, key usage extensions, application policies,
     * and cryptography settings.
     * </p>
     * 
     * @return Template configuration to define the information included in certificates. Define certificate validity
     *         and renewal periods, certificate request handling and enrollment options, key usage extensions,
     *         application policies, and cryptography settings.
     */
    public final TemplateDefinition definition() {
        return definition;
    }

    /**
     * <p>
     * This setting allows the major version of a template to be increased automatically. All members of Active
     * Directory groups that are allowed to enroll with a template will receive a new certificate issued using that
     * template.
     * </p>
     * 
     * @return This setting allows the major version of a template to be increased automatically. All members of Active
     *         Directory groups that are allowed to enroll with a template will receive a new certificate issued using
     *         that template.
     */
    public final Boolean reenrollAllCertificateHolders() {
        return reenrollAllCertificateHolders;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that was returned when you called <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html"
     * >CreateTemplate</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that was returned when you called <a
     *         href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html"
     *         >CreateTemplate</a>.
     */
    public final String templateArn() {
        return templateArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(reenrollAllCertificateHolders());
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTemplateRequest)) {
            return false;
        }
        UpdateTemplateRequest other = (UpdateTemplateRequest) obj;
        return Objects.equals(definition(), other.definition())
                && Objects.equals(reenrollAllCertificateHolders(), other.reenrollAllCertificateHolders())
                && Objects.equals(templateArn(), other.templateArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTemplateRequest").add("Definition", definition())
                .add("ReenrollAllCertificateHolders", reenrollAllCertificateHolders()).add("TemplateArn", templateArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "ReenrollAllCertificateHolders":
            return Optional.ofNullable(clazz.cast(reenrollAllCertificateHolders()));
        case "TemplateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTemplateRequest, T> g) {
        return obj -> g.apply((UpdateTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PcaConnectorAdRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTemplateRequest> {
        /**
         * <p>
         * Template configuration to define the information included in certificates. Define certificate validity and
         * renewal periods, certificate request handling and enrollment options, key usage extensions, application
         * policies, and cryptography settings.
         * </p>
         * 
         * @param definition
         *        Template configuration to define the information included in certificates. Define certificate validity
         *        and renewal periods, certificate request handling and enrollment options, key usage extensions,
         *        application policies, and cryptography settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(TemplateDefinition definition);

        /**
         * <p>
         * Template configuration to define the information included in certificates. Define certificate validity and
         * renewal periods, certificate request handling and enrollment options, key usage extensions, application
         * policies, and cryptography settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateDefinition.Builder} avoiding the
         * need to create one manually via {@link TemplateDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #definition(TemplateDefinition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link TemplateDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(TemplateDefinition)
         */
        default Builder definition(Consumer<TemplateDefinition.Builder> definition) {
            return definition(TemplateDefinition.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * This setting allows the major version of a template to be increased automatically. All members of Active
         * Directory groups that are allowed to enroll with a template will receive a new certificate issued using that
         * template.
         * </p>
         * 
         * @param reenrollAllCertificateHolders
         *        This setting allows the major version of a template to be increased automatically. All members of
         *        Active Directory groups that are allowed to enroll with a template will receive a new certificate
         *        issued using that template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reenrollAllCertificateHolders(Boolean reenrollAllCertificateHolders);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that was returned when you called <a
         * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html"
         * >CreateTemplate</a>.
         * </p>
         * 
         * @param templateArn
         *        The Amazon Resource Name (ARN) that was returned when you called <a
         *        href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html"
         *        >CreateTemplate</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PcaConnectorAdRequest.BuilderImpl implements Builder {
        private TemplateDefinition definition;

        private Boolean reenrollAllCertificateHolders;

        private String templateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTemplateRequest model) {
            super(model);
            definition(model.definition);
            reenrollAllCertificateHolders(model.reenrollAllCertificateHolders);
            templateArn(model.templateArn);
        }

        public final TemplateDefinition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(TemplateDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(TemplateDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final Boolean getReenrollAllCertificateHolders() {
            return reenrollAllCertificateHolders;
        }

        public final void setReenrollAllCertificateHolders(Boolean reenrollAllCertificateHolders) {
            this.reenrollAllCertificateHolders = reenrollAllCertificateHolders;
        }

        @Override
        public final Builder reenrollAllCertificateHolders(Boolean reenrollAllCertificateHolders) {
            this.reenrollAllCertificateHolders = reenrollAllCertificateHolders;
            return this;
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTemplateRequest build() {
            return new UpdateTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
