/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents action metadata added to an Action dataset using the <code>PutActions</code> API. For more information see
 * <a href="https://docs.aws.amazon.com/personalize/latest/dg/importing-actions.html">Importing actions
 * individually</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Action implements SdkPojo, Serializable, ToCopyableBuilder<Action.Builder, Action> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionId").getter(getter(Action::actionId)).setter(setter(Builder::actionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionId").build()).build();

    private static final SdkField<String> PROPERTIES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("properties")
            .getter(getter(Action::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(),
                    JsonValueTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD,
            PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionId;

    private final String properties;

    private Action(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The ID associated with the action.
     * </p>
     * 
     * @return The ID associated with the action.
     */
    public final String actionId() {
        return actionId;
    }

    /**
     * <p>
     * A string map of action-specific metadata. Each element in the map consists of a key-value pair. For example,
     * <code>{"value": "100"}</code>.
     * </p>
     * <p>
     * The keys use camel case names that match the fields in the schema for the Actions dataset. In the previous
     * example, the <code>value</code> matches the 'VALUE' field defined in the Actions schema. For categorical string
     * data, to include multiple categories for a single action, separate each category with a pipe separator (
     * <code>|</code>). For example, <code>\"Deluxe|Premium\"</code>.
     * </p>
     * 
     * @return A string map of action-specific metadata. Each element in the map consists of a key-value pair. For
     *         example, <code>{"value": "100"}</code>.</p>
     *         <p>
     *         The keys use camel case names that match the fields in the schema for the Actions dataset. In the
     *         previous example, the <code>value</code> matches the 'VALUE' field defined in the Actions schema. For
     *         categorical string data, to include multiple categories for a single action, separate each category with
     *         a pipe separator (<code>|</code>). For example, <code>\"Deluxe|Premium\"</code>.
     */
    public final String properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action) obj;
        return Objects.equals(actionId(), other.actionId()) && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Action").add("ActionId", actionId())
                .add("Properties", properties() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Action> {
        /**
         * <p>
         * The ID associated with the action.
         * </p>
         * 
         * @param actionId
         *        The ID associated with the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);

        /**
         * <p>
         * A string map of action-specific metadata. Each element in the map consists of a key-value pair. For example,
         * <code>{"value": "100"}</code>.
         * </p>
         * <p>
         * The keys use camel case names that match the fields in the schema for the Actions dataset. In the previous
         * example, the <code>value</code> matches the 'VALUE' field defined in the Actions schema. For categorical
         * string data, to include multiple categories for a single action, separate each category with a pipe separator
         * (<code>|</code>). For example, <code>\"Deluxe|Premium\"</code>.
         * </p>
         * 
         * @param properties
         *        A string map of action-specific metadata. Each element in the map consists of a key-value pair. For
         *        example, <code>{"value": "100"}</code>.</p>
         *        <p>
         *        The keys use camel case names that match the fields in the schema for the Actions dataset. In the
         *        previous example, the <code>value</code> matches the 'VALUE' field defined in the Actions schema. For
         *        categorical string data, to include multiple categories for a single action, separate each category
         *        with a pipe separator (<code>|</code>). For example, <code>\"Deluxe|Premium\"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(String properties);
    }

    static final class BuilderImpl implements Builder {
        private String actionId;

        private String properties;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            actionId(model.actionId);
            properties(model.properties);
        }

        public final String getActionId() {
            return actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final String getProperties() {
            return properties;
        }

        public final void setProperties(String properties) {
            this.properties = properties;
        }

        @Override
        public final Builder properties(String properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public Action build() {
            return new Action(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
