/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendUsersMessagesRequest extends PinpointRequest implements
        ToCopyableBuilder<SendUsersMessagesRequest.Builder, SendUsersMessagesRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(SendUsersMessagesRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()).build();

    private static final SdkField<SendUsersMessageRequest> SEND_USERS_MESSAGE_REQUEST_FIELD = SdkField
            .<SendUsersMessageRequest> builder(MarshallingType.SDK_POJO)
            .memberName("SendUsersMessageRequest")
            .getter(getter(SendUsersMessagesRequest::sendUsersMessageRequest))
            .setter(setter(Builder::sendUsersMessageRequest))
            .constructor(SendUsersMessageRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendUsersMessageRequest").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            SEND_USERS_MESSAGE_REQUEST_FIELD));

    private final String applicationId;

    private final SendUsersMessageRequest sendUsersMessageRequest;

    private SendUsersMessagesRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.sendUsersMessageRequest = builder.sendUsersMessageRequest;
    }

    /**
     * <p>
     * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon
     * Pinpoint console.
     * </p>
     * 
     * @return The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
     *         Amazon Pinpoint console.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * Returns the value of the SendUsersMessageRequest property for this object.
     * 
     * @return The value of the SendUsersMessageRequest property for this object.
     */
    public final SendUsersMessageRequest sendUsersMessageRequest() {
        return sendUsersMessageRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(sendUsersMessageRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendUsersMessagesRequest)) {
            return false;
        }
        SendUsersMessagesRequest other = (SendUsersMessagesRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(sendUsersMessageRequest(), other.sendUsersMessageRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendUsersMessagesRequest").add("ApplicationId", applicationId())
                .add("SendUsersMessageRequest", sendUsersMessageRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "SendUsersMessageRequest":
            return Optional.ofNullable(clazz.cast(sendUsersMessageRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendUsersMessagesRequest, T> g) {
        return obj -> g.apply((SendUsersMessagesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, SendUsersMessagesRequest> {
        /**
         * <p>
         * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
         * Amazon Pinpoint console.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on
         *        the Amazon Pinpoint console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * Sets the value of the SendUsersMessageRequest property for this object.
         *
         * @param sendUsersMessageRequest
         *        The new value for the SendUsersMessageRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendUsersMessageRequest(SendUsersMessageRequest sendUsersMessageRequest);

        /**
         * Sets the value of the SendUsersMessageRequest property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SendUsersMessageRequest.Builder} avoiding
         * the need to create one manually via {@link SendUsersMessageRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SendUsersMessageRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #sendUsersMessageRequest(SendUsersMessageRequest)}.
         * 
         * @param sendUsersMessageRequest
         *        a consumer that will call methods on {@link SendUsersMessageRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sendUsersMessageRequest(SendUsersMessageRequest)
         */
        default Builder sendUsersMessageRequest(Consumer<SendUsersMessageRequest.Builder> sendUsersMessageRequest) {
            return sendUsersMessageRequest(SendUsersMessageRequest.builder().applyMutation(sendUsersMessageRequest).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String applicationId;

        private SendUsersMessageRequest sendUsersMessageRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(SendUsersMessagesRequest model) {
            super(model);
            applicationId(model.applicationId);
            sendUsersMessageRequest(model.sendUsersMessageRequest);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final SendUsersMessageRequest.Builder getSendUsersMessageRequest() {
            return sendUsersMessageRequest != null ? sendUsersMessageRequest.toBuilder() : null;
        }

        public final void setSendUsersMessageRequest(SendUsersMessageRequest.BuilderImpl sendUsersMessageRequest) {
            this.sendUsersMessageRequest = sendUsersMessageRequest != null ? sendUsersMessageRequest.build() : null;
        }

        @Override
        public final Builder sendUsersMessageRequest(SendUsersMessageRequest sendUsersMessageRequest) {
            this.sendUsersMessageRequest = sendUsersMessageRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendUsersMessagesRequest build() {
            return new SendUsersMessagesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
