/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRegistrationAssociationResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<CreateRegistrationAssociationResponse.Builder, CreateRegistrationAssociationResponse> {
    private static final SdkField<String> REGISTRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationArn").getter(getter(CreateRegistrationAssociationResponse::registrationArn))
            .setter(setter(Builder::registrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationArn").build()).build();

    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationId").getter(getter(CreateRegistrationAssociationResponse::registrationId))
            .setter(setter(Builder::registrationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationId").build()).build();

    private static final SdkField<String> REGISTRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationType").getter(getter(CreateRegistrationAssociationResponse::registrationType))
            .setter(setter(Builder::registrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationType").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(CreateRegistrationAssociationResponse::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(CreateRegistrationAssociationResponse::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(CreateRegistrationAssociationResponse::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> ISO_COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IsoCountryCode").getter(getter(CreateRegistrationAssociationResponse::isoCountryCode))
            .setter(setter(Builder::isoCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoCountryCode").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(CreateRegistrationAssociationResponse::phoneNumber))
            .setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_ARN_FIELD,
            REGISTRATION_ID_FIELD, REGISTRATION_TYPE_FIELD, RESOURCE_ARN_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD,
            ISO_COUNTRY_CODE_FIELD, PHONE_NUMBER_FIELD));

    private final String registrationArn;

    private final String registrationId;

    private final String registrationType;

    private final String resourceArn;

    private final String resourceId;

    private final String resourceType;

    private final String isoCountryCode;

    private final String phoneNumber;

    private CreateRegistrationAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.registrationArn = builder.registrationArn;
        this.registrationId = builder.registrationId;
        this.registrationType = builder.registrationType;
        this.resourceArn = builder.resourceArn;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.isoCountryCode = builder.isoCountryCode;
        this.phoneNumber = builder.phoneNumber;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the registration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the registration.
     */
    public final String registrationArn() {
        return registrationArn;
    }

    /**
     * <p>
     * The unique identifier for the registration.
     * </p>
     * 
     * @return The unique identifier for the registration.
     */
    public final String registrationId() {
        return registrationId;
    }

    /**
     * <p>
     * The type of registration form. The list of <b>RegistrationTypes</b> can be found using the
     * <a>DescribeRegistrationTypeDefinitions</a> action.
     * </p>
     * 
     * @return The type of registration form. The list of <b>RegistrationTypes</b> can be found using the
     *         <a>DescribeRegistrationTypeDefinitions</a> action.
     */
    public final String registrationType() {
        return registrationType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the origination identity that is associated with the registration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the origination identity that is associated with the registration.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The unique identifier for the origination identity. For example this could be a <b>PhoneNumberId</b> or
     * <b>SenderId</b>.
     * </p>
     * 
     * @return The unique identifier for the origination identity. For example this could be a <b>PhoneNumberId</b> or
     *         <b>SenderId</b>.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The registration type or origination identity type.
     * </p>
     * 
     * @return The registration type or origination identity type.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     * </p>
     * 
     * @return The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     */
    public final String isoCountryCode() {
        return isoCountryCode;
    }

    /**
     * <p>
     * The phone number associated with the registration in E.164 format.
     * </p>
     * 
     * @return The phone number associated with the registration in E.164 format.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(registrationType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(isoCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRegistrationAssociationResponse)) {
            return false;
        }
        CreateRegistrationAssociationResponse other = (CreateRegistrationAssociationResponse) obj;
        return Objects.equals(registrationArn(), other.registrationArn())
                && Objects.equals(registrationId(), other.registrationId())
                && Objects.equals(registrationType(), other.registrationType())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(isoCountryCode(), other.isoCountryCode()) && Objects.equals(phoneNumber(), other.phoneNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRegistrationAssociationResponse").add("RegistrationArn", registrationArn())
                .add("RegistrationId", registrationId()).add("RegistrationType", registrationType())
                .add("ResourceArn", resourceArn()).add("ResourceId", resourceId()).add("ResourceType", resourceType())
                .add("IsoCountryCode", isoCountryCode()).add("PhoneNumber", phoneNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistrationArn":
            return Optional.ofNullable(clazz.cast(registrationArn()));
        case "RegistrationId":
            return Optional.ofNullable(clazz.cast(registrationId()));
        case "RegistrationType":
            return Optional.ofNullable(clazz.cast(registrationType()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "IsoCountryCode":
            return Optional.ofNullable(clazz.cast(isoCountryCode()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRegistrationAssociationResponse, T> g) {
        return obj -> g.apply((CreateRegistrationAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateRegistrationAssociationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the registration.
         * </p>
         * 
         * @param registrationArn
         *        The Amazon Resource Name (ARN) for the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationArn(String registrationArn);

        /**
         * <p>
         * The unique identifier for the registration.
         * </p>
         * 
         * @param registrationId
         *        The unique identifier for the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationId(String registrationId);

        /**
         * <p>
         * The type of registration form. The list of <b>RegistrationTypes</b> can be found using the
         * <a>DescribeRegistrationTypeDefinitions</a> action.
         * </p>
         * 
         * @param registrationType
         *        The type of registration form. The list of <b>RegistrationTypes</b> can be found using the
         *        <a>DescribeRegistrationTypeDefinitions</a> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationType(String registrationType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the origination identity that is associated with the registration.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the origination identity that is associated with the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The unique identifier for the origination identity. For example this could be a <b>PhoneNumberId</b> or
         * <b>SenderId</b>.
         * </p>
         * 
         * @param resourceId
         *        The unique identifier for the origination identity. For example this could be a <b>PhoneNumberId</b>
         *        or <b>SenderId</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The registration type or origination identity type.
         * </p>
         * 
         * @param resourceType
         *        The registration type or origination identity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * </p>
         * 
         * @param isoCountryCode
         *        The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isoCountryCode(String isoCountryCode);

        /**
         * <p>
         * The phone number associated with the registration in E.164 format.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number associated with the registration in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String registrationArn;

        private String registrationId;

        private String registrationType;

        private String resourceArn;

        private String resourceId;

        private String resourceType;

        private String isoCountryCode;

        private String phoneNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRegistrationAssociationResponse model) {
            super(model);
            registrationArn(model.registrationArn);
            registrationId(model.registrationId);
            registrationType(model.registrationType);
            resourceArn(model.resourceArn);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            isoCountryCode(model.isoCountryCode);
            phoneNumber(model.phoneNumber);
        }

        public final String getRegistrationArn() {
            return registrationArn;
        }

        public final void setRegistrationArn(String registrationArn) {
            this.registrationArn = registrationArn;
        }

        @Override
        public final Builder registrationArn(String registrationArn) {
            this.registrationArn = registrationArn;
            return this;
        }

        public final String getRegistrationId() {
            return registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final String getRegistrationType() {
            return registrationType;
        }

        public final void setRegistrationType(String registrationType) {
            this.registrationType = registrationType;
        }

        @Override
        public final Builder registrationType(String registrationType) {
            this.registrationType = registrationType;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getIsoCountryCode() {
            return isoCountryCode;
        }

        public final void setIsoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
        }

        @Override
        public final Builder isoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @Override
        public CreateRegistrationAssociationResponse build() {
            return new CreateRegistrationAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
