/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVerifiedDestinationNumberResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<DeleteVerifiedDestinationNumberResponse.Builder, DeleteVerifiedDestinationNumberResponse> {
    private static final SdkField<String> VERIFIED_DESTINATION_NUMBER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedDestinationNumberArn")
            .getter(getter(DeleteVerifiedDestinationNumberResponse::verifiedDestinationNumberArn))
            .setter(setter(Builder::verifiedDestinationNumberArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedDestinationNumberArn")
                    .build()).build();

    private static final SdkField<String> VERIFIED_DESTINATION_NUMBER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedDestinationNumberId")
            .getter(getter(DeleteVerifiedDestinationNumberResponse::verifiedDestinationNumberId))
            .setter(setter(Builder::verifiedDestinationNumberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedDestinationNumberId")
                    .build()).build();

    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPhoneNumber").getter(getter(DeleteVerifiedDestinationNumberResponse::destinationPhoneNumber))
            .setter(setter(Builder::destinationPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumber").build())
            .build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(DeleteVerifiedDestinationNumberResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERIFIED_DESTINATION_NUMBER_ARN_FIELD, VERIFIED_DESTINATION_NUMBER_ID_FIELD, DESTINATION_PHONE_NUMBER_FIELD,
            CREATED_TIMESTAMP_FIELD));

    private final String verifiedDestinationNumberArn;

    private final String verifiedDestinationNumberId;

    private final String destinationPhoneNumber;

    private final Instant createdTimestamp;

    private DeleteVerifiedDestinationNumberResponse(BuilderImpl builder) {
        super(builder);
        this.verifiedDestinationNumberArn = builder.verifiedDestinationNumberArn;
        this.verifiedDestinationNumberId = builder.verifiedDestinationNumberId;
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.createdTimestamp = builder.createdTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the verified destination phone number.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the verified destination phone number.
     */
    public final String verifiedDestinationNumberArn() {
        return verifiedDestinationNumberArn;
    }

    /**
     * <p>
     * The unique identifier for the verified destination phone number.
     * </p>
     * 
     * @return The unique identifier for the verified destination phone number.
     */
    public final String verifiedDestinationNumberId() {
        return verifiedDestinationNumberId;
    }

    /**
     * <p>
     * The verified destination phone number, in E.164 format.
     * </p>
     * 
     * @return The verified destination phone number, in E.164 format.
     */
    public final String destinationPhoneNumber() {
        return destinationPhoneNumber;
    }

    /**
     * <p>
     * The time when the destination phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch
     * time</a> format.
     * </p>
     * 
     * @return The time when the destination phone number was created, in <a href="https://www.epochconverter.com/">UNIX
     *         epoch time</a> format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(verifiedDestinationNumberArn());
        hashCode = 31 * hashCode + Objects.hashCode(verifiedDestinationNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVerifiedDestinationNumberResponse)) {
            return false;
        }
        DeleteVerifiedDestinationNumberResponse other = (DeleteVerifiedDestinationNumberResponse) obj;
        return Objects.equals(verifiedDestinationNumberArn(), other.verifiedDestinationNumberArn())
                && Objects.equals(verifiedDestinationNumberId(), other.verifiedDestinationNumberId())
                && Objects.equals(destinationPhoneNumber(), other.destinationPhoneNumber())
                && Objects.equals(createdTimestamp(), other.createdTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteVerifiedDestinationNumberResponse")
                .add("VerifiedDestinationNumberArn", verifiedDestinationNumberArn())
                .add("VerifiedDestinationNumberId", verifiedDestinationNumberId())
                .add("DestinationPhoneNumber", destinationPhoneNumber()).add("CreatedTimestamp", createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedDestinationNumberArn":
            return Optional.ofNullable(clazz.cast(verifiedDestinationNumberArn()));
        case "VerifiedDestinationNumberId":
            return Optional.ofNullable(clazz.cast(verifiedDestinationNumberId()));
        case "DestinationPhoneNumber":
            return Optional.ofNullable(clazz.cast(destinationPhoneNumber()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteVerifiedDestinationNumberResponse, T> g) {
        return obj -> g.apply((DeleteVerifiedDestinationNumberResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteVerifiedDestinationNumberResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the verified destination phone number.
         * </p>
         * 
         * @param verifiedDestinationNumberArn
         *        The Amazon Resource Name (ARN) for the verified destination phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedDestinationNumberArn(String verifiedDestinationNumberArn);

        /**
         * <p>
         * The unique identifier for the verified destination phone number.
         * </p>
         * 
         * @param verifiedDestinationNumberId
         *        The unique identifier for the verified destination phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedDestinationNumberId(String verifiedDestinationNumberId);

        /**
         * <p>
         * The verified destination phone number, in E.164 format.
         * </p>
         * 
         * @param destinationPhoneNumber
         *        The verified destination phone number, in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPhoneNumber(String destinationPhoneNumber);

        /**
         * <p>
         * The time when the destination phone number was created, in <a href="https://www.epochconverter.com/">UNIX
         * epoch time</a> format.
         * </p>
         * 
         * @param createdTimestamp
         *        The time when the destination phone number was created, in <a
         *        href="https://www.epochconverter.com/">UNIX epoch time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String verifiedDestinationNumberArn;

        private String verifiedDestinationNumberId;

        private String destinationPhoneNumber;

        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVerifiedDestinationNumberResponse model) {
            super(model);
            verifiedDestinationNumberArn(model.verifiedDestinationNumberArn);
            verifiedDestinationNumberId(model.verifiedDestinationNumberId);
            destinationPhoneNumber(model.destinationPhoneNumber);
            createdTimestamp(model.createdTimestamp);
        }

        public final String getVerifiedDestinationNumberArn() {
            return verifiedDestinationNumberArn;
        }

        public final void setVerifiedDestinationNumberArn(String verifiedDestinationNumberArn) {
            this.verifiedDestinationNumberArn = verifiedDestinationNumberArn;
        }

        @Override
        public final Builder verifiedDestinationNumberArn(String verifiedDestinationNumberArn) {
            this.verifiedDestinationNumberArn = verifiedDestinationNumberArn;
            return this;
        }

        public final String getVerifiedDestinationNumberId() {
            return verifiedDestinationNumberId;
        }

        public final void setVerifiedDestinationNumberId(String verifiedDestinationNumberId) {
            this.verifiedDestinationNumberId = verifiedDestinationNumberId;
        }

        @Override
        public final Builder verifiedDestinationNumberId(String verifiedDestinationNumberId) {
            this.verifiedDestinationNumberId = verifiedDestinationNumberId;
            return this;
        }

        public final String getDestinationPhoneNumber() {
            return destinationPhoneNumber;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public DeleteVerifiedDestinationNumberResponse build() {
            return new DeleteVerifiedDestinationNumberResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
