/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information on the specified registration attachments.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegistrationAttachmentsInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<RegistrationAttachmentsInformation.Builder, RegistrationAttachmentsInformation> {
    private static final SdkField<String> REGISTRATION_ATTACHMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationAttachmentArn")
            .getter(getter(RegistrationAttachmentsInformation::registrationAttachmentArn))
            .setter(setter(Builder::registrationAttachmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationAttachmentArn").build())
            .build();

    private static final SdkField<String> REGISTRATION_ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationAttachmentId").getter(getter(RegistrationAttachmentsInformation::registrationAttachmentId))
            .setter(setter(Builder::registrationAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationAttachmentId").build())
            .build();

    private static final SdkField<String> ATTACHMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachmentStatus").getter(getter(RegistrationAttachmentsInformation::attachmentStatusAsString))
            .setter(setter(Builder::attachmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentStatus").build()).build();

    private static final SdkField<String> ATTACHMENT_UPLOAD_ERROR_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AttachmentUploadErrorReason")
            .getter(getter(RegistrationAttachmentsInformation::attachmentUploadErrorReasonAsString))
            .setter(setter(Builder::attachmentUploadErrorReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentUploadErrorReason")
                    .build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(RegistrationAttachmentsInformation::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REGISTRATION_ATTACHMENT_ARN_FIELD, REGISTRATION_ATTACHMENT_ID_FIELD, ATTACHMENT_STATUS_FIELD,
            ATTACHMENT_UPLOAD_ERROR_REASON_FIELD, CREATED_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String registrationAttachmentArn;

    private final String registrationAttachmentId;

    private final String attachmentStatus;

    private final String attachmentUploadErrorReason;

    private final Instant createdTimestamp;

    private RegistrationAttachmentsInformation(BuilderImpl builder) {
        this.registrationAttachmentArn = builder.registrationAttachmentArn;
        this.registrationAttachmentId = builder.registrationAttachmentId;
        this.attachmentStatus = builder.attachmentStatus;
        this.attachmentUploadErrorReason = builder.attachmentUploadErrorReason;
        this.createdTimestamp = builder.createdTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the registration attachment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the registration attachment.
     */
    public final String registrationAttachmentArn() {
        return registrationAttachmentArn;
    }

    /**
     * <p>
     * The unique identifier for the registration attachment.
     * </p>
     * 
     * @return The unique identifier for the registration attachment.
     */
    public final String registrationAttachmentId() {
        return registrationAttachmentId;
    }

    /**
     * <p>
     * The status of the registration attachment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>UPLOAD_IN_PROGRESS</code> The attachment is being uploaded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPLOAD_COMPLETE</code> The attachment has been uploaded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPLOAD_FAILED</code> The attachment failed to uploaded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> The attachment has been deleted..
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attachmentStatus}
     * will return {@link AttachmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attachmentStatusAsString}.
     * </p>
     * 
     * @return The status of the registration attachment. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>UPLOAD_IN_PROGRESS</code> The attachment is being uploaded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPLOAD_COMPLETE</code> The attachment has been uploaded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPLOAD_FAILED</code> The attachment failed to uploaded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> The attachment has been deleted..
     *         </p>
     *         </li>
     * @see AttachmentStatus
     */
    public final AttachmentStatus attachmentStatus() {
        return AttachmentStatus.fromValue(attachmentStatus);
    }

    /**
     * <p>
     * The status of the registration attachment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>UPLOAD_IN_PROGRESS</code> The attachment is being uploaded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPLOAD_COMPLETE</code> The attachment has been uploaded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPLOAD_FAILED</code> The attachment failed to uploaded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> The attachment has been deleted..
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attachmentStatus}
     * will return {@link AttachmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attachmentStatusAsString}.
     * </p>
     * 
     * @return The status of the registration attachment. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>UPLOAD_IN_PROGRESS</code> The attachment is being uploaded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPLOAD_COMPLETE</code> The attachment has been uploaded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPLOAD_FAILED</code> The attachment failed to uploaded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> The attachment has been deleted..
     *         </p>
     *         </li>
     * @see AttachmentStatus
     */
    public final String attachmentStatusAsString() {
        return attachmentStatus;
    }

    /**
     * <p>
     * A description of why the upload didn't successfully complete.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attachmentUploadErrorReason} will return {@link AttachmentUploadErrorReason#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #attachmentUploadErrorReasonAsString}.
     * </p>
     * 
     * @return A description of why the upload didn't successfully complete.
     * @see AttachmentUploadErrorReason
     */
    public final AttachmentUploadErrorReason attachmentUploadErrorReason() {
        return AttachmentUploadErrorReason.fromValue(attachmentUploadErrorReason);
    }

    /**
     * <p>
     * A description of why the upload didn't successfully complete.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attachmentUploadErrorReason} will return {@link AttachmentUploadErrorReason#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #attachmentUploadErrorReasonAsString}.
     * </p>
     * 
     * @return A description of why the upload didn't successfully complete.
     * @see AttachmentUploadErrorReason
     */
    public final String attachmentUploadErrorReasonAsString() {
        return attachmentUploadErrorReason;
    }

    /**
     * <p>
     * The time when the registration attachment was created, in <a href="https://www.epochconverter.com/">UNIX epoch
     * time</a> format.
     * </p>
     * 
     * @return The time when the registration attachment was created, in <a href="https://www.epochconverter.com/">UNIX
     *         epoch time</a> format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(registrationAttachmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(registrationAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentUploadErrorReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistrationAttachmentsInformation)) {
            return false;
        }
        RegistrationAttachmentsInformation other = (RegistrationAttachmentsInformation) obj;
        return Objects.equals(registrationAttachmentArn(), other.registrationAttachmentArn())
                && Objects.equals(registrationAttachmentId(), other.registrationAttachmentId())
                && Objects.equals(attachmentStatusAsString(), other.attachmentStatusAsString())
                && Objects.equals(attachmentUploadErrorReasonAsString(), other.attachmentUploadErrorReasonAsString())
                && Objects.equals(createdTimestamp(), other.createdTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegistrationAttachmentsInformation")
                .add("RegistrationAttachmentArn", registrationAttachmentArn())
                .add("RegistrationAttachmentId", registrationAttachmentId()).add("AttachmentStatus", attachmentStatusAsString())
                .add("AttachmentUploadErrorReason", attachmentUploadErrorReasonAsString())
                .add("CreatedTimestamp", createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistrationAttachmentArn":
            return Optional.ofNullable(clazz.cast(registrationAttachmentArn()));
        case "RegistrationAttachmentId":
            return Optional.ofNullable(clazz.cast(registrationAttachmentId()));
        case "AttachmentStatus":
            return Optional.ofNullable(clazz.cast(attachmentStatusAsString()));
        case "AttachmentUploadErrorReason":
            return Optional.ofNullable(clazz.cast(attachmentUploadErrorReasonAsString()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegistrationAttachmentsInformation, T> g) {
        return obj -> g.apply((RegistrationAttachmentsInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegistrationAttachmentsInformation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the registration attachment.
         * </p>
         * 
         * @param registrationAttachmentArn
         *        The Amazon Resource Name (ARN) for the registration attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationAttachmentArn(String registrationAttachmentArn);

        /**
         * <p>
         * The unique identifier for the registration attachment.
         * </p>
         * 
         * @param registrationAttachmentId
         *        The unique identifier for the registration attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationAttachmentId(String registrationAttachmentId);

        /**
         * <p>
         * The status of the registration attachment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>UPLOAD_IN_PROGRESS</code> The attachment is being uploaded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPLOAD_COMPLETE</code> The attachment has been uploaded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPLOAD_FAILED</code> The attachment failed to uploaded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> The attachment has been deleted..
         * </p>
         * </li>
         * </ul>
         * 
         * @param attachmentStatus
         *        The status of the registration attachment. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>UPLOAD_IN_PROGRESS</code> The attachment is being uploaded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPLOAD_COMPLETE</code> The attachment has been uploaded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPLOAD_FAILED</code> The attachment failed to uploaded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> The attachment has been deleted..
         *        </p>
         *        </li>
         * @see AttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentStatus
         */
        Builder attachmentStatus(String attachmentStatus);

        /**
         * <p>
         * The status of the registration attachment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>UPLOAD_IN_PROGRESS</code> The attachment is being uploaded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPLOAD_COMPLETE</code> The attachment has been uploaded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPLOAD_FAILED</code> The attachment failed to uploaded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> The attachment has been deleted..
         * </p>
         * </li>
         * </ul>
         * 
         * @param attachmentStatus
         *        The status of the registration attachment. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>UPLOAD_IN_PROGRESS</code> The attachment is being uploaded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPLOAD_COMPLETE</code> The attachment has been uploaded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPLOAD_FAILED</code> The attachment failed to uploaded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> The attachment has been deleted..
         *        </p>
         *        </li>
         * @see AttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentStatus
         */
        Builder attachmentStatus(AttachmentStatus attachmentStatus);

        /**
         * <p>
         * A description of why the upload didn't successfully complete.
         * </p>
         * 
         * @param attachmentUploadErrorReason
         *        A description of why the upload didn't successfully complete.
         * @see AttachmentUploadErrorReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentUploadErrorReason
         */
        Builder attachmentUploadErrorReason(String attachmentUploadErrorReason);

        /**
         * <p>
         * A description of why the upload didn't successfully complete.
         * </p>
         * 
         * @param attachmentUploadErrorReason
         *        A description of why the upload didn't successfully complete.
         * @see AttachmentUploadErrorReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentUploadErrorReason
         */
        Builder attachmentUploadErrorReason(AttachmentUploadErrorReason attachmentUploadErrorReason);

        /**
         * <p>
         * The time when the registration attachment was created, in <a href="https://www.epochconverter.com/">UNIX
         * epoch time</a> format.
         * </p>
         * 
         * @param createdTimestamp
         *        The time when the registration attachment was created, in <a
         *        href="https://www.epochconverter.com/">UNIX epoch time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String registrationAttachmentArn;

        private String registrationAttachmentId;

        private String attachmentStatus;

        private String attachmentUploadErrorReason;

        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(RegistrationAttachmentsInformation model) {
            registrationAttachmentArn(model.registrationAttachmentArn);
            registrationAttachmentId(model.registrationAttachmentId);
            attachmentStatus(model.attachmentStatus);
            attachmentUploadErrorReason(model.attachmentUploadErrorReason);
            createdTimestamp(model.createdTimestamp);
        }

        public final String getRegistrationAttachmentArn() {
            return registrationAttachmentArn;
        }

        public final void setRegistrationAttachmentArn(String registrationAttachmentArn) {
            this.registrationAttachmentArn = registrationAttachmentArn;
        }

        @Override
        public final Builder registrationAttachmentArn(String registrationAttachmentArn) {
            this.registrationAttachmentArn = registrationAttachmentArn;
            return this;
        }

        public final String getRegistrationAttachmentId() {
            return registrationAttachmentId;
        }

        public final void setRegistrationAttachmentId(String registrationAttachmentId) {
            this.registrationAttachmentId = registrationAttachmentId;
        }

        @Override
        public final Builder registrationAttachmentId(String registrationAttachmentId) {
            this.registrationAttachmentId = registrationAttachmentId;
            return this;
        }

        public final String getAttachmentStatus() {
            return attachmentStatus;
        }

        public final void setAttachmentStatus(String attachmentStatus) {
            this.attachmentStatus = attachmentStatus;
        }

        @Override
        public final Builder attachmentStatus(String attachmentStatus) {
            this.attachmentStatus = attachmentStatus;
            return this;
        }

        @Override
        public final Builder attachmentStatus(AttachmentStatus attachmentStatus) {
            this.attachmentStatus(attachmentStatus == null ? null : attachmentStatus.toString());
            return this;
        }

        public final String getAttachmentUploadErrorReason() {
            return attachmentUploadErrorReason;
        }

        public final void setAttachmentUploadErrorReason(String attachmentUploadErrorReason) {
            this.attachmentUploadErrorReason = attachmentUploadErrorReason;
        }

        @Override
        public final Builder attachmentUploadErrorReason(String attachmentUploadErrorReason) {
            this.attachmentUploadErrorReason = attachmentUploadErrorReason;
            return this;
        }

        @Override
        public final Builder attachmentUploadErrorReason(AttachmentUploadErrorReason attachmentUploadErrorReason) {
            this.attachmentUploadErrorReason(attachmentUploadErrorReason == null ? null : attachmentUploadErrorReason.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public RegistrationAttachmentsInformation build() {
            return new RegistrationAttachmentsInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
