/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestSenderIdResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<RequestSenderIdResponse.Builder, RequestSenderIdResponse> {
    private static final SdkField<String> SENDER_ID_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderIdArn").getter(getter(RequestSenderIdResponse::senderIdArn)).setter(setter(Builder::senderIdArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderIdArn").build()).build();

    private static final SdkField<String> SENDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderId").getter(getter(RequestSenderIdResponse::senderId)).setter(setter(Builder::senderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderId").build()).build();

    private static final SdkField<String> ISO_COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IsoCountryCode").getter(getter(RequestSenderIdResponse::isoCountryCode))
            .setter(setter(Builder::isoCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoCountryCode").build()).build();

    private static final SdkField<List<String>> MESSAGE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MessageTypes")
            .getter(getter(RequestSenderIdResponse::messageTypesAsStrings))
            .setter(setter(Builder::messageTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MONTHLY_LEASING_PRICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonthlyLeasingPrice").getter(getter(RequestSenderIdResponse::monthlyLeasingPrice))
            .setter(setter(Builder::monthlyLeasingPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonthlyLeasingPrice").build())
            .build();

    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DeletionProtectionEnabled")
            .getter(getter(RequestSenderIdResponse::deletionProtectionEnabled))
            .setter(setter(Builder::deletionProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtectionEnabled").build())
            .build();

    private static final SdkField<Boolean> REGISTERED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Registered").getter(getter(RequestSenderIdResponse::registered)).setter(setter(Builder::registered))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Registered").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(RequestSenderIdResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SENDER_ID_ARN_FIELD,
            SENDER_ID_FIELD, ISO_COUNTRY_CODE_FIELD, MESSAGE_TYPES_FIELD, MONTHLY_LEASING_PRICE_FIELD,
            DELETION_PROTECTION_ENABLED_FIELD, REGISTERED_FIELD, TAGS_FIELD));

    private final String senderIdArn;

    private final String senderId;

    private final String isoCountryCode;

    private final List<String> messageTypes;

    private final String monthlyLeasingPrice;

    private final Boolean deletionProtectionEnabled;

    private final Boolean registered;

    private final List<Tag> tags;

    private RequestSenderIdResponse(BuilderImpl builder) {
        super(builder);
        this.senderIdArn = builder.senderIdArn;
        this.senderId = builder.senderId;
        this.isoCountryCode = builder.isoCountryCode;
        this.messageTypes = builder.messageTypes;
        this.monthlyLeasingPrice = builder.monthlyLeasingPrice;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
        this.registered = builder.registered;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with the SenderId.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) associated with the SenderId.
     */
    public final String senderIdArn() {
        return senderIdArn;
    }

    /**
     * <p>
     * The sender ID that was requested.
     * </p>
     * 
     * @return The sender ID that was requested.
     */
    public final String senderId() {
        return senderId;
    }

    /**
     * <p>
     * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     * </p>
     * 
     * @return The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     */
    public final String isoCountryCode() {
        return isoCountryCode;
    }

    /**
     * <p>
     * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
     * PROMOTIONAL for messages that aren't critical or time-sensitive.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessageTypes} method.
     * </p>
     * 
     * @return The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
     *         PROMOTIONAL for messages that aren't critical or time-sensitive.
     */
    public final List<MessageType> messageTypes() {
        return MessageTypeListCopier.copyStringToEnum(messageTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the MessageTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMessageTypes() {
        return messageTypes != null && !(messageTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
     * PROMOTIONAL for messages that aren't critical or time-sensitive.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessageTypes} method.
     * </p>
     * 
     * @return The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
     *         PROMOTIONAL for messages that aren't critical or time-sensitive.
     */
    public final List<String> messageTypesAsStrings() {
        return messageTypes;
    }

    /**
     * <p>
     * The monthly price, in US dollars, to lease the sender ID.
     * </p>
     * 
     * @return The monthly price, in US dollars, to lease the sender ID.
     */
    public final String monthlyLeasingPrice() {
        return monthlyLeasingPrice;
    }

    /**
     * <p>
     * By default this is set to false. When set to true the sender ID can't be deleted.
     * </p>
     * 
     * @return By default this is set to false. When set to true the sender ID can't be deleted.
     */
    public final Boolean deletionProtectionEnabled() {
        return deletionProtectionEnabled;
    }

    /**
     * <p>
     * True if the sender ID is registered.
     * </p>
     * 
     * @return True if the sender ID is registered.
     */
    public final Boolean registered() {
        return registered;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of tags (key and value pairs) to associate with the sender ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of tags (key and value pairs) to associate with the sender ID.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(senderIdArn());
        hashCode = 31 * hashCode + Objects.hashCode(senderId());
        hashCode = 31 * hashCode + Objects.hashCode(isoCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasMessageTypes() ? messageTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(monthlyLeasingPrice());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(registered());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestSenderIdResponse)) {
            return false;
        }
        RequestSenderIdResponse other = (RequestSenderIdResponse) obj;
        return Objects.equals(senderIdArn(), other.senderIdArn()) && Objects.equals(senderId(), other.senderId())
                && Objects.equals(isoCountryCode(), other.isoCountryCode()) && hasMessageTypes() == other.hasMessageTypes()
                && Objects.equals(messageTypesAsStrings(), other.messageTypesAsStrings())
                && Objects.equals(monthlyLeasingPrice(), other.monthlyLeasingPrice())
                && Objects.equals(deletionProtectionEnabled(), other.deletionProtectionEnabled())
                && Objects.equals(registered(), other.registered()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequestSenderIdResponse").add("SenderIdArn", senderIdArn()).add("SenderId", senderId())
                .add("IsoCountryCode", isoCountryCode()).add("MessageTypes", hasMessageTypes() ? messageTypesAsStrings() : null)
                .add("MonthlyLeasingPrice", monthlyLeasingPrice()).add("DeletionProtectionEnabled", deletionProtectionEnabled())
                .add("Registered", registered()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SenderIdArn":
            return Optional.ofNullable(clazz.cast(senderIdArn()));
        case "SenderId":
            return Optional.ofNullable(clazz.cast(senderId()));
        case "IsoCountryCode":
            return Optional.ofNullable(clazz.cast(isoCountryCode()));
        case "MessageTypes":
            return Optional.ofNullable(clazz.cast(messageTypesAsStrings()));
        case "MonthlyLeasingPrice":
            return Optional.ofNullable(clazz.cast(monthlyLeasingPrice()));
        case "DeletionProtectionEnabled":
            return Optional.ofNullable(clazz.cast(deletionProtectionEnabled()));
        case "Registered":
            return Optional.ofNullable(clazz.cast(registered()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestSenderIdResponse, T> g) {
        return obj -> g.apply((RequestSenderIdResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, RequestSenderIdResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) associated with the SenderId.
         * </p>
         * 
         * @param senderIdArn
         *        The Amazon Resource Name (ARN) associated with the SenderId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderIdArn(String senderIdArn);

        /**
         * <p>
         * The sender ID that was requested.
         * </p>
         * 
         * @param senderId
         *        The sender ID that was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderId(String senderId);

        /**
         * <p>
         * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * </p>
         * 
         * @param isoCountryCode
         *        The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isoCountryCode(String isoCountryCode);

        /**
         * <p>
         * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
         * PROMOTIONAL for messages that aren't critical or time-sensitive.
         * </p>
         * 
         * @param messageTypes
         *        The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive
         *        and PROMOTIONAL for messages that aren't critical or time-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTypesWithStrings(Collection<String> messageTypes);

        /**
         * <p>
         * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
         * PROMOTIONAL for messages that aren't critical or time-sensitive.
         * </p>
         * 
         * @param messageTypes
         *        The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive
         *        and PROMOTIONAL for messages that aren't critical or time-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTypesWithStrings(String... messageTypes);

        /**
         * <p>
         * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
         * PROMOTIONAL for messages that aren't critical or time-sensitive.
         * </p>
         * 
         * @param messageTypes
         *        The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive
         *        and PROMOTIONAL for messages that aren't critical or time-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTypes(Collection<MessageType> messageTypes);

        /**
         * <p>
         * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
         * PROMOTIONAL for messages that aren't critical or time-sensitive.
         * </p>
         * 
         * @param messageTypes
         *        The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive
         *        and PROMOTIONAL for messages that aren't critical or time-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTypes(MessageType... messageTypes);

        /**
         * <p>
         * The monthly price, in US dollars, to lease the sender ID.
         * </p>
         * 
         * @param monthlyLeasingPrice
         *        The monthly price, in US dollars, to lease the sender ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monthlyLeasingPrice(String monthlyLeasingPrice);

        /**
         * <p>
         * By default this is set to false. When set to true the sender ID can't be deleted.
         * </p>
         * 
         * @param deletionProtectionEnabled
         *        By default this is set to false. When set to true the sender ID can't be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled);

        /**
         * <p>
         * True if the sender ID is registered.
         * </p>
         * 
         * @param registered
         *        True if the sender ID is registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registered(Boolean registered);

        /**
         * <p>
         * An array of tags (key and value pairs) to associate with the sender ID.
         * </p>
         * 
         * @param tags
         *        An array of tags (key and value pairs) to associate with the sender ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of tags (key and value pairs) to associate with the sender ID.
         * </p>
         * 
         * @param tags
         *        An array of tags (key and value pairs) to associate with the sender ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of tags (key and value pairs) to associate with the sender ID.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String senderIdArn;

        private String senderId;

        private String isoCountryCode;

        private List<String> messageTypes = DefaultSdkAutoConstructList.getInstance();

        private String monthlyLeasingPrice;

        private Boolean deletionProtectionEnabled;

        private Boolean registered;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RequestSenderIdResponse model) {
            super(model);
            senderIdArn(model.senderIdArn);
            senderId(model.senderId);
            isoCountryCode(model.isoCountryCode);
            messageTypesWithStrings(model.messageTypes);
            monthlyLeasingPrice(model.monthlyLeasingPrice);
            deletionProtectionEnabled(model.deletionProtectionEnabled);
            registered(model.registered);
            tags(model.tags);
        }

        public final String getSenderIdArn() {
            return senderIdArn;
        }

        public final void setSenderIdArn(String senderIdArn) {
            this.senderIdArn = senderIdArn;
        }

        @Override
        public final Builder senderIdArn(String senderIdArn) {
            this.senderIdArn = senderIdArn;
            return this;
        }

        public final String getSenderId() {
            return senderId;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final String getIsoCountryCode() {
            return isoCountryCode;
        }

        public final void setIsoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
        }

        @Override
        public final Builder isoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        public final Collection<String> getMessageTypes() {
            if (messageTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return messageTypes;
        }

        public final void setMessageTypes(Collection<String> messageTypes) {
            this.messageTypes = MessageTypeListCopier.copy(messageTypes);
        }

        @Override
        public final Builder messageTypesWithStrings(Collection<String> messageTypes) {
            this.messageTypes = MessageTypeListCopier.copy(messageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageTypesWithStrings(String... messageTypes) {
            messageTypesWithStrings(Arrays.asList(messageTypes));
            return this;
        }

        @Override
        public final Builder messageTypes(Collection<MessageType> messageTypes) {
            this.messageTypes = MessageTypeListCopier.copyEnumToString(messageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageTypes(MessageType... messageTypes) {
            messageTypes(Arrays.asList(messageTypes));
            return this;
        }

        public final String getMonthlyLeasingPrice() {
            return monthlyLeasingPrice;
        }

        public final void setMonthlyLeasingPrice(String monthlyLeasingPrice) {
            this.monthlyLeasingPrice = monthlyLeasingPrice;
        }

        @Override
        public final Builder monthlyLeasingPrice(String monthlyLeasingPrice) {
            this.monthlyLeasingPrice = monthlyLeasingPrice;
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        public final Boolean getRegistered() {
            return registered;
        }

        public final void setRegistered(Boolean registered) {
            this.registered = registered;
        }

        @Override
        public final Builder registered(Boolean registered) {
            this.registered = registered;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RequestSenderIdResponse build() {
            return new RequestSenderIdResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
