/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ServiceQuotaExceededExceptionReason {
    ASSOCIATIONS_PER_REGISTRATION("ASSOCIATIONS_PER_REGISTRATION"),

    CONFIGURATION_SETS_PER_ACCOUNT("CONFIGURATION_SETS_PER_ACCOUNT"),

    DAILY_DESTINATION_CALL_LIMIT("DAILY_DESTINATION_CALL_LIMIT"),

    EVENT_DESTINATIONS_PER_CONFIGURATION_SET("EVENT_DESTINATIONS_PER_CONFIGURATION_SET"),

    KEYWORDS_PER_PHONE_NUMBER("KEYWORDS_PER_PHONE_NUMBER"),

    KEYWORDS_PER_POOL("KEYWORDS_PER_POOL"),

    MONTHLY_SPEND_LIMIT_REACHED_FOR_TEXT("MONTHLY_SPEND_LIMIT_REACHED_FOR_TEXT"),

    MONTHLY_SPEND_LIMIT_REACHED_FOR_VOICE("MONTHLY_SPEND_LIMIT_REACHED_FOR_VOICE"),

    OPT_OUT_LISTS_PER_ACCOUNT("OPT_OUT_LISTS_PER_ACCOUNT"),

    ORIGINATION_IDENTITIES_PER_POOL("ORIGINATION_IDENTITIES_PER_POOL"),

    PHONE_NUMBERS_PER_ACCOUNT("PHONE_NUMBERS_PER_ACCOUNT"),

    PHONE_NUMBERS_PER_REGISTRATION("PHONE_NUMBERS_PER_REGISTRATION"),

    POOLS_PER_ACCOUNT("POOLS_PER_ACCOUNT"),

    REGISTRATION_ATTACHMENTS_CREATED_PER_DAY("REGISTRATION_ATTACHMENTS_CREATED_PER_DAY"),

    REGISTRATION_ATTACHMENTS_PER_ACCOUNT("REGISTRATION_ATTACHMENTS_PER_ACCOUNT"),

    REGISTRATION_VERSIONS_CREATED_PER_DAY("REGISTRATION_VERSIONS_CREATED_PER_DAY"),

    REGISTRATIONS_PER_ACCOUNT("REGISTRATIONS_PER_ACCOUNT"),

    SENDER_IDS_PER_ACCOUNT("SENDER_IDS_PER_ACCOUNT"),

    TAGS_PER_RESOURCE("TAGS_PER_RESOURCE"),

    VERIFIED_DESTINATION_NUMBERS_PER_ACCOUNT("VERIFIED_DESTINATION_NUMBERS_PER_ACCOUNT"),

    VERIFICATION_ATTEMPTS_PER_DAY("VERIFICATION_ATTEMPTS_PER_DAY"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceQuotaExceededExceptionReason> VALUE_MAP = EnumUtils.uniqueIndex(
            ServiceQuotaExceededExceptionReason.class, ServiceQuotaExceededExceptionReason::toString);

    private final String value;

    private ServiceQuotaExceededExceptionReason(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ServiceQuotaExceededExceptionReason corresponding to the value
     */
    public static ServiceQuotaExceededExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ServiceQuotaExceededExceptionReason}s
     */
    public static Set<ServiceQuotaExceededExceptionReason> knownValues() {
        Set<ServiceQuotaExceededExceptionReason> knownValues = EnumSet.allOf(ServiceQuotaExceededExceptionReason.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
