/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePhoneNumberRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<UpdatePhoneNumberRequest.Builder, UpdatePhoneNumberRequest> {
    private static final SdkField<String> PHONE_NUMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberId").getter(getter(UpdatePhoneNumberRequest::phoneNumberId))
            .setter(setter(Builder::phoneNumberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberId").build()).build();

    private static final SdkField<Boolean> TWO_WAY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TwoWayEnabled").getter(getter(UpdatePhoneNumberRequest::twoWayEnabled))
            .setter(setter(Builder::twoWayEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayEnabled").build()).build();

    private static final SdkField<String> TWO_WAY_CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TwoWayChannelArn").getter(getter(UpdatePhoneNumberRequest::twoWayChannelArn))
            .setter(setter(Builder::twoWayChannelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayChannelArn").build()).build();

    private static final SdkField<String> TWO_WAY_CHANNEL_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TwoWayChannelRole").getter(getter(UpdatePhoneNumberRequest::twoWayChannelRole))
            .setter(setter(Builder::twoWayChannelRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayChannelRole").build()).build();

    private static final SdkField<Boolean> SELF_MANAGED_OPT_OUTS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("SelfManagedOptOutsEnabled")
            .getter(getter(UpdatePhoneNumberRequest::selfManagedOptOutsEnabled))
            .setter(setter(Builder::selfManagedOptOutsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedOptOutsEnabled").build())
            .build();

    private static final SdkField<String> OPT_OUT_LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptOutListName").getter(getter(UpdatePhoneNumberRequest::optOutListName))
            .setter(setter(Builder::optOutListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListName").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DeletionProtectionEnabled")
            .getter(getter(UpdatePhoneNumberRequest::deletionProtectionEnabled))
            .setter(setter(Builder::deletionProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtectionEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ID_FIELD,
            TWO_WAY_ENABLED_FIELD, TWO_WAY_CHANNEL_ARN_FIELD, TWO_WAY_CHANNEL_ROLE_FIELD, SELF_MANAGED_OPT_OUTS_ENABLED_FIELD,
            OPT_OUT_LIST_NAME_FIELD, DELETION_PROTECTION_ENABLED_FIELD));

    private final String phoneNumberId;

    private final Boolean twoWayEnabled;

    private final String twoWayChannelArn;

    private final String twoWayChannelRole;

    private final Boolean selfManagedOptOutsEnabled;

    private final String optOutListName;

    private final Boolean deletionProtectionEnabled;

    private UpdatePhoneNumberRequest(BuilderImpl builder) {
        super(builder);
        this.phoneNumberId = builder.phoneNumberId;
        this.twoWayEnabled = builder.twoWayEnabled;
        this.twoWayChannelArn = builder.twoWayChannelArn;
        this.twoWayChannelRole = builder.twoWayChannelRole;
        this.selfManagedOptOutsEnabled = builder.selfManagedOptOutsEnabled;
        this.optOutListName = builder.optOutListName;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
    }

    /**
     * <p>
     * The unique identifier of the phone number. Valid values for this field can be either the PhoneNumberId or
     * PhoneNumberArn.
     * </p>
     * 
     * @return The unique identifier of the phone number. Valid values for this field can be either the PhoneNumberId or
     *         PhoneNumberArn.
     */
    public final String phoneNumberId() {
        return phoneNumberId;
    }

    /**
     * <p>
     * By default this is set to false. When set to true you can receive incoming text messages from your end
     * recipients.
     * </p>
     * 
     * @return By default this is set to false. When set to true you can receive incoming text messages from your end
     *         recipients.
     */
    public final Boolean twoWayEnabled() {
        return twoWayEnabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the two way channel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the two way channel.
     */
    public final String twoWayChannelArn() {
        return twoWayChannelArn;
    }

    /**
     * <p>
     * An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
     * </p>
     * 
     * @return An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
     */
    public final String twoWayChannelRole() {
        return twoWayChannelRole;
    }

    /**
     * <p>
     * By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of
     * your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end
     * recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're
     * also responsible for tracking and honoring opt-out requests.
     * </p>
     * 
     * @return By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to
     *         one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds
     *         the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP
     *         requests. You're also responsible for tracking and honoring opt-out requests.
     */
    public final Boolean selfManagedOptOutsEnabled() {
        return selfManagedOptOutsEnabled;
    }

    /**
     * <p>
     * The OptOutList to add the phone number to. Valid values for this field can be either the OutOutListName or
     * OutOutListArn.
     * </p>
     * 
     * @return The OptOutList to add the phone number to. Valid values for this field can be either the OutOutListName
     *         or OutOutListArn.
     */
    public final String optOutListName() {
        return optOutListName;
    }

    /**
     * <p>
     * By default this is set to false. When set to true the phone number can't be deleted.
     * </p>
     * 
     * @return By default this is set to false. When set to true the phone number can't be deleted.
     */
    public final Boolean deletionProtectionEnabled() {
        return deletionProtectionEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(twoWayEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(twoWayChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(twoWayChannelRole());
        hashCode = 31 * hashCode + Objects.hashCode(selfManagedOptOutsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(optOutListName());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePhoneNumberRequest)) {
            return false;
        }
        UpdatePhoneNumberRequest other = (UpdatePhoneNumberRequest) obj;
        return Objects.equals(phoneNumberId(), other.phoneNumberId()) && Objects.equals(twoWayEnabled(), other.twoWayEnabled())
                && Objects.equals(twoWayChannelArn(), other.twoWayChannelArn())
                && Objects.equals(twoWayChannelRole(), other.twoWayChannelRole())
                && Objects.equals(selfManagedOptOutsEnabled(), other.selfManagedOptOutsEnabled())
                && Objects.equals(optOutListName(), other.optOutListName())
                && Objects.equals(deletionProtectionEnabled(), other.deletionProtectionEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePhoneNumberRequest").add("PhoneNumberId", phoneNumberId())
                .add("TwoWayEnabled", twoWayEnabled()).add("TwoWayChannelArn", twoWayChannelArn())
                .add("TwoWayChannelRole", twoWayChannelRole()).add("SelfManagedOptOutsEnabled", selfManagedOptOutsEnabled())
                .add("OptOutListName", optOutListName()).add("DeletionProtectionEnabled", deletionProtectionEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumberId":
            return Optional.ofNullable(clazz.cast(phoneNumberId()));
        case "TwoWayEnabled":
            return Optional.ofNullable(clazz.cast(twoWayEnabled()));
        case "TwoWayChannelArn":
            return Optional.ofNullable(clazz.cast(twoWayChannelArn()));
        case "TwoWayChannelRole":
            return Optional.ofNullable(clazz.cast(twoWayChannelRole()));
        case "SelfManagedOptOutsEnabled":
            return Optional.ofNullable(clazz.cast(selfManagedOptOutsEnabled()));
        case "OptOutListName":
            return Optional.ofNullable(clazz.cast(optOutListName()));
        case "DeletionProtectionEnabled":
            return Optional.ofNullable(clazz.cast(deletionProtectionEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePhoneNumberRequest, T> g) {
        return obj -> g.apply((UpdatePhoneNumberRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePhoneNumberRequest> {
        /**
         * <p>
         * The unique identifier of the phone number. Valid values for this field can be either the PhoneNumberId or
         * PhoneNumberArn.
         * </p>
         * 
         * @param phoneNumberId
         *        The unique identifier of the phone number. Valid values for this field can be either the PhoneNumberId
         *        or PhoneNumberArn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberId(String phoneNumberId);

        /**
         * <p>
         * By default this is set to false. When set to true you can receive incoming text messages from your end
         * recipients.
         * </p>
         * 
         * @param twoWayEnabled
         *        By default this is set to false. When set to true you can receive incoming text messages from your end
         *        recipients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twoWayEnabled(Boolean twoWayEnabled);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the two way channel.
         * </p>
         * 
         * @param twoWayChannelArn
         *        The Amazon Resource Name (ARN) of the two way channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twoWayChannelArn(String twoWayChannelArn);

        /**
         * <p>
         * An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
         * </p>
         * 
         * @param twoWayChannelRole
         *        An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twoWayChannelRole(String twoWayChannelRole);

        /**
         * <p>
         * By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one
         * of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end
         * recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests.
         * You're also responsible for tracking and honoring opt-out requests.
         * </p>
         * 
         * @param selfManagedOptOutsEnabled
         *        By default this is set to false. When an end recipient sends a message that begins with HELP or STOP
         *        to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message
         *        and adds the end recipient to the OptOutList. When set to true you're responsible for responding to
         *        HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled);

        /**
         * <p>
         * The OptOutList to add the phone number to. Valid values for this field can be either the OutOutListName or
         * OutOutListArn.
         * </p>
         * 
         * @param optOutListName
         *        The OptOutList to add the phone number to. Valid values for this field can be either the
         *        OutOutListName or OutOutListArn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optOutListName(String optOutListName);

        /**
         * <p>
         * By default this is set to false. When set to true the phone number can't be deleted.
         * </p>
         * 
         * @param deletionProtectionEnabled
         *        By default this is set to false. When set to true the phone number can't be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String phoneNumberId;

        private Boolean twoWayEnabled;

        private String twoWayChannelArn;

        private String twoWayChannelRole;

        private Boolean selfManagedOptOutsEnabled;

        private String optOutListName;

        private Boolean deletionProtectionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePhoneNumberRequest model) {
            super(model);
            phoneNumberId(model.phoneNumberId);
            twoWayEnabled(model.twoWayEnabled);
            twoWayChannelArn(model.twoWayChannelArn);
            twoWayChannelRole(model.twoWayChannelRole);
            selfManagedOptOutsEnabled(model.selfManagedOptOutsEnabled);
            optOutListName(model.optOutListName);
            deletionProtectionEnabled(model.deletionProtectionEnabled);
        }

        public final String getPhoneNumberId() {
            return phoneNumberId;
        }

        public final void setPhoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
        }

        @Override
        public final Builder phoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
            return this;
        }

        public final Boolean getTwoWayEnabled() {
            return twoWayEnabled;
        }

        public final void setTwoWayEnabled(Boolean twoWayEnabled) {
            this.twoWayEnabled = twoWayEnabled;
        }

        @Override
        public final Builder twoWayEnabled(Boolean twoWayEnabled) {
            this.twoWayEnabled = twoWayEnabled;
            return this;
        }

        public final String getTwoWayChannelArn() {
            return twoWayChannelArn;
        }

        public final void setTwoWayChannelArn(String twoWayChannelArn) {
            this.twoWayChannelArn = twoWayChannelArn;
        }

        @Override
        public final Builder twoWayChannelArn(String twoWayChannelArn) {
            this.twoWayChannelArn = twoWayChannelArn;
            return this;
        }

        public final String getTwoWayChannelRole() {
            return twoWayChannelRole;
        }

        public final void setTwoWayChannelRole(String twoWayChannelRole) {
            this.twoWayChannelRole = twoWayChannelRole;
        }

        @Override
        public final Builder twoWayChannelRole(String twoWayChannelRole) {
            this.twoWayChannelRole = twoWayChannelRole;
            return this;
        }

        public final Boolean getSelfManagedOptOutsEnabled() {
            return selfManagedOptOutsEnabled;
        }

        public final void setSelfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
        }

        @Override
        public final Builder selfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
            return this;
        }

        public final String getOptOutListName() {
            return optOutListName;
        }

        public final void setOptOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
        }

        @Override
        public final Builder optOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePhoneNumberRequest build() {
            return new UpdatePhoneNumberRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
