/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePhoneNumberResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<UpdatePhoneNumberResponse.Builder, UpdatePhoneNumberResponse> {
    private static final SdkField<String> PHONE_NUMBER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberArn").getter(getter(UpdatePhoneNumberResponse::phoneNumberArn))
            .setter(setter(Builder::phoneNumberArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberArn").build()).build();

    private static final SdkField<String> PHONE_NUMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberId").getter(getter(UpdatePhoneNumberResponse::phoneNumberId))
            .setter(setter(Builder::phoneNumberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberId").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(UpdatePhoneNumberResponse::phoneNumber))
            .setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdatePhoneNumberResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ISO_COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IsoCountryCode").getter(getter(UpdatePhoneNumberResponse::isoCountryCode))
            .setter(setter(Builder::isoCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoCountryCode").build()).build();

    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageType").getter(getter(UpdatePhoneNumberResponse::messageTypeAsString))
            .setter(setter(Builder::messageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()).build();

    private static final SdkField<List<String>> NUMBER_CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NumberCapabilities")
            .getter(getter(UpdatePhoneNumberResponse::numberCapabilitiesAsStrings))
            .setter(setter(Builder::numberCapabilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberCapabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NUMBER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NumberType").getter(getter(UpdatePhoneNumberResponse::numberTypeAsString))
            .setter(setter(Builder::numberType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberType").build()).build();

    private static final SdkField<String> MONTHLY_LEASING_PRICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonthlyLeasingPrice").getter(getter(UpdatePhoneNumberResponse::monthlyLeasingPrice))
            .setter(setter(Builder::monthlyLeasingPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonthlyLeasingPrice").build())
            .build();

    private static final SdkField<Boolean> TWO_WAY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TwoWayEnabled").getter(getter(UpdatePhoneNumberResponse::twoWayEnabled))
            .setter(setter(Builder::twoWayEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayEnabled").build()).build();

    private static final SdkField<String> TWO_WAY_CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TwoWayChannelArn").getter(getter(UpdatePhoneNumberResponse::twoWayChannelArn))
            .setter(setter(Builder::twoWayChannelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayChannelArn").build()).build();

    private static final SdkField<String> TWO_WAY_CHANNEL_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TwoWayChannelRole").getter(getter(UpdatePhoneNumberResponse::twoWayChannelRole))
            .setter(setter(Builder::twoWayChannelRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayChannelRole").build()).build();

    private static final SdkField<Boolean> SELF_MANAGED_OPT_OUTS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("SelfManagedOptOutsEnabled")
            .getter(getter(UpdatePhoneNumberResponse::selfManagedOptOutsEnabled))
            .setter(setter(Builder::selfManagedOptOutsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedOptOutsEnabled").build())
            .build();

    private static final SdkField<String> OPT_OUT_LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptOutListName").getter(getter(UpdatePhoneNumberResponse::optOutListName))
            .setter(setter(Builder::optOutListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListName").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DeletionProtectionEnabled")
            .getter(getter(UpdatePhoneNumberResponse::deletionProtectionEnabled))
            .setter(setter(Builder::deletionProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtectionEnabled").build())
            .build();

    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationId").getter(getter(UpdatePhoneNumberResponse::registrationId))
            .setter(setter(Builder::registrationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationId").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(UpdatePhoneNumberResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ARN_FIELD,
            PHONE_NUMBER_ID_FIELD, PHONE_NUMBER_FIELD, STATUS_FIELD, ISO_COUNTRY_CODE_FIELD, MESSAGE_TYPE_FIELD,
            NUMBER_CAPABILITIES_FIELD, NUMBER_TYPE_FIELD, MONTHLY_LEASING_PRICE_FIELD, TWO_WAY_ENABLED_FIELD,
            TWO_WAY_CHANNEL_ARN_FIELD, TWO_WAY_CHANNEL_ROLE_FIELD, SELF_MANAGED_OPT_OUTS_ENABLED_FIELD, OPT_OUT_LIST_NAME_FIELD,
            DELETION_PROTECTION_ENABLED_FIELD, REGISTRATION_ID_FIELD, CREATED_TIMESTAMP_FIELD));

    private final String phoneNumberArn;

    private final String phoneNumberId;

    private final String phoneNumber;

    private final String status;

    private final String isoCountryCode;

    private final String messageType;

    private final List<String> numberCapabilities;

    private final String numberType;

    private final String monthlyLeasingPrice;

    private final Boolean twoWayEnabled;

    private final String twoWayChannelArn;

    private final String twoWayChannelRole;

    private final Boolean selfManagedOptOutsEnabled;

    private final String optOutListName;

    private final Boolean deletionProtectionEnabled;

    private final String registrationId;

    private final Instant createdTimestamp;

    private UpdatePhoneNumberResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumberArn = builder.phoneNumberArn;
        this.phoneNumberId = builder.phoneNumberId;
        this.phoneNumber = builder.phoneNumber;
        this.status = builder.status;
        this.isoCountryCode = builder.isoCountryCode;
        this.messageType = builder.messageType;
        this.numberCapabilities = builder.numberCapabilities;
        this.numberType = builder.numberType;
        this.monthlyLeasingPrice = builder.monthlyLeasingPrice;
        this.twoWayEnabled = builder.twoWayEnabled;
        this.twoWayChannelArn = builder.twoWayChannelArn;
        this.twoWayChannelRole = builder.twoWayChannelRole;
        this.selfManagedOptOutsEnabled = builder.selfManagedOptOutsEnabled;
        this.optOutListName = builder.optOutListName;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
        this.registrationId = builder.registrationId;
        this.createdTimestamp = builder.createdTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the updated phone number.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the updated phone number.
     */
    public final String phoneNumberArn() {
        return phoneNumberArn;
    }

    /**
     * <p>
     * The unique identifier of the phone number.
     * </p>
     * 
     * @return The unique identifier of the phone number.
     */
    public final String phoneNumberId() {
        return phoneNumberId;
    }

    /**
     * <p>
     * The phone number that was updated.
     * </p>
     * 
     * @return The phone number that was updated.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * The current status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NumberStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the request.
     * @see NumberStatus
     */
    public final NumberStatus status() {
        return NumberStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NumberStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the request.
     * @see NumberStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     * </p>
     * 
     * @return The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     */
    public final String isoCountryCode() {
        return isoCountryCode;
    }

    /**
     * <p>
     * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
     * PROMOTIONAL for messages that aren't critical or time-sensitive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
     *         PROMOTIONAL for messages that aren't critical or time-sensitive.
     * @see MessageType
     */
    public final MessageType messageType() {
        return MessageType.fromValue(messageType);
    }

    /**
     * <p>
     * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
     * PROMOTIONAL for messages that aren't critical or time-sensitive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
     *         PROMOTIONAL for messages that aren't critical or time-sensitive.
     * @see MessageType
     */
    public final String messageTypeAsString() {
        return messageType;
    }

    /**
     * <p>
     * Specifies if the number could be used for text messages, voice or both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNumberCapabilities} method.
     * </p>
     * 
     * @return Specifies if the number could be used for text messages, voice or both.
     */
    public final List<NumberCapability> numberCapabilities() {
        return NumberCapabilityListCopier.copyStringToEnum(numberCapabilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the NumberCapabilities property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNumberCapabilities() {
        return numberCapabilities != null && !(numberCapabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies if the number could be used for text messages, voice or both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNumberCapabilities} method.
     * </p>
     * 
     * @return Specifies if the number could be used for text messages, voice or both.
     */
    public final List<String> numberCapabilitiesAsStrings() {
        return numberCapabilities;
    }

    /**
     * <p>
     * The type of number that was requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #numberType} will
     * return {@link NumberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #numberTypeAsString}.
     * </p>
     * 
     * @return The type of number that was requested.
     * @see NumberType
     */
    public final NumberType numberType() {
        return NumberType.fromValue(numberType);
    }

    /**
     * <p>
     * The type of number that was requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #numberType} will
     * return {@link NumberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #numberTypeAsString}.
     * </p>
     * 
     * @return The type of number that was requested.
     * @see NumberType
     */
    public final String numberTypeAsString() {
        return numberType;
    }

    /**
     * <p>
     * The monthly leasing price of the phone number, in US dollars.
     * </p>
     * 
     * @return The monthly leasing price of the phone number, in US dollars.
     */
    public final String monthlyLeasingPrice() {
        return monthlyLeasingPrice;
    }

    /**
     * <p>
     * By default this is set to false. When set to true you can receive incoming text messages from your end
     * recipients.
     * </p>
     * 
     * @return By default this is set to false. When set to true you can receive incoming text messages from your end
     *         recipients.
     */
    public final Boolean twoWayEnabled() {
        return twoWayEnabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the two way channel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the two way channel.
     */
    public final String twoWayChannelArn() {
        return twoWayChannelArn;
    }

    /**
     * <p>
     * An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
     * </p>
     * 
     * @return An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
     */
    public final String twoWayChannelRole() {
        return twoWayChannelRole;
    }

    /**
     * <p>
     * This is true if self managed opt-out are enabled.
     * </p>
     * 
     * @return This is true if self managed opt-out are enabled.
     */
    public final Boolean selfManagedOptOutsEnabled() {
        return selfManagedOptOutsEnabled;
    }

    /**
     * <p>
     * The name of the OptOutList associated with the phone number.
     * </p>
     * 
     * @return The name of the OptOutList associated with the phone number.
     */
    public final String optOutListName() {
        return optOutListName;
    }

    /**
     * <p>
     * When set to true the phone number can't be deleted.
     * </p>
     * 
     * @return When set to true the phone number can't be deleted.
     */
    public final Boolean deletionProtectionEnabled() {
        return deletionProtectionEnabled;
    }

    /**
     * <p>
     * The unique identifier for the registration.
     * </p>
     * 
     * @return The unique identifier for the registration.
     */
    public final String registrationId() {
        return registrationId;
    }

    /**
     * <p>
     * The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a>
     * format.
     * </p>
     * 
     * @return The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch
     *         time</a> format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberArn());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isoCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasNumberCapabilities() ? numberCapabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(numberTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(monthlyLeasingPrice());
        hashCode = 31 * hashCode + Objects.hashCode(twoWayEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(twoWayChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(twoWayChannelRole());
        hashCode = 31 * hashCode + Objects.hashCode(selfManagedOptOutsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(optOutListName());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePhoneNumberResponse)) {
            return false;
        }
        UpdatePhoneNumberResponse other = (UpdatePhoneNumberResponse) obj;
        return Objects.equals(phoneNumberArn(), other.phoneNumberArn()) && Objects.equals(phoneNumberId(), other.phoneNumberId())
                && Objects.equals(phoneNumber(), other.phoneNumber()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(isoCountryCode(), other.isoCountryCode())
                && Objects.equals(messageTypeAsString(), other.messageTypeAsString())
                && hasNumberCapabilities() == other.hasNumberCapabilities()
                && Objects.equals(numberCapabilitiesAsStrings(), other.numberCapabilitiesAsStrings())
                && Objects.equals(numberTypeAsString(), other.numberTypeAsString())
                && Objects.equals(monthlyLeasingPrice(), other.monthlyLeasingPrice())
                && Objects.equals(twoWayEnabled(), other.twoWayEnabled())
                && Objects.equals(twoWayChannelArn(), other.twoWayChannelArn())
                && Objects.equals(twoWayChannelRole(), other.twoWayChannelRole())
                && Objects.equals(selfManagedOptOutsEnabled(), other.selfManagedOptOutsEnabled())
                && Objects.equals(optOutListName(), other.optOutListName())
                && Objects.equals(deletionProtectionEnabled(), other.deletionProtectionEnabled())
                && Objects.equals(registrationId(), other.registrationId())
                && Objects.equals(createdTimestamp(), other.createdTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePhoneNumberResponse").add("PhoneNumberArn", phoneNumberArn())
                .add("PhoneNumberId", phoneNumberId()).add("PhoneNumber", phoneNumber()).add("Status", statusAsString())
                .add("IsoCountryCode", isoCountryCode()).add("MessageType", messageTypeAsString())
                .add("NumberCapabilities", hasNumberCapabilities() ? numberCapabilitiesAsStrings() : null)
                .add("NumberType", numberTypeAsString()).add("MonthlyLeasingPrice", monthlyLeasingPrice())
                .add("TwoWayEnabled", twoWayEnabled()).add("TwoWayChannelArn", twoWayChannelArn())
                .add("TwoWayChannelRole", twoWayChannelRole()).add("SelfManagedOptOutsEnabled", selfManagedOptOutsEnabled())
                .add("OptOutListName", optOutListName()).add("DeletionProtectionEnabled", deletionProtectionEnabled())
                .add("RegistrationId", registrationId()).add("CreatedTimestamp", createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumberArn":
            return Optional.ofNullable(clazz.cast(phoneNumberArn()));
        case "PhoneNumberId":
            return Optional.ofNullable(clazz.cast(phoneNumberId()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "IsoCountryCode":
            return Optional.ofNullable(clazz.cast(isoCountryCode()));
        case "MessageType":
            return Optional.ofNullable(clazz.cast(messageTypeAsString()));
        case "NumberCapabilities":
            return Optional.ofNullable(clazz.cast(numberCapabilitiesAsStrings()));
        case "NumberType":
            return Optional.ofNullable(clazz.cast(numberTypeAsString()));
        case "MonthlyLeasingPrice":
            return Optional.ofNullable(clazz.cast(monthlyLeasingPrice()));
        case "TwoWayEnabled":
            return Optional.ofNullable(clazz.cast(twoWayEnabled()));
        case "TwoWayChannelArn":
            return Optional.ofNullable(clazz.cast(twoWayChannelArn()));
        case "TwoWayChannelRole":
            return Optional.ofNullable(clazz.cast(twoWayChannelRole()));
        case "SelfManagedOptOutsEnabled":
            return Optional.ofNullable(clazz.cast(selfManagedOptOutsEnabled()));
        case "OptOutListName":
            return Optional.ofNullable(clazz.cast(optOutListName()));
        case "DeletionProtectionEnabled":
            return Optional.ofNullable(clazz.cast(deletionProtectionEnabled()));
        case "RegistrationId":
            return Optional.ofNullable(clazz.cast(registrationId()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePhoneNumberResponse, T> g) {
        return obj -> g.apply((UpdatePhoneNumberResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePhoneNumberResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the updated phone number.
         * </p>
         * 
         * @param phoneNumberArn
         *        The Amazon Resource Name (ARN) of the updated phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberArn(String phoneNumberArn);

        /**
         * <p>
         * The unique identifier of the phone number.
         * </p>
         * 
         * @param phoneNumberId
         *        The unique identifier of the phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberId(String phoneNumberId);

        /**
         * <p>
         * The phone number that was updated.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * The current status of the request.
         * </p>
         * 
         * @param status
         *        The current status of the request.
         * @see NumberStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumberStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the request.
         * </p>
         * 
         * @param status
         *        The current status of the request.
         * @see NumberStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumberStatus
         */
        Builder status(NumberStatus status);

        /**
         * <p>
         * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * </p>
         * 
         * @param isoCountryCode
         *        The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isoCountryCode(String isoCountryCode);

        /**
         * <p>
         * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
         * PROMOTIONAL for messages that aren't critical or time-sensitive.
         * </p>
         * 
         * @param messageType
         *        The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive
         *        and PROMOTIONAL for messages that aren't critical or time-sensitive.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(String messageType);

        /**
         * <p>
         * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
         * PROMOTIONAL for messages that aren't critical or time-sensitive.
         * </p>
         * 
         * @param messageType
         *        The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive
         *        and PROMOTIONAL for messages that aren't critical or time-sensitive.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(MessageType messageType);

        /**
         * <p>
         * Specifies if the number could be used for text messages, voice or both.
         * </p>
         * 
         * @param numberCapabilities
         *        Specifies if the number could be used for text messages, voice or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberCapabilitiesWithStrings(Collection<String> numberCapabilities);

        /**
         * <p>
         * Specifies if the number could be used for text messages, voice or both.
         * </p>
         * 
         * @param numberCapabilities
         *        Specifies if the number could be used for text messages, voice or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberCapabilitiesWithStrings(String... numberCapabilities);

        /**
         * <p>
         * Specifies if the number could be used for text messages, voice or both.
         * </p>
         * 
         * @param numberCapabilities
         *        Specifies if the number could be used for text messages, voice or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberCapabilities(Collection<NumberCapability> numberCapabilities);

        /**
         * <p>
         * Specifies if the number could be used for text messages, voice or both.
         * </p>
         * 
         * @param numberCapabilities
         *        Specifies if the number could be used for text messages, voice or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberCapabilities(NumberCapability... numberCapabilities);

        /**
         * <p>
         * The type of number that was requested.
         * </p>
         * 
         * @param numberType
         *        The type of number that was requested.
         * @see NumberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumberType
         */
        Builder numberType(String numberType);

        /**
         * <p>
         * The type of number that was requested.
         * </p>
         * 
         * @param numberType
         *        The type of number that was requested.
         * @see NumberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumberType
         */
        Builder numberType(NumberType numberType);

        /**
         * <p>
         * The monthly leasing price of the phone number, in US dollars.
         * </p>
         * 
         * @param monthlyLeasingPrice
         *        The monthly leasing price of the phone number, in US dollars.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monthlyLeasingPrice(String monthlyLeasingPrice);

        /**
         * <p>
         * By default this is set to false. When set to true you can receive incoming text messages from your end
         * recipients.
         * </p>
         * 
         * @param twoWayEnabled
         *        By default this is set to false. When set to true you can receive incoming text messages from your end
         *        recipients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twoWayEnabled(Boolean twoWayEnabled);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the two way channel.
         * </p>
         * 
         * @param twoWayChannelArn
         *        The Amazon Resource Name (ARN) of the two way channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twoWayChannelArn(String twoWayChannelArn);

        /**
         * <p>
         * An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
         * </p>
         * 
         * @param twoWayChannelRole
         *        An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twoWayChannelRole(String twoWayChannelRole);

        /**
         * <p>
         * This is true if self managed opt-out are enabled.
         * </p>
         * 
         * @param selfManagedOptOutsEnabled
         *        This is true if self managed opt-out are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled);

        /**
         * <p>
         * The name of the OptOutList associated with the phone number.
         * </p>
         * 
         * @param optOutListName
         *        The name of the OptOutList associated with the phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optOutListName(String optOutListName);

        /**
         * <p>
         * When set to true the phone number can't be deleted.
         * </p>
         * 
         * @param deletionProtectionEnabled
         *        When set to true the phone number can't be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled);

        /**
         * <p>
         * The unique identifier for the registration.
         * </p>
         * 
         * @param registrationId
         *        The unique identifier for the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationId(String registrationId);

        /**
         * <p>
         * The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a>
         * format.
         * </p>
         * 
         * @param createdTimestamp
         *        The time when the phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch
         *        time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String phoneNumberArn;

        private String phoneNumberId;

        private String phoneNumber;

        private String status;

        private String isoCountryCode;

        private String messageType;

        private List<String> numberCapabilities = DefaultSdkAutoConstructList.getInstance();

        private String numberType;

        private String monthlyLeasingPrice;

        private Boolean twoWayEnabled;

        private String twoWayChannelArn;

        private String twoWayChannelRole;

        private Boolean selfManagedOptOutsEnabled;

        private String optOutListName;

        private Boolean deletionProtectionEnabled;

        private String registrationId;

        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePhoneNumberResponse model) {
            super(model);
            phoneNumberArn(model.phoneNumberArn);
            phoneNumberId(model.phoneNumberId);
            phoneNumber(model.phoneNumber);
            status(model.status);
            isoCountryCode(model.isoCountryCode);
            messageType(model.messageType);
            numberCapabilitiesWithStrings(model.numberCapabilities);
            numberType(model.numberType);
            monthlyLeasingPrice(model.monthlyLeasingPrice);
            twoWayEnabled(model.twoWayEnabled);
            twoWayChannelArn(model.twoWayChannelArn);
            twoWayChannelRole(model.twoWayChannelRole);
            selfManagedOptOutsEnabled(model.selfManagedOptOutsEnabled);
            optOutListName(model.optOutListName);
            deletionProtectionEnabled(model.deletionProtectionEnabled);
            registrationId(model.registrationId);
            createdTimestamp(model.createdTimestamp);
        }

        public final String getPhoneNumberArn() {
            return phoneNumberArn;
        }

        public final void setPhoneNumberArn(String phoneNumberArn) {
            this.phoneNumberArn = phoneNumberArn;
        }

        @Override
        public final Builder phoneNumberArn(String phoneNumberArn) {
            this.phoneNumberArn = phoneNumberArn;
            return this;
        }

        public final String getPhoneNumberId() {
            return phoneNumberId;
        }

        public final void setPhoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
        }

        @Override
        public final Builder phoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
            return this;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NumberStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getIsoCountryCode() {
            return isoCountryCode;
        }

        public final void setIsoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
        }

        @Override
        public final Builder isoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        public final String getMessageType() {
            return messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final Collection<String> getNumberCapabilities() {
            if (numberCapabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return numberCapabilities;
        }

        public final void setNumberCapabilities(Collection<String> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copy(numberCapabilities);
        }

        @Override
        public final Builder numberCapabilitiesWithStrings(Collection<String> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copy(numberCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberCapabilitiesWithStrings(String... numberCapabilities) {
            numberCapabilitiesWithStrings(Arrays.asList(numberCapabilities));
            return this;
        }

        @Override
        public final Builder numberCapabilities(Collection<NumberCapability> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copyEnumToString(numberCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberCapabilities(NumberCapability... numberCapabilities) {
            numberCapabilities(Arrays.asList(numberCapabilities));
            return this;
        }

        public final String getNumberType() {
            return numberType;
        }

        public final void setNumberType(String numberType) {
            this.numberType = numberType;
        }

        @Override
        public final Builder numberType(String numberType) {
            this.numberType = numberType;
            return this;
        }

        @Override
        public final Builder numberType(NumberType numberType) {
            this.numberType(numberType == null ? null : numberType.toString());
            return this;
        }

        public final String getMonthlyLeasingPrice() {
            return monthlyLeasingPrice;
        }

        public final void setMonthlyLeasingPrice(String monthlyLeasingPrice) {
            this.monthlyLeasingPrice = monthlyLeasingPrice;
        }

        @Override
        public final Builder monthlyLeasingPrice(String monthlyLeasingPrice) {
            this.monthlyLeasingPrice = monthlyLeasingPrice;
            return this;
        }

        public final Boolean getTwoWayEnabled() {
            return twoWayEnabled;
        }

        public final void setTwoWayEnabled(Boolean twoWayEnabled) {
            this.twoWayEnabled = twoWayEnabled;
        }

        @Override
        public final Builder twoWayEnabled(Boolean twoWayEnabled) {
            this.twoWayEnabled = twoWayEnabled;
            return this;
        }

        public final String getTwoWayChannelArn() {
            return twoWayChannelArn;
        }

        public final void setTwoWayChannelArn(String twoWayChannelArn) {
            this.twoWayChannelArn = twoWayChannelArn;
        }

        @Override
        public final Builder twoWayChannelArn(String twoWayChannelArn) {
            this.twoWayChannelArn = twoWayChannelArn;
            return this;
        }

        public final String getTwoWayChannelRole() {
            return twoWayChannelRole;
        }

        public final void setTwoWayChannelRole(String twoWayChannelRole) {
            this.twoWayChannelRole = twoWayChannelRole;
        }

        @Override
        public final Builder twoWayChannelRole(String twoWayChannelRole) {
            this.twoWayChannelRole = twoWayChannelRole;
            return this;
        }

        public final Boolean getSelfManagedOptOutsEnabled() {
            return selfManagedOptOutsEnabled;
        }

        public final void setSelfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
        }

        @Override
        public final Builder selfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
            return this;
        }

        public final String getOptOutListName() {
            return optOutListName;
        }

        public final void setOptOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
        }

        @Override
        public final Builder optOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        public final String getRegistrationId() {
            return registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public UpdatePhoneNumberResponse build() {
            return new UpdatePhoneNumberResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
