/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for using a Lambda function as a target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipeTargetLambdaFunctionParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<PipeTargetLambdaFunctionParameters.Builder, PipeTargetLambdaFunctionParameters> {
    private static final SdkField<String> INVOCATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvocationType").getter(getter(PipeTargetLambdaFunctionParameters::invocationTypeAsString))
            .setter(setter(Builder::invocationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String invocationType;

    private PipeTargetLambdaFunctionParameters(BuilderImpl builder) {
        this.invocationType = builder.invocationType;
    }

    /**
     * <p>
     * Specify whether to invoke the function synchronously or asynchronously.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REQUEST_RESPONSE</code> (default) - Invoke synchronously. This corresponds to the
     * <code>RequestResponse</code> option in the <code>InvocationType</code> parameter for the Lambda <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax">Invoke</a> API.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FIRE_AND_FORGET</code> - Invoke asynchronously. This corresponds to the <code>Event</code> option in the
     * <code>InvocationType</code> parameter for the Lambda <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax">Invoke</a> API.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-invocation">Invocation
     * types</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invocationType}
     * will return {@link PipeTargetInvocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #invocationTypeAsString}.
     * </p>
     * 
     * @return Specify whether to invoke the function synchronously or asynchronously.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REQUEST_RESPONSE</code> (default) - Invoke synchronously. This corresponds to the
     *         <code>RequestResponse</code> option in the <code>InvocationType</code> parameter for the Lambda <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax">Invoke</a>
     *         API.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FIRE_AND_FORGET</code> - Invoke asynchronously. This corresponds to the <code>Event</code> option
     *         in the <code>InvocationType</code> parameter for the Lambda <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax">Invoke</a>
     *         API.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-invocation">Invocation
     *         types</a> in the <i>Amazon EventBridge User Guide</i>.
     * @see PipeTargetInvocationType
     */
    public final PipeTargetInvocationType invocationType() {
        return PipeTargetInvocationType.fromValue(invocationType);
    }

    /**
     * <p>
     * Specify whether to invoke the function synchronously or asynchronously.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REQUEST_RESPONSE</code> (default) - Invoke synchronously. This corresponds to the
     * <code>RequestResponse</code> option in the <code>InvocationType</code> parameter for the Lambda <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax">Invoke</a> API.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FIRE_AND_FORGET</code> - Invoke asynchronously. This corresponds to the <code>Event</code> option in the
     * <code>InvocationType</code> parameter for the Lambda <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax">Invoke</a> API.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-invocation">Invocation
     * types</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invocationType}
     * will return {@link PipeTargetInvocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #invocationTypeAsString}.
     * </p>
     * 
     * @return Specify whether to invoke the function synchronously or asynchronously.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REQUEST_RESPONSE</code> (default) - Invoke synchronously. This corresponds to the
     *         <code>RequestResponse</code> option in the <code>InvocationType</code> parameter for the Lambda <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax">Invoke</a>
     *         API.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FIRE_AND_FORGET</code> - Invoke asynchronously. This corresponds to the <code>Event</code> option
     *         in the <code>InvocationType</code> parameter for the Lambda <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax">Invoke</a>
     *         API.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-invocation">Invocation
     *         types</a> in the <i>Amazon EventBridge User Guide</i>.
     * @see PipeTargetInvocationType
     */
    public final String invocationTypeAsString() {
        return invocationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invocationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeTargetLambdaFunctionParameters)) {
            return false;
        }
        PipeTargetLambdaFunctionParameters other = (PipeTargetLambdaFunctionParameters) obj;
        return Objects.equals(invocationTypeAsString(), other.invocationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipeTargetLambdaFunctionParameters").add("InvocationType", invocationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvocationType":
            return Optional.ofNullable(clazz.cast(invocationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipeTargetLambdaFunctionParameters, T> g) {
        return obj -> g.apply((PipeTargetLambdaFunctionParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipeTargetLambdaFunctionParameters> {
        /**
         * <p>
         * Specify whether to invoke the function synchronously or asynchronously.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REQUEST_RESPONSE</code> (default) - Invoke synchronously. This corresponds to the
         * <code>RequestResponse</code> option in the <code>InvocationType</code> parameter for the Lambda <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax">Invoke</a> API.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FIRE_AND_FORGET</code> - Invoke asynchronously. This corresponds to the <code>Event</code> option in
         * the <code>InvocationType</code> parameter for the Lambda <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax">Invoke</a> API.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-invocation">Invocation
         * types</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * 
         * @param invocationType
         *        Specify whether to invoke the function synchronously or asynchronously.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REQUEST_RESPONSE</code> (default) - Invoke synchronously. This corresponds to the
         *        <code>RequestResponse</code> option in the <code>InvocationType</code> parameter for the Lambda <a
         *        href
         *        ="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax">Invoke</a>
         *        API.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FIRE_AND_FORGET</code> - Invoke asynchronously. This corresponds to the <code>Event</code>
         *        option in the <code>InvocationType</code> parameter for the Lambda <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax"
         *        >Invoke</a> API.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-invocation"
         *        >Invocation types</a> in the <i>Amazon EventBridge User Guide</i>.
         * @see PipeTargetInvocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipeTargetInvocationType
         */
        Builder invocationType(String invocationType);

        /**
         * <p>
         * Specify whether to invoke the function synchronously or asynchronously.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REQUEST_RESPONSE</code> (default) - Invoke synchronously. This corresponds to the
         * <code>RequestResponse</code> option in the <code>InvocationType</code> parameter for the Lambda <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax">Invoke</a> API.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FIRE_AND_FORGET</code> - Invoke asynchronously. This corresponds to the <code>Event</code> option in
         * the <code>InvocationType</code> parameter for the Lambda <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax">Invoke</a> API.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-invocation">Invocation
         * types</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * 
         * @param invocationType
         *        Specify whether to invoke the function synchronously or asynchronously.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REQUEST_RESPONSE</code> (default) - Invoke synchronously. This corresponds to the
         *        <code>RequestResponse</code> option in the <code>InvocationType</code> parameter for the Lambda <a
         *        href
         *        ="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax">Invoke</a>
         *        API.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FIRE_AND_FORGET</code> - Invoke asynchronously. This corresponds to the <code>Event</code>
         *        option in the <code>InvocationType</code> parameter for the Lambda <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax"
         *        >Invoke</a> API.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-invocation"
         *        >Invocation types</a> in the <i>Amazon EventBridge User Guide</i>.
         * @see PipeTargetInvocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipeTargetInvocationType
         */
        Builder invocationType(PipeTargetInvocationType invocationType);
    }

    static final class BuilderImpl implements Builder {
        private String invocationType;

        private BuilderImpl() {
        }

        private BuilderImpl(PipeTargetLambdaFunctionParameters model) {
            invocationType(model.invocationType);
        }

        public final String getInvocationType() {
            return invocationType;
        }

        public final void setInvocationType(String invocationType) {
            this.invocationType = invocationType;
        }

        @Override
        public final Builder invocationType(String invocationType) {
            this.invocationType = invocationType;
            return this;
        }

        @Override
        public final Builder invocationType(PipeTargetInvocationType invocationType) {
            this.invocationType(invocationType == null ? null : invocationType.toString());
            return this;
        }

        @Override
        public PipeTargetLambdaFunctionParameters build() {
            return new PipeTargetLambdaFunctionParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
