/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift
 * Data API BatchExecuteStatement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipeTargetRedshiftDataParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<PipeTargetRedshiftDataParameters.Builder, PipeTargetRedshiftDataParameters> {
    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(PipeTargetRedshiftDataParameters::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> DB_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DbUser")
            .getter(getter(PipeTargetRedshiftDataParameters::dbUser)).setter(setter(Builder::dbUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()).build();

    private static final SdkField<String> SECRET_MANAGER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretManagerArn").getter(getter(PipeTargetRedshiftDataParameters::secretManagerArn))
            .setter(setter(Builder::secretManagerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretManagerArn").build()).build();

    private static final SdkField<List<String>> SQLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Sqls")
            .getter(getter(PipeTargetRedshiftDataParameters::sqls))
            .setter(setter(Builder::sqls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sqls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATEMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatementName").getter(getter(PipeTargetRedshiftDataParameters::statementName))
            .setter(setter(Builder::statementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementName").build()).build();

    private static final SdkField<Boolean> WITH_EVENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("WithEvent").getter(getter(PipeTargetRedshiftDataParameters::withEvent))
            .setter(setter(Builder::withEvent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WithEvent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_FIELD, DB_USER_FIELD,
            SECRET_MANAGER_ARN_FIELD, SQLS_FIELD, STATEMENT_NAME_FIELD, WITH_EVENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String database;

    private final String dbUser;

    private final String secretManagerArn;

    private final List<String> sqls;

    private final String statementName;

    private final Boolean withEvent;

    private PipeTargetRedshiftDataParameters(BuilderImpl builder) {
        this.database = builder.database;
        this.dbUser = builder.dbUser;
        this.secretManagerArn = builder.secretManagerArn;
        this.sqls = builder.sqls;
        this.statementName = builder.statementName;
        this.withEvent = builder.withEvent;
    }

    /**
     * <p>
     * The name of the database. Required when authenticating using temporary credentials.
     * </p>
     * 
     * @return The name of the database. Required when authenticating using temporary credentials.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * The database user name. Required when authenticating using temporary credentials.
     * </p>
     * 
     * @return The database user name. Required when authenticating using temporary credentials.
     */
    public final String dbUser() {
        return dbUser;
    }

    /**
     * <p>
     * The name or ARN of the secret that enables access to the database. Required when authenticating using Secrets
     * Manager.
     * </p>
     * 
     * @return The name or ARN of the secret that enables access to the database. Required when authenticating using
     *         Secrets Manager.
     */
    public final String secretManagerArn() {
        return secretManagerArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sqls property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSqls() {
        return sqls != null && !(sqls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The SQL statement text to run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSqls} method.
     * </p>
     * 
     * @return The SQL statement text to run.
     */
    public final List<String> sqls() {
        return sqls;
    }

    /**
     * <p>
     * The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
     * </p>
     * 
     * @return The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
     */
    public final String statementName() {
        return statementName;
    }

    /**
     * <p>
     * Indicates whether to send an event back to EventBridge after the SQL statement runs.
     * </p>
     * 
     * @return Indicates whether to send an event back to EventBridge after the SQL statement runs.
     */
    public final Boolean withEvent() {
        return withEvent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(secretManagerArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSqls() ? sqls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statementName());
        hashCode = 31 * hashCode + Objects.hashCode(withEvent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeTargetRedshiftDataParameters)) {
            return false;
        }
        PipeTargetRedshiftDataParameters other = (PipeTargetRedshiftDataParameters) obj;
        return Objects.equals(database(), other.database()) && Objects.equals(dbUser(), other.dbUser())
                && Objects.equals(secretManagerArn(), other.secretManagerArn()) && hasSqls() == other.hasSqls()
                && Objects.equals(sqls(), other.sqls()) && Objects.equals(statementName(), other.statementName())
                && Objects.equals(withEvent(), other.withEvent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipeTargetRedshiftDataParameters")
                .add("Database", database() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DbUser", dbUser() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SecretManagerArn", secretManagerArn())
                .add("Sqls", sqls() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StatementName", statementName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WithEvent", withEvent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "DbUser":
            return Optional.ofNullable(clazz.cast(dbUser()));
        case "SecretManagerArn":
            return Optional.ofNullable(clazz.cast(secretManagerArn()));
        case "Sqls":
            return Optional.ofNullable(clazz.cast(sqls()));
        case "StatementName":
            return Optional.ofNullable(clazz.cast(statementName()));
        case "WithEvent":
            return Optional.ofNullable(clazz.cast(withEvent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipeTargetRedshiftDataParameters, T> g) {
        return obj -> g.apply((PipeTargetRedshiftDataParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipeTargetRedshiftDataParameters> {
        /**
         * <p>
         * The name of the database. Required when authenticating using temporary credentials.
         * </p>
         * 
         * @param database
         *        The name of the database. Required when authenticating using temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The database user name. Required when authenticating using temporary credentials.
         * </p>
         * 
         * @param dbUser
         *        The database user name. Required when authenticating using temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbUser(String dbUser);

        /**
         * <p>
         * The name or ARN of the secret that enables access to the database. Required when authenticating using Secrets
         * Manager.
         * </p>
         * 
         * @param secretManagerArn
         *        The name or ARN of the secret that enables access to the database. Required when authenticating using
         *        Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretManagerArn(String secretManagerArn);

        /**
         * <p>
         * The SQL statement text to run.
         * </p>
         * 
         * @param sqls
         *        The SQL statement text to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqls(Collection<String> sqls);

        /**
         * <p>
         * The SQL statement text to run.
         * </p>
         * 
         * @param sqls
         *        The SQL statement text to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqls(String... sqls);

        /**
         * <p>
         * The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
         * </p>
         * 
         * @param statementName
         *        The name of the SQL statement. You can name the SQL statement when you create it to identify the
         *        query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementName(String statementName);

        /**
         * <p>
         * Indicates whether to send an event back to EventBridge after the SQL statement runs.
         * </p>
         * 
         * @param withEvent
         *        Indicates whether to send an event back to EventBridge after the SQL statement runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder withEvent(Boolean withEvent);
    }

    static final class BuilderImpl implements Builder {
        private String database;

        private String dbUser;

        private String secretManagerArn;

        private List<String> sqls = DefaultSdkAutoConstructList.getInstance();

        private String statementName;

        private Boolean withEvent;

        private BuilderImpl() {
        }

        private BuilderImpl(PipeTargetRedshiftDataParameters model) {
            database(model.database);
            dbUser(model.dbUser);
            secretManagerArn(model.secretManagerArn);
            sqls(model.sqls);
            statementName(model.statementName);
            withEvent(model.withEvent);
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getDbUser() {
            return dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final String getSecretManagerArn() {
            return secretManagerArn;
        }

        public final void setSecretManagerArn(String secretManagerArn) {
            this.secretManagerArn = secretManagerArn;
        }

        @Override
        public final Builder secretManagerArn(String secretManagerArn) {
            this.secretManagerArn = secretManagerArn;
            return this;
        }

        public final Collection<String> getSqls() {
            if (sqls instanceof SdkAutoConstructList) {
                return null;
            }
            return sqls;
        }

        public final void setSqls(Collection<String> sqls) {
            this.sqls = SqlsCopier.copy(sqls);
        }

        @Override
        public final Builder sqls(Collection<String> sqls) {
            this.sqls = SqlsCopier.copy(sqls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqls(String... sqls) {
            sqls(Arrays.asList(sqls));
            return this;
        }

        public final String getStatementName() {
            return statementName;
        }

        public final void setStatementName(String statementName) {
            this.statementName = statementName;
        }

        @Override
        public final Builder statementName(String statementName) {
            this.statementName = statementName;
            return this;
        }

        public final Boolean getWithEvent() {
            return withEvent;
        }

        public final void setWithEvent(Boolean withEvent) {
            this.withEvent = withEvent;
        }

        @Override
        public final Builder withEvent(Boolean withEvent) {
            this.withEvent = withEvent;
            return this;
        }

        @Override
        public PipeTargetRedshiftDataParameters build() {
            return new PipeTargetRedshiftDataParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
