/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEnvironmentAccountConnectionRequest extends ProtonRequest implements
        ToCopyableBuilder<CreateEnvironmentAccountConnectionRequest.Builder, CreateEnvironmentAccountConnectionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateEnvironmentAccountConnectionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CODEBUILD_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("codebuildRoleArn").getter(getter(CreateEnvironmentAccountConnectionRequest::codebuildRoleArn))
            .setter(setter(Builder::codebuildRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codebuildRoleArn").build()).build();

    private static final SdkField<String> COMPONENT_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentRoleArn").getter(getter(CreateEnvironmentAccountConnectionRequest::componentRoleArn))
            .setter(setter(Builder::componentRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentRoleArn").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentName").getter(getter(CreateEnvironmentAccountConnectionRequest::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()).build();

    private static final SdkField<String> MANAGEMENT_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("managementAccountId").getter(getter(CreateEnvironmentAccountConnectionRequest::managementAccountId))
            .setter(setter(Builder::managementAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managementAccountId").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateEnvironmentAccountConnectionRequest::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateEnvironmentAccountConnectionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            CODEBUILD_ROLE_ARN_FIELD, COMPONENT_ROLE_ARN_FIELD, ENVIRONMENT_NAME_FIELD, MANAGEMENT_ACCOUNT_ID_FIELD,
            ROLE_ARN_FIELD, TAGS_FIELD));

    private final String clientToken;

    private final String codebuildRoleArn;

    private final String componentRoleArn;

    private final String environmentName;

    private final String managementAccountId;

    private final String roleArn;

    private final List<Tag> tags;

    private CreateEnvironmentAccountConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.codebuildRoleArn = builder.codebuildRoleArn;
        this.componentRoleArn = builder.componentRoleArn;
        this.environmentName = builder.environmentName;
        this.managementAccountId = builder.managementAccountId;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * When included, if two identical requests are made with the same client token, Proton returns the environment
     * account connection that the first request created.
     * </p>
     * 
     * @return When included, if two identical requests are made with the same client token, Proton returns the
     *         environment account connection that the first request created.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM service role in the environment account. Proton uses this role to
     * provision infrastructure resources using CodeBuild-based provisioning in the associated environment account.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM service role in the environment account. Proton uses this role
     *         to provision infrastructure resources using CodeBuild-based provisioning in the associated environment
     *         account.
     */
    public final String codebuildRoleArn() {
        return codebuildRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM service role in the environment account. Proton uses this role to
     * provision directly defined components in the associated environment account. It determines the scope of
     * infrastructure that a component can provision in the account.
     * </p>
     * <p>
     * You must specify <code>componentRoleArn</code> to allow directly defined components to be associated with any
     * environments running in this account.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM service role in the environment account. Proton uses this role
     *         to provision directly defined components in the associated environment account. It determines the scope
     *         of infrastructure that a component can provision in the account.</p>
     *         <p>
     *         You must specify <code>componentRoleArn</code> to allow directly defined components to be associated with
     *         any environments running in this account.
     *         </p>
     *         <p>
     *         For more information about components, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in
     *         the <i>Proton User Guide</i>.
     */
    public final String componentRoleArn() {
        return componentRoleArn;
    }

    /**
     * <p>
     * The name of the Proton environment that's created in the associated management account.
     * </p>
     * 
     * @return The name of the Proton environment that's created in the associated management account.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The ID of the management account that accepts or rejects the environment account connection. You create and
     * manage the Proton environment in this account. If the management account accepts the environment account
     * connection, Proton can use the associated IAM role to provision environment infrastructure resources in the
     * associated environment account.
     * </p>
     * 
     * @return The ID of the management account that accepts or rejects the environment account connection. You create
     *         and manage the Proton environment in this account. If the management account accepts the environment
     *         account connection, Proton can use the associated IAM role to provision environment infrastructure
     *         resources in the associated environment account.
     */
    public final String managementAccountId() {
        return managementAccountId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM service role in the environment account. Proton uses this role to
     * provision infrastructure resources using Amazon Web Services-managed provisioning and CloudFormation in the
     * associated environment account.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM service role in the environment account. Proton uses this role
     *         to provision infrastructure resources using Amazon Web Services-managed provisioning and CloudFormation
     *         in the associated environment account.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional list of metadata items that you can associate with the Proton environment account connection. A tag
     * is a key-value pair.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
     * resources and tagging</a> in the <i>Proton User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional list of metadata items that you can associate with the Proton environment account connection.
     *         A tag is a key-value pair.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and
     *         tagging</a> in the <i>Proton User Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(codebuildRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(componentRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(managementAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentAccountConnectionRequest)) {
            return false;
        }
        CreateEnvironmentAccountConnectionRequest other = (CreateEnvironmentAccountConnectionRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(codebuildRoleArn(), other.codebuildRoleArn())
                && Objects.equals(componentRoleArn(), other.componentRoleArn())
                && Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(managementAccountId(), other.managementAccountId())
                && Objects.equals(roleArn(), other.roleArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEnvironmentAccountConnectionRequest").add("ClientToken", clientToken())
                .add("CodebuildRoleArn", codebuildRoleArn()).add("ComponentRoleArn", componentRoleArn())
                .add("EnvironmentName", environmentName()).add("ManagementAccountId", managementAccountId())
                .add("RoleArn", roleArn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "codebuildRoleArn":
            return Optional.ofNullable(clazz.cast(codebuildRoleArn()));
        case "componentRoleArn":
            return Optional.ofNullable(clazz.cast(componentRoleArn()));
        case "environmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "managementAccountId":
            return Optional.ofNullable(clazz.cast(managementAccountId()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentAccountConnectionRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentAccountConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateEnvironmentAccountConnectionRequest> {
        /**
         * <p>
         * When included, if two identical requests are made with the same client token, Proton returns the environment
         * account connection that the first request created.
         * </p>
         * 
         * @param clientToken
         *        When included, if two identical requests are made with the same client token, Proton returns the
         *        environment account connection that the first request created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM service role in the environment account. Proton uses this role to
         * provision infrastructure resources using CodeBuild-based provisioning in the associated environment account.
         * </p>
         * 
         * @param codebuildRoleArn
         *        The Amazon Resource Name (ARN) of an IAM service role in the environment account. Proton uses this
         *        role to provision infrastructure resources using CodeBuild-based provisioning in the associated
         *        environment account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codebuildRoleArn(String codebuildRoleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM service role in the environment account. Proton uses this role to
         * provision directly defined components in the associated environment account. It determines the scope of
         * infrastructure that a component can provision in the account.
         * </p>
         * <p>
         * You must specify <code>componentRoleArn</code> to allow directly defined components to be associated with any
         * environments running in this account.
         * </p>
         * <p>
         * For more information about components, see <a
         * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
         * <i>Proton User Guide</i>.
         * </p>
         * 
         * @param componentRoleArn
         *        The Amazon Resource Name (ARN) of an IAM service role in the environment account. Proton uses this
         *        role to provision directly defined components in the associated environment account. It determines the
         *        scope of infrastructure that a component can provision in the account.</p>
         *        <p>
         *        You must specify <code>componentRoleArn</code> to allow directly defined components to be associated
         *        with any environments running in this account.
         *        </p>
         *        <p>
         *        For more information about components, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in
         *        the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentRoleArn(String componentRoleArn);

        /**
         * <p>
         * The name of the Proton environment that's created in the associated management account.
         * </p>
         * 
         * @param environmentName
         *        The name of the Proton environment that's created in the associated management account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The ID of the management account that accepts or rejects the environment account connection. You create and
         * manage the Proton environment in this account. If the management account accepts the environment account
         * connection, Proton can use the associated IAM role to provision environment infrastructure resources in the
         * associated environment account.
         * </p>
         * 
         * @param managementAccountId
         *        The ID of the management account that accepts or rejects the environment account connection. You
         *        create and manage the Proton environment in this account. If the management account accepts the
         *        environment account connection, Proton can use the associated IAM role to provision environment
         *        infrastructure resources in the associated environment account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managementAccountId(String managementAccountId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM service role in the environment account. Proton uses this role to
         * provision infrastructure resources using Amazon Web Services-managed provisioning and CloudFormation in the
         * associated environment account.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM service role in the environment account. Proton uses this
         *        role to provision infrastructure resources using Amazon Web Services-managed provisioning and
         *        CloudFormation in the associated environment account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * An optional list of metadata items that you can associate with the Proton environment account connection. A
         * tag is a key-value pair.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
         * resources and tagging</a> in the <i>Proton User Guide</i>.
         * </p>
         * 
         * @param tags
         *        An optional list of metadata items that you can associate with the Proton environment account
         *        connection. A tag is a key-value pair.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and
         *        tagging</a> in the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An optional list of metadata items that you can associate with the Proton environment account connection. A
         * tag is a key-value pair.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
         * resources and tagging</a> in the <i>Proton User Guide</i>.
         * </p>
         * 
         * @param tags
         *        An optional list of metadata items that you can associate with the Proton environment account
         *        connection. A tag is a key-value pair.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton resources and
         *        tagging</a> in the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An optional list of metadata items that you can associate with the Proton environment account connection. A
         * tag is a key-value pair.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton
         * resources and tagging</a> in the <i>Proton User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.proton.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.proton.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.proton.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.proton.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String codebuildRoleArn;

        private String componentRoleArn;

        private String environmentName;

        private String managementAccountId;

        private String roleArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentAccountConnectionRequest model) {
            super(model);
            clientToken(model.clientToken);
            codebuildRoleArn(model.codebuildRoleArn);
            componentRoleArn(model.componentRoleArn);
            environmentName(model.environmentName);
            managementAccountId(model.managementAccountId);
            roleArn(model.roleArn);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getCodebuildRoleArn() {
            return codebuildRoleArn;
        }

        public final void setCodebuildRoleArn(String codebuildRoleArn) {
            this.codebuildRoleArn = codebuildRoleArn;
        }

        @Override
        public final Builder codebuildRoleArn(String codebuildRoleArn) {
            this.codebuildRoleArn = codebuildRoleArn;
            return this;
        }

        public final String getComponentRoleArn() {
            return componentRoleArn;
        }

        public final void setComponentRoleArn(String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
        }

        @Override
        public final Builder componentRoleArn(String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getManagementAccountId() {
            return managementAccountId;
        }

        public final void setManagementAccountId(String managementAccountId) {
            this.managementAccountId = managementAccountId;
        }

        @Override
        public final Builder managementAccountId(String managementAccountId) {
            this.managementAccountId = managementAccountId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentAccountConnectionRequest build() {
            return new CreateEnvironmentAccountConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
