/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEnvironmentAccountConnectionRequest extends ProtonRequest implements
        ToCopyableBuilder<UpdateEnvironmentAccountConnectionRequest.Builder, UpdateEnvironmentAccountConnectionRequest> {
    private static final SdkField<String> CODEBUILD_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("codebuildRoleArn").getter(getter(UpdateEnvironmentAccountConnectionRequest::codebuildRoleArn))
            .setter(setter(Builder::codebuildRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codebuildRoleArn").build()).build();

    private static final SdkField<String> COMPONENT_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentRoleArn").getter(getter(UpdateEnvironmentAccountConnectionRequest::componentRoleArn))
            .setter(setter(Builder::componentRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentRoleArn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateEnvironmentAccountConnectionRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateEnvironmentAccountConnectionRequest::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODEBUILD_ROLE_ARN_FIELD,
            COMPONENT_ROLE_ARN_FIELD, ID_FIELD, ROLE_ARN_FIELD));

    private final String codebuildRoleArn;

    private final String componentRoleArn;

    private final String id;

    private final String roleArn;

    private UpdateEnvironmentAccountConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.codebuildRoleArn = builder.codebuildRoleArn;
        this.componentRoleArn = builder.componentRoleArn;
        this.id = builder.id;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM service role in the environment account. Proton uses this role to
     * provision infrastructure resources using CodeBuild-based provisioning in the associated environment account.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM service role in the environment account. Proton uses this role
     *         to provision infrastructure resources using CodeBuild-based provisioning in the associated environment
     *         account.
     */
    public final String codebuildRoleArn() {
        return codebuildRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined
     * components in the associated environment account. It determines the scope of infrastructure that a component can
     * provision in the account.
     * </p>
     * <p>
     * The environment account connection must have a <code>componentRoleArn</code> to allow directly defined components
     * to be associated with any environments running in the account.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly
     *         defined components in the associated environment account. It determines the scope of infrastructure that
     *         a component can provision in the account.</p>
     *         <p>
     *         The environment account connection must have a <code>componentRoleArn</code> to allow directly defined
     *         components to be associated with any environments running in the account.
     *         </p>
     *         <p>
     *         For more information about components, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in
     *         the <i>Proton User Guide</i>.
     */
    public final String componentRoleArn() {
        return componentRoleArn;
    }

    /**
     * <p>
     * The ID of the environment account connection to update.
     * </p>
     * 
     * @return The ID of the environment account connection to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM service role in the environment account. Proton uses this role to
     * provision infrastructure resources using Amazon Web Services-managed provisioning and CloudFormation in the
     * associated environment account.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM service role in the environment account. Proton uses this role
     *         to provision infrastructure resources using Amazon Web Services-managed provisioning and CloudFormation
     *         in the associated environment account.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codebuildRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(componentRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentAccountConnectionRequest)) {
            return false;
        }
        UpdateEnvironmentAccountConnectionRequest other = (UpdateEnvironmentAccountConnectionRequest) obj;
        return Objects.equals(codebuildRoleArn(), other.codebuildRoleArn())
                && Objects.equals(componentRoleArn(), other.componentRoleArn()) && Objects.equals(id(), other.id())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEnvironmentAccountConnectionRequest").add("CodebuildRoleArn", codebuildRoleArn())
                .add("ComponentRoleArn", componentRoleArn()).add("Id", id()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "codebuildRoleArn":
            return Optional.ofNullable(clazz.cast(codebuildRoleArn()));
        case "componentRoleArn":
            return Optional.ofNullable(clazz.cast(componentRoleArn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnvironmentAccountConnectionRequest, T> g) {
        return obj -> g.apply((UpdateEnvironmentAccountConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateEnvironmentAccountConnectionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM service role in the environment account. Proton uses this role to
         * provision infrastructure resources using CodeBuild-based provisioning in the associated environment account.
         * </p>
         * 
         * @param codebuildRoleArn
         *        The Amazon Resource Name (ARN) of an IAM service role in the environment account. Proton uses this
         *        role to provision infrastructure resources using CodeBuild-based provisioning in the associated
         *        environment account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codebuildRoleArn(String codebuildRoleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined
         * components in the associated environment account. It determines the scope of infrastructure that a component
         * can provision in the account.
         * </p>
         * <p>
         * The environment account connection must have a <code>componentRoleArn</code> to allow directly defined
         * components to be associated with any environments running in the account.
         * </p>
         * <p>
         * For more information about components, see <a
         * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
         * <i>Proton User Guide</i>.
         * </p>
         * 
         * @param componentRoleArn
         *        The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly
         *        defined components in the associated environment account. It determines the scope of infrastructure
         *        that a component can provision in the account.</p>
         *        <p>
         *        The environment account connection must have a <code>componentRoleArn</code> to allow directly defined
         *        components to be associated with any environments running in the account.
         *        </p>
         *        <p>
         *        For more information about components, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in
         *        the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentRoleArn(String componentRoleArn);

        /**
         * <p>
         * The ID of the environment account connection to update.
         * </p>
         * 
         * @param id
         *        The ID of the environment account connection to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM service role in the environment account. Proton uses this role to
         * provision infrastructure resources using Amazon Web Services-managed provisioning and CloudFormation in the
         * associated environment account.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM service role in the environment account. Proton uses this
         *        role to provision infrastructure resources using Amazon Web Services-managed provisioning and
         *        CloudFormation in the associated environment account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private String codebuildRoleArn;

        private String componentRoleArn;

        private String id;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentAccountConnectionRequest model) {
            super(model);
            codebuildRoleArn(model.codebuildRoleArn);
            componentRoleArn(model.componentRoleArn);
            id(model.id);
            roleArn(model.roleArn);
        }

        public final String getCodebuildRoleArn() {
            return codebuildRoleArn;
        }

        public final void setCodebuildRoleArn(String codebuildRoleArn) {
            this.codebuildRoleArn = codebuildRoleArn;
        }

        @Override
        public final Builder codebuildRoleArn(String codebuildRoleArn) {
            this.codebuildRoleArn = codebuildRoleArn;
            return this;
        }

        public final String getComponentRoleArn() {
            return componentRoleArn;
        }

        public final void setComponentRoleArn(String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
        }

        @Override
        public final Builder componentRoleArn(String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEnvironmentAccountConnectionRequest build() {
            return new UpdateEnvironmentAccountConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
