/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceInstancesRequest extends ProtonRequest implements
        ToCopyableBuilder<ListServiceInstancesRequest.Builder, ListServiceInstancesRequest> {
    private static final SdkField<List<ListServiceInstancesFilter>> FILTERS_FIELD = SdkField
            .<List<ListServiceInstancesFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListServiceInstancesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListServiceInstancesFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListServiceInstancesFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListServiceInstancesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListServiceInstancesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(ListServiceInstancesRequest::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(ListServiceInstancesRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListServiceInstancesRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SERVICE_NAME_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));

    private final List<ListServiceInstancesFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private final String serviceName;

    private final String sortBy;

    private final String sortOrder;

    private ListServiceInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.serviceName = builder.serviceName;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of filtering criteria that scope down the result list. By default, all service instances in the Amazon
     * Web Services account are returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return An array of filtering criteria that scope down the result list. By default, all service instances in the
     *         Amazon Web Services account are returned.
     */
    public final List<ListServiceInstancesFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of service instances to list.
     * </p>
     * 
     * @return The maximum number of service instances to list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token that indicates the location of the next service in the array of service instances, after the list of
     * service instances that was previously requested.
     * </p>
     * 
     * @return A token that indicates the location of the next service in the array of service instances, after the list
     *         of service instances that was previously requested.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The name of the service that the service instance belongs to.
     * </p>
     * 
     * @return The name of the service that the service instance belongs to.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The field that the result list is sorted by.
     * </p>
     * <p>
     * When you choose to sort by <code>serviceName</code>, service instances within each service are sorted by service
     * instance name.
     * </p>
     * <p>
     * Default: <code>serviceName</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ListServiceInstancesSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The field that the result list is sorted by.</p>
     *         <p>
     *         When you choose to sort by <code>serviceName</code>, service instances within each service are sorted by
     *         service instance name.
     *         </p>
     *         <p>
     *         Default: <code>serviceName</code>
     * @see ListServiceInstancesSortBy
     */
    public final ListServiceInstancesSortBy sortBy() {
        return ListServiceInstancesSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The field that the result list is sorted by.
     * </p>
     * <p>
     * When you choose to sort by <code>serviceName</code>, service instances within each service are sorted by service
     * instance name.
     * </p>
     * <p>
     * Default: <code>serviceName</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ListServiceInstancesSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The field that the result list is sorted by.</p>
     *         <p>
     *         When you choose to sort by <code>serviceName</code>, service instances within each service are sorted by
     *         service instance name.
     *         </p>
     *         <p>
     *         Default: <code>serviceName</code>
     * @see ListServiceInstancesSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * Result list sort order.
     * </p>
     * <p>
     * Default: <code>ASCENDING</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Result list sort order.</p>
     *         <p>
     *         Default: <code>ASCENDING</code>
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Result list sort order.
     * </p>
     * <p>
     * Default: <code>ASCENDING</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Result list sort order.</p>
     *         <p>
     *         Default: <code>ASCENDING</code>
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceInstancesRequest)) {
            return false;
        }
        ListServiceInstancesRequest other = (ListServiceInstancesRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(serviceName(), other.serviceName()) && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServiceInstancesRequest").add("Filters", hasFilters() ? filters() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("ServiceName", serviceName())
                .add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServiceInstancesRequest, T> g) {
        return obj -> g.apply((ListServiceInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListServiceInstancesRequest> {
        /**
         * <p>
         * An array of filtering criteria that scope down the result list. By default, all service instances in the
         * Amazon Web Services account are returned.
         * </p>
         * 
         * @param filters
         *        An array of filtering criteria that scope down the result list. By default, all service instances in
         *        the Amazon Web Services account are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ListServiceInstancesFilter> filters);

        /**
         * <p>
         * An array of filtering criteria that scope down the result list. By default, all service instances in the
         * Amazon Web Services account are returned.
         * </p>
         * 
         * @param filters
         *        An array of filtering criteria that scope down the result list. By default, all service instances in
         *        the Amazon Web Services account are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ListServiceInstancesFilter... filters);

        /**
         * <p>
         * An array of filtering criteria that scope down the result list. By default, all service instances in the
         * Amazon Web Services account are returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.proton.model.ListServiceInstancesFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.proton.model.ListServiceInstancesFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.proton.model.ListServiceInstancesFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<ListServiceInstancesFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.proton.model.ListServiceInstancesFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<ListServiceInstancesFilter>)
         */
        Builder filters(Consumer<ListServiceInstancesFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of service instances to list.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of service instances to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token that indicates the location of the next service in the array of service instances, after the list of
         * service instances that was previously requested.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates the location of the next service in the array of service instances, after the
         *        list of service instances that was previously requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The name of the service that the service instance belongs to.
         * </p>
         * 
         * @param serviceName
         *        The name of the service that the service instance belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The field that the result list is sorted by.
         * </p>
         * <p>
         * When you choose to sort by <code>serviceName</code>, service instances within each service are sorted by
         * service instance name.
         * </p>
         * <p>
         * Default: <code>serviceName</code>
         * </p>
         * 
         * @param sortBy
         *        The field that the result list is sorted by.</p>
         *        <p>
         *        When you choose to sort by <code>serviceName</code>, service instances within each service are sorted
         *        by service instance name.
         *        </p>
         *        <p>
         *        Default: <code>serviceName</code>
         * @see ListServiceInstancesSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListServiceInstancesSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The field that the result list is sorted by.
         * </p>
         * <p>
         * When you choose to sort by <code>serviceName</code>, service instances within each service are sorted by
         * service instance name.
         * </p>
         * <p>
         * Default: <code>serviceName</code>
         * </p>
         * 
         * @param sortBy
         *        The field that the result list is sorted by.</p>
         *        <p>
         *        When you choose to sort by <code>serviceName</code>, service instances within each service are sorted
         *        by service instance name.
         *        </p>
         *        <p>
         *        Default: <code>serviceName</code>
         * @see ListServiceInstancesSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListServiceInstancesSortBy
         */
        Builder sortBy(ListServiceInstancesSortBy sortBy);

        /**
         * <p>
         * Result list sort order.
         * </p>
         * <p>
         * Default: <code>ASCENDING</code>
         * </p>
         * 
         * @param sortOrder
         *        Result list sort order.</p>
         *        <p>
         *        Default: <code>ASCENDING</code>
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Result list sort order.
         * </p>
         * <p>
         * Default: <code>ASCENDING</code>
         * </p>
         * 
         * @param sortOrder
         *        Result list sort order.</p>
         *        <p>
         *        Default: <code>ASCENDING</code>
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private List<ListServiceInstancesFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private String serviceName;

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceInstancesRequest model) {
            super(model);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            serviceName(model.serviceName);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final List<ListServiceInstancesFilter.Builder> getFilters() {
            List<ListServiceInstancesFilter.Builder> result = ListServiceInstancesFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<ListServiceInstancesFilter.BuilderImpl> filters) {
            this.filters = ListServiceInstancesFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<ListServiceInstancesFilter> filters) {
            this.filters = ListServiceInstancesFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ListServiceInstancesFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ListServiceInstancesFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> ListServiceInstancesFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ListServiceInstancesSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServiceInstancesRequest build() {
            return new ListServiceInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
