/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteDocumentRequest extends QBusinessRequest implements
        ToCopyableBuilder<BatchDeleteDocumentRequest.Builder, BatchDeleteDocumentRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(BatchDeleteDocumentRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> DATA_SOURCE_SYNC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceSyncId").getter(getter(BatchDeleteDocumentRequest::dataSourceSyncId))
            .setter(setter(Builder::dataSourceSyncId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceSyncId").build()).build();

    private static final SdkField<List<DeleteDocument>> DOCUMENTS_FIELD = SdkField
            .<List<DeleteDocument>> builder(MarshallingType.LIST)
            .memberName("documents")
            .getter(getter(BatchDeleteDocumentRequest::documents))
            .setter(setter(Builder::documents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeleteDocument> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeleteDocument::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexId").getter(getter(BatchDeleteDocumentRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("indexId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            DATA_SOURCE_SYNC_ID_FIELD, DOCUMENTS_FIELD, INDEX_ID_FIELD));

    private final String applicationId;

    private final String dataSourceSyncId;

    private final List<DeleteDocument> documents;

    private final String indexId;

    private BatchDeleteDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.dataSourceSyncId = builder.dataSourceSyncId;
        this.documents = builder.documents;
        this.indexId = builder.indexId;
    }

    /**
     * <p>
     * The identifier of the Amazon Q application.
     * </p>
     * 
     * @return The identifier of the Amazon Q application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The identifier of the data source sync during which the documents were deleted.
     * </p>
     * 
     * @return The identifier of the data source sync during which the documents were deleted.
     */
    public final String dataSourceSyncId() {
        return dataSourceSyncId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Documents property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDocuments() {
        return documents != null && !(documents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Documents deleted from the Amazon Q index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocuments} method.
     * </p>
     * 
     * @return Documents deleted from the Amazon Q index.
     */
    public final List<DeleteDocument> documents() {
        return documents;
    }

    /**
     * <p>
     * The identifier of the Amazon Q index that contains the documents to delete.
     * </p>
     * 
     * @return The identifier of the Amazon Q index that contains the documents to delete.
     */
    public final String indexId() {
        return indexId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceSyncId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDocuments() ? documents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteDocumentRequest)) {
            return false;
        }
        BatchDeleteDocumentRequest other = (BatchDeleteDocumentRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(dataSourceSyncId(), other.dataSourceSyncId()) && hasDocuments() == other.hasDocuments()
                && Objects.equals(documents(), other.documents()) && Objects.equals(indexId(), other.indexId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteDocumentRequest").add("ApplicationId", applicationId())
                .add("DataSourceSyncId", dataSourceSyncId()).add("Documents", hasDocuments() ? documents() : null)
                .add("IndexId", indexId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "dataSourceSyncId":
            return Optional.ofNullable(clazz.cast(dataSourceSyncId()));
        case "documents":
            return Optional.ofNullable(clazz.cast(documents()));
        case "indexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteDocumentRequest, T> g) {
        return obj -> g.apply((BatchDeleteDocumentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchDeleteDocumentRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q application.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The identifier of the data source sync during which the documents were deleted.
         * </p>
         * 
         * @param dataSourceSyncId
         *        The identifier of the data source sync during which the documents were deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceSyncId(String dataSourceSyncId);

        /**
         * <p>
         * Documents deleted from the Amazon Q index.
         * </p>
         * 
         * @param documents
         *        Documents deleted from the Amazon Q index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documents(Collection<DeleteDocument> documents);

        /**
         * <p>
         * Documents deleted from the Amazon Q index.
         * </p>
         * 
         * @param documents
         *        Documents deleted from the Amazon Q index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documents(DeleteDocument... documents);

        /**
         * <p>
         * Documents deleted from the Amazon Q index.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.DeleteDocument.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qbusiness.model.DeleteDocument#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.DeleteDocument.Builder#build()} is called immediately
         * and its result is passed to {@link #documents(List<DeleteDocument>)}.
         * 
         * @param documents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documents(java.util.Collection<DeleteDocument>)
         */
        Builder documents(Consumer<DeleteDocument.Builder>... documents);

        /**
         * <p>
         * The identifier of the Amazon Q index that contains the documents to delete.
         * </p>
         * 
         * @param indexId
         *        The identifier of the Amazon Q index that contains the documents to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String dataSourceSyncId;

        private List<DeleteDocument> documents = DefaultSdkAutoConstructList.getInstance();

        private String indexId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteDocumentRequest model) {
            super(model);
            applicationId(model.applicationId);
            dataSourceSyncId(model.dataSourceSyncId);
            documents(model.documents);
            indexId(model.indexId);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getDataSourceSyncId() {
            return dataSourceSyncId;
        }

        public final void setDataSourceSyncId(String dataSourceSyncId) {
            this.dataSourceSyncId = dataSourceSyncId;
        }

        @Override
        public final Builder dataSourceSyncId(String dataSourceSyncId) {
            this.dataSourceSyncId = dataSourceSyncId;
            return this;
        }

        public final List<DeleteDocument.Builder> getDocuments() {
            List<DeleteDocument.Builder> result = DeleteDocumentsCopier.copyToBuilder(this.documents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocuments(Collection<DeleteDocument.BuilderImpl> documents) {
            this.documents = DeleteDocumentsCopier.copyFromBuilder(documents);
        }

        @Override
        public final Builder documents(Collection<DeleteDocument> documents) {
            this.documents = DeleteDocumentsCopier.copy(documents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(DeleteDocument... documents) {
            documents(Arrays.asList(documents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(Consumer<DeleteDocument.Builder>... documents) {
            documents(Stream.of(documents).map(c -> DeleteDocument.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteDocumentRequest build() {
            return new BatchDeleteDocumentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
