/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChatSyncResponse extends QBusinessResponse implements
        ToCopyableBuilder<ChatSyncResponse.Builder, ChatSyncResponse> {
    private static final SdkField<ActionReview> ACTION_REVIEW_FIELD = SdkField.<ActionReview> builder(MarshallingType.SDK_POJO)
            .memberName("actionReview").getter(getter(ChatSyncResponse::actionReview)).setter(setter(Builder::actionReview))
            .constructor(ActionReview::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionReview").build()).build();

    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conversationId").getter(getter(ChatSyncResponse::conversationId))
            .setter(setter(Builder::conversationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationId").build()).build();

    private static final SdkField<List<AttachmentOutput>> FAILED_ATTACHMENTS_FIELD = SdkField
            .<List<AttachmentOutput>> builder(MarshallingType.LIST)
            .memberName("failedAttachments")
            .getter(getter(ChatSyncResponse::failedAttachments))
            .setter(setter(Builder::failedAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedAttachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttachmentOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttachmentOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SourceAttribution>> SOURCE_ATTRIBUTIONS_FIELD = SdkField
            .<List<SourceAttribution>> builder(MarshallingType.LIST)
            .memberName("sourceAttributions")
            .getter(getter(ChatSyncResponse::sourceAttributions))
            .setter(setter(Builder::sourceAttributions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAttributions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SourceAttribution> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceAttribution::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SYSTEM_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("systemMessage").getter(getter(ChatSyncResponse::systemMessage)).setter(setter(Builder::systemMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessage").build()).build();

    private static final SdkField<String> SYSTEM_MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("systemMessageId").getter(getter(ChatSyncResponse::systemMessageId))
            .setter(setter(Builder::systemMessageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessageId").build()).build();

    private static final SdkField<String> USER_MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userMessageId").getter(getter(ChatSyncResponse::userMessageId)).setter(setter(Builder::userMessageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userMessageId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_REVIEW_FIELD,
            CONVERSATION_ID_FIELD, FAILED_ATTACHMENTS_FIELD, SOURCE_ATTRIBUTIONS_FIELD, SYSTEM_MESSAGE_FIELD,
            SYSTEM_MESSAGE_ID_FIELD, USER_MESSAGE_ID_FIELD));

    private final ActionReview actionReview;

    private final String conversationId;

    private final List<AttachmentOutput> failedAttachments;

    private final List<SourceAttribution> sourceAttributions;

    private final String systemMessage;

    private final String systemMessageId;

    private final String userMessageId;

    private ChatSyncResponse(BuilderImpl builder) {
        super(builder);
        this.actionReview = builder.actionReview;
        this.conversationId = builder.conversationId;
        this.failedAttachments = builder.failedAttachments;
        this.sourceAttributions = builder.sourceAttributions;
        this.systemMessage = builder.systemMessage;
        this.systemMessageId = builder.systemMessageId;
        this.userMessageId = builder.userMessageId;
    }

    /**
     * <p>
     * A request from Amazon Q to the end user for information Amazon Q needs to successfully complete a requested
     * plugin action.
     * </p>
     * 
     * @return A request from Amazon Q to the end user for information Amazon Q needs to successfully complete a
     *         requested plugin action.
     */
    public final ActionReview actionReview() {
        return actionReview;
    }

    /**
     * <p>
     * The identifier of the Amazon Q conversation.
     * </p>
     * 
     * @return The identifier of the Amazon Q conversation.
     */
    public final String conversationId() {
        return conversationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedAttachments property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedAttachments() {
        return failedAttachments != null && !(failedAttachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of files which failed to upload during chat.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedAttachments} method.
     * </p>
     * 
     * @return A list of files which failed to upload during chat.
     */
    public final List<AttachmentOutput> failedAttachments() {
        return failedAttachments;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceAttributions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceAttributions() {
        return sourceAttributions != null && !(sourceAttributions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The source documents used to generate the conversation response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceAttributions} method.
     * </p>
     * 
     * @return The source documents used to generate the conversation response.
     */
    public final List<SourceAttribution> sourceAttributions() {
        return sourceAttributions;
    }

    /**
     * <p>
     * An AI-generated message in a conversation.
     * </p>
     * 
     * @return An AI-generated message in a conversation.
     */
    public final String systemMessage() {
        return systemMessage;
    }

    /**
     * <p>
     * The identifier of an Amazon Q AI generated message within the conversation.
     * </p>
     * 
     * @return The identifier of an Amazon Q AI generated message within the conversation.
     */
    public final String systemMessageId() {
        return systemMessageId;
    }

    /**
     * <p>
     * The identifier of an Amazon Q end user text input message within the conversation.
     * </p>
     * 
     * @return The identifier of an Amazon Q end user text input message within the conversation.
     */
    public final String userMessageId() {
        return userMessageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionReview());
        hashCode = 31 * hashCode + Objects.hashCode(conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedAttachments() ? failedAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceAttributions() ? sourceAttributions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(systemMessage());
        hashCode = 31 * hashCode + Objects.hashCode(systemMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(userMessageId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatSyncResponse)) {
            return false;
        }
        ChatSyncResponse other = (ChatSyncResponse) obj;
        return Objects.equals(actionReview(), other.actionReview()) && Objects.equals(conversationId(), other.conversationId())
                && hasFailedAttachments() == other.hasFailedAttachments()
                && Objects.equals(failedAttachments(), other.failedAttachments())
                && hasSourceAttributions() == other.hasSourceAttributions()
                && Objects.equals(sourceAttributions(), other.sourceAttributions())
                && Objects.equals(systemMessage(), other.systemMessage())
                && Objects.equals(systemMessageId(), other.systemMessageId())
                && Objects.equals(userMessageId(), other.userMessageId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChatSyncResponse").add("ActionReview", actionReview()).add("ConversationId", conversationId())
                .add("FailedAttachments", hasFailedAttachments() ? failedAttachments() : null)
                .add("SourceAttributions", hasSourceAttributions() ? sourceAttributions() : null)
                .add("SystemMessage", systemMessage()).add("SystemMessageId", systemMessageId())
                .add("UserMessageId", userMessageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionReview":
            return Optional.ofNullable(clazz.cast(actionReview()));
        case "conversationId":
            return Optional.ofNullable(clazz.cast(conversationId()));
        case "failedAttachments":
            return Optional.ofNullable(clazz.cast(failedAttachments()));
        case "sourceAttributions":
            return Optional.ofNullable(clazz.cast(sourceAttributions()));
        case "systemMessage":
            return Optional.ofNullable(clazz.cast(systemMessage()));
        case "systemMessageId":
            return Optional.ofNullable(clazz.cast(systemMessageId()));
        case "userMessageId":
            return Optional.ofNullable(clazz.cast(userMessageId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChatSyncResponse, T> g) {
        return obj -> g.apply((ChatSyncResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, ChatSyncResponse> {
        /**
         * <p>
         * A request from Amazon Q to the end user for information Amazon Q needs to successfully complete a requested
         * plugin action.
         * </p>
         * 
         * @param actionReview
         *        A request from Amazon Q to the end user for information Amazon Q needs to successfully complete a
         *        requested plugin action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionReview(ActionReview actionReview);

        /**
         * <p>
         * A request from Amazon Q to the end user for information Amazon Q needs to successfully complete a requested
         * plugin action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionReview.Builder} avoiding the need
         * to create one manually via {@link ActionReview#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionReview.Builder#build()} is called immediately and its
         * result is passed to {@link #actionReview(ActionReview)}.
         * 
         * @param actionReview
         *        a consumer that will call methods on {@link ActionReview.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionReview(ActionReview)
         */
        default Builder actionReview(Consumer<ActionReview.Builder> actionReview) {
            return actionReview(ActionReview.builder().applyMutation(actionReview).build());
        }

        /**
         * <p>
         * The identifier of the Amazon Q conversation.
         * </p>
         * 
         * @param conversationId
         *        The identifier of the Amazon Q conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationId(String conversationId);

        /**
         * <p>
         * A list of files which failed to upload during chat.
         * </p>
         * 
         * @param failedAttachments
         *        A list of files which failed to upload during chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedAttachments(Collection<AttachmentOutput> failedAttachments);

        /**
         * <p>
         * A list of files which failed to upload during chat.
         * </p>
         * 
         * @param failedAttachments
         *        A list of files which failed to upload during chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedAttachments(AttachmentOutput... failedAttachments);

        /**
         * <p>
         * A list of files which failed to upload during chat.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.AttachmentOutput.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qbusiness.model.AttachmentOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.AttachmentOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #failedAttachments(List<AttachmentOutput>)}.
         * 
         * @param failedAttachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.AttachmentOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedAttachments(java.util.Collection<AttachmentOutput>)
         */
        Builder failedAttachments(Consumer<AttachmentOutput.Builder>... failedAttachments);

        /**
         * <p>
         * The source documents used to generate the conversation response.
         * </p>
         * 
         * @param sourceAttributions
         *        The source documents used to generate the conversation response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAttributions(Collection<SourceAttribution> sourceAttributions);

        /**
         * <p>
         * The source documents used to generate the conversation response.
         * </p>
         * 
         * @param sourceAttributions
         *        The source documents used to generate the conversation response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAttributions(SourceAttribution... sourceAttributions);

        /**
         * <p>
         * The source documents used to generate the conversation response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.SourceAttribution.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qbusiness.model.SourceAttribution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.SourceAttribution.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceAttributions(List<SourceAttribution>)}.
         * 
         * @param sourceAttributions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.SourceAttribution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceAttributions(java.util.Collection<SourceAttribution>)
         */
        Builder sourceAttributions(Consumer<SourceAttribution.Builder>... sourceAttributions);

        /**
         * <p>
         * An AI-generated message in a conversation.
         * </p>
         * 
         * @param systemMessage
         *        An AI-generated message in a conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemMessage(String systemMessage);

        /**
         * <p>
         * The identifier of an Amazon Q AI generated message within the conversation.
         * </p>
         * 
         * @param systemMessageId
         *        The identifier of an Amazon Q AI generated message within the conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemMessageId(String systemMessageId);

        /**
         * <p>
         * The identifier of an Amazon Q end user text input message within the conversation.
         * </p>
         * 
         * @param userMessageId
         *        The identifier of an Amazon Q end user text input message within the conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMessageId(String userMessageId);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private ActionReview actionReview;

        private String conversationId;

        private List<AttachmentOutput> failedAttachments = DefaultSdkAutoConstructList.getInstance();

        private List<SourceAttribution> sourceAttributions = DefaultSdkAutoConstructList.getInstance();

        private String systemMessage;

        private String systemMessageId;

        private String userMessageId;

        private BuilderImpl() {
        }

        private BuilderImpl(ChatSyncResponse model) {
            super(model);
            actionReview(model.actionReview);
            conversationId(model.conversationId);
            failedAttachments(model.failedAttachments);
            sourceAttributions(model.sourceAttributions);
            systemMessage(model.systemMessage);
            systemMessageId(model.systemMessageId);
            userMessageId(model.userMessageId);
        }

        public final ActionReview.Builder getActionReview() {
            return actionReview != null ? actionReview.toBuilder() : null;
        }

        public final void setActionReview(ActionReview.BuilderImpl actionReview) {
            this.actionReview = actionReview != null ? actionReview.build() : null;
        }

        @Override
        public final Builder actionReview(ActionReview actionReview) {
            this.actionReview = actionReview;
            return this;
        }

        public final String getConversationId() {
            return conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final List<AttachmentOutput.Builder> getFailedAttachments() {
            List<AttachmentOutput.Builder> result = AttachmentsOutputCopier.copyToBuilder(this.failedAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedAttachments(Collection<AttachmentOutput.BuilderImpl> failedAttachments) {
            this.failedAttachments = AttachmentsOutputCopier.copyFromBuilder(failedAttachments);
        }

        @Override
        public final Builder failedAttachments(Collection<AttachmentOutput> failedAttachments) {
            this.failedAttachments = AttachmentsOutputCopier.copy(failedAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAttachments(AttachmentOutput... failedAttachments) {
            failedAttachments(Arrays.asList(failedAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAttachments(Consumer<AttachmentOutput.Builder>... failedAttachments) {
            failedAttachments(Stream.of(failedAttachments).map(c -> AttachmentOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SourceAttribution.Builder> getSourceAttributions() {
            List<SourceAttribution.Builder> result = SourceAttributionsCopier.copyToBuilder(this.sourceAttributions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceAttributions(Collection<SourceAttribution.BuilderImpl> sourceAttributions) {
            this.sourceAttributions = SourceAttributionsCopier.copyFromBuilder(sourceAttributions);
        }

        @Override
        public final Builder sourceAttributions(Collection<SourceAttribution> sourceAttributions) {
            this.sourceAttributions = SourceAttributionsCopier.copy(sourceAttributions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAttributions(SourceAttribution... sourceAttributions) {
            sourceAttributions(Arrays.asList(sourceAttributions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAttributions(Consumer<SourceAttribution.Builder>... sourceAttributions) {
            sourceAttributions(Stream.of(sourceAttributions).map(c -> SourceAttribution.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSystemMessage() {
            return systemMessage;
        }

        public final void setSystemMessage(String systemMessage) {
            this.systemMessage = systemMessage;
        }

        @Override
        public final Builder systemMessage(String systemMessage) {
            this.systemMessage = systemMessage;
            return this;
        }

        public final String getSystemMessageId() {
            return systemMessageId;
        }

        public final void setSystemMessageId(String systemMessageId) {
            this.systemMessageId = systemMessageId;
        }

        @Override
        public final Builder systemMessageId(String systemMessageId) {
            this.systemMessageId = systemMessageId;
            return this;
        }

        public final String getUserMessageId() {
            return userMessageId;
        }

        public final void setUserMessageId(String userMessageId) {
            this.userMessageId = userMessageId;
        }

        @Override
        public final Builder userMessageId(String userMessageId) {
            this.userMessageId = userMessageId;
            return this;
        }

        @Override
        public ChatSyncResponse build() {
            return new ChatSyncResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
