/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserRequest extends QBusinessRequest implements
        ToCopyableBuilder<CreateUserRequest.Builder, CreateUserRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(CreateUserRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateUserRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<UserAlias>> USER_ALIASES_FIELD = SdkField
            .<List<UserAlias>> builder(MarshallingType.LIST)
            .memberName("userAliases")
            .getter(getter(CreateUserRequest::userAliases))
            .setter(setter(Builder::userAliases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAliases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserAlias> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserAlias::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(CreateUserRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CLIENT_TOKEN_FIELD, USER_ALIASES_FIELD, USER_ID_FIELD));

    private final String applicationId;

    private final String clientToken;

    private final List<UserAlias> userAliases;

    private final String userId;

    private CreateUserRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.clientToken = builder.clientToken;
        this.userAliases = builder.userAliases;
        this.userId = builder.userId;
    }

    /**
     * <p>
     * The identifier of the application for which the user mapping will be created.
     * </p>
     * 
     * @return The identifier of the application for which the user mapping will be created.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * A token that you provide to identify the request to create your Amazon Q user mapping.
     * </p>
     * 
     * @return A token that you provide to identify the request to create your Amazon Q user mapping.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserAliases property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserAliases() {
        return userAliases != null && !(userAliases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of user aliases in the mapping.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserAliases} method.
     * </p>
     * 
     * @return The list of user aliases in the mapping.
     */
    public final List<UserAlias> userAliases() {
        return userAliases;
    }

    /**
     * <p>
     * The user emails attached to a user mapping.
     * </p>
     * 
     * @return The user emails attached to a user mapping.
     */
    public final String userId() {
        return userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserAliases() ? userAliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(clientToken(), other.clientToken())
                && hasUserAliases() == other.hasUserAliases() && Objects.equals(userAliases(), other.userAliases())
                && Objects.equals(userId(), other.userId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUserRequest").add("ApplicationId", applicationId()).add("ClientToken", clientToken())
                .add("UserAliases", hasUserAliases() ? userAliases() : null).add("UserId", userId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "userAliases":
            return Optional.ofNullable(clazz.cast(userAliases()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserRequest, T> g) {
        return obj -> g.apply((CreateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateUserRequest> {
        /**
         * <p>
         * The identifier of the application for which the user mapping will be created.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the application for which the user mapping will be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * A token that you provide to identify the request to create your Amazon Q user mapping.
         * </p>
         * 
         * @param clientToken
         *        A token that you provide to identify the request to create your Amazon Q user mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The list of user aliases in the mapping.
         * </p>
         * 
         * @param userAliases
         *        The list of user aliases in the mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAliases(Collection<UserAlias> userAliases);

        /**
         * <p>
         * The list of user aliases in the mapping.
         * </p>
         * 
         * @param userAliases
         *        The list of user aliases in the mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAliases(UserAlias... userAliases);

        /**
         * <p>
         * The list of user aliases in the mapping.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qbusiness.model.UserAlias#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder#build()} is called immediately and
         * its result is passed to {@link #userAliases(List<UserAlias>)}.
         * 
         * @param userAliases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.UserAlias.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAliases(java.util.Collection<UserAlias>)
         */
        Builder userAliases(Consumer<UserAlias.Builder>... userAliases);

        /**
         * <p>
         * The user emails attached to a user mapping.
         * </p>
         * 
         * @param userId
         *        The user emails attached to a user mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String clientToken;

        private List<UserAlias> userAliases = DefaultSdkAutoConstructList.getInstance();

        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserRequest model) {
            super(model);
            applicationId(model.applicationId);
            clientToken(model.clientToken);
            userAliases(model.userAliases);
            userId(model.userId);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<UserAlias.Builder> getUserAliases() {
            List<UserAlias.Builder> result = CreateUserRequestUserAliasesListCopier.copyToBuilder(this.userAliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAliases(Collection<UserAlias.BuilderImpl> userAliases) {
            this.userAliases = CreateUserRequestUserAliasesListCopier.copyFromBuilder(userAliases);
        }

        @Override
        public final Builder userAliases(Collection<UserAlias> userAliases) {
            this.userAliases = CreateUserRequestUserAliasesListCopier.copy(userAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliases(UserAlias... userAliases) {
            userAliases(Arrays.asList(userAliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliases(Consumer<UserAlias.Builder>... userAliases) {
            userAliases(Stream.of(userAliases).map(c -> UserAlias.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
