/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWebExperienceRequest extends QBusinessRequest implements
        ToCopyableBuilder<CreateWebExperienceRequest.Builder, CreateWebExperienceRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(CreateWebExperienceRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateWebExperienceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> SAMPLE_PROMPTS_CONTROL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("samplePromptsControlMode").getter(getter(CreateWebExperienceRequest::samplePromptsControlModeAsString))
            .setter(setter(Builder::samplePromptsControlMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samplePromptsControlMode").build())
            .build();

    private static final SdkField<String> SUBTITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subtitle").getter(getter(CreateWebExperienceRequest::subtitle)).setter(setter(Builder::subtitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subtitle").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateWebExperienceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(CreateWebExperienceRequest::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> WELCOME_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("welcomeMessage").getter(getter(CreateWebExperienceRequest::welcomeMessage))
            .setter(setter(Builder::welcomeMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("welcomeMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APPLICATION_ID_FIELD, CLIENT_TOKEN_FIELD, SAMPLE_PROMPTS_CONTROL_MODE_FIELD, SUBTITLE_FIELD, TAGS_FIELD,
                    TITLE_FIELD, WELCOME_MESSAGE_FIELD));

    private final String applicationId;

    private final String clientToken;

    private final String samplePromptsControlMode;

    private final String subtitle;

    private final List<Tag> tags;

    private final String title;

    private final String welcomeMessage;

    private CreateWebExperienceRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.clientToken = builder.clientToken;
        this.samplePromptsControlMode = builder.samplePromptsControlMode;
        this.subtitle = builder.subtitle;
        this.tags = builder.tags;
        this.title = builder.title;
        this.welcomeMessage = builder.welcomeMessage;
    }

    /**
     * <p>
     * The identifier of the Amazon Q web experience.
     * </p>
     * 
     * @return The identifier of the Amazon Q web experience.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * A token you provide to identify a request to create an Amazon Q web experience.
     * </p>
     * 
     * @return A token you provide to identify a request to create an Amazon Q web experience.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Determines whether sample prompts are enabled in the web experience for an end user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #samplePromptsControlMode} will return
     * {@link WebExperienceSamplePromptsControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #samplePromptsControlModeAsString}.
     * </p>
     * 
     * @return Determines whether sample prompts are enabled in the web experience for an end user.
     * @see WebExperienceSamplePromptsControlMode
     */
    public final WebExperienceSamplePromptsControlMode samplePromptsControlMode() {
        return WebExperienceSamplePromptsControlMode.fromValue(samplePromptsControlMode);
    }

    /**
     * <p>
     * Determines whether sample prompts are enabled in the web experience for an end user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #samplePromptsControlMode} will return
     * {@link WebExperienceSamplePromptsControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #samplePromptsControlModeAsString}.
     * </p>
     * 
     * @return Determines whether sample prompts are enabled in the web experience for an end user.
     * @see WebExperienceSamplePromptsControlMode
     */
    public final String samplePromptsControlModeAsString() {
        return samplePromptsControlMode;
    }

    /**
     * <p>
     * A subtitle to personalize your Amazon Q web experience.
     * </p>
     * 
     * @return A subtitle to personalize your Amazon Q web experience.
     */
    public final String subtitle() {
        return subtitle;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs that identify or categorize your Amazon Q web experience. You can also use tags to help
     * control access to the web experience. Tag keys and values can consist of Unicode letters, digits, white space,
     * and any of the following symbols: _ . : / = + - @.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that identify or categorize your Amazon Q web experience. You can also use tags
     *         to help control access to the web experience. Tag keys and values can consist of Unicode letters, digits,
     *         white space, and any of the following symbols: _ . : / = + - @.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The title for your Amazon Q web experience.
     * </p>
     * 
     * @return The title for your Amazon Q web experience.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The customized welcome message for end users of an Amazon Q web experience.
     * </p>
     * 
     * @return The customized welcome message for end users of an Amazon Q web experience.
     */
    public final String welcomeMessage() {
        return welcomeMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(samplePromptsControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subtitle());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(welcomeMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWebExperienceRequest)) {
            return false;
        }
        CreateWebExperienceRequest other = (CreateWebExperienceRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(samplePromptsControlModeAsString(), other.samplePromptsControlModeAsString())
                && Objects.equals(subtitle(), other.subtitle()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(title(), other.title())
                && Objects.equals(welcomeMessage(), other.welcomeMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWebExperienceRequest").add("ApplicationId", applicationId())
                .add("ClientToken", clientToken()).add("SamplePromptsControlMode", samplePromptsControlModeAsString())
                .add("Subtitle", subtitle()).add("Tags", hasTags() ? tags() : null).add("Title", title())
                .add("WelcomeMessage", welcomeMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "samplePromptsControlMode":
            return Optional.ofNullable(clazz.cast(samplePromptsControlModeAsString()));
        case "subtitle":
            return Optional.ofNullable(clazz.cast(subtitle()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "welcomeMessage":
            return Optional.ofNullable(clazz.cast(welcomeMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWebExperienceRequest, T> g) {
        return obj -> g.apply((CreateWebExperienceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWebExperienceRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q web experience.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * A token you provide to identify a request to create an Amazon Q web experience.
         * </p>
         * 
         * @param clientToken
         *        A token you provide to identify a request to create an Amazon Q web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Determines whether sample prompts are enabled in the web experience for an end user.
         * </p>
         * 
         * @param samplePromptsControlMode
         *        Determines whether sample prompts are enabled in the web experience for an end user.
         * @see WebExperienceSamplePromptsControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebExperienceSamplePromptsControlMode
         */
        Builder samplePromptsControlMode(String samplePromptsControlMode);

        /**
         * <p>
         * Determines whether sample prompts are enabled in the web experience for an end user.
         * </p>
         * 
         * @param samplePromptsControlMode
         *        Determines whether sample prompts are enabled in the web experience for an end user.
         * @see WebExperienceSamplePromptsControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebExperienceSamplePromptsControlMode
         */
        Builder samplePromptsControlMode(WebExperienceSamplePromptsControlMode samplePromptsControlMode);

        /**
         * <p>
         * A subtitle to personalize your Amazon Q web experience.
         * </p>
         * 
         * @param subtitle
         *        A subtitle to personalize your Amazon Q web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subtitle(String subtitle);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize your Amazon Q web experience. You can also use tags to
         * help control access to the web experience. Tag keys and values can consist of Unicode letters, digits, white
         * space, and any of the following symbols: _ . : / = + - @.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify or categorize your Amazon Q web experience. You can also use
         *        tags to help control access to the web experience. Tag keys and values can consist of Unicode letters,
         *        digits, white space, and any of the following symbols: _ . : / = + - @.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize your Amazon Q web experience. You can also use tags to
         * help control access to the web experience. Tag keys and values can consist of Unicode letters, digits, white
         * space, and any of the following symbols: _ . : / = + - @.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify or categorize your Amazon Q web experience. You can also use
         *        tags to help control access to the web experience. Tag keys and values can consist of Unicode letters,
         *        digits, white space, and any of the following symbols: _ . : / = + - @.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize your Amazon Q web experience. You can also use tags to
         * help control access to the web experience. Tag keys and values can consist of Unicode letters, digits, white
         * space, and any of the following symbols: _ . : / = + - @.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.qbusiness.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The title for your Amazon Q web experience.
         * </p>
         * 
         * @param title
         *        The title for your Amazon Q web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The customized welcome message for end users of an Amazon Q web experience.
         * </p>
         * 
         * @param welcomeMessage
         *        The customized welcome message for end users of an Amazon Q web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder welcomeMessage(String welcomeMessage);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String clientToken;

        private String samplePromptsControlMode;

        private String subtitle;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String title;

        private String welcomeMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWebExperienceRequest model) {
            super(model);
            applicationId(model.applicationId);
            clientToken(model.clientToken);
            samplePromptsControlMode(model.samplePromptsControlMode);
            subtitle(model.subtitle);
            tags(model.tags);
            title(model.title);
            welcomeMessage(model.welcomeMessage);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getSamplePromptsControlMode() {
            return samplePromptsControlMode;
        }

        public final void setSamplePromptsControlMode(String samplePromptsControlMode) {
            this.samplePromptsControlMode = samplePromptsControlMode;
        }

        @Override
        public final Builder samplePromptsControlMode(String samplePromptsControlMode) {
            this.samplePromptsControlMode = samplePromptsControlMode;
            return this;
        }

        @Override
        public final Builder samplePromptsControlMode(WebExperienceSamplePromptsControlMode samplePromptsControlMode) {
            this.samplePromptsControlMode(samplePromptsControlMode == null ? null : samplePromptsControlMode.toString());
            return this;
        }

        public final String getSubtitle() {
            return subtitle;
        }

        public final void setSubtitle(String subtitle) {
            this.subtitle = subtitle;
        }

        @Override
        public final Builder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getWelcomeMessage() {
            return welcomeMessage;
        }

        public final void setWelcomeMessage(String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
        }

        @Override
        public final Builder welcomeMessage(String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWebExperienceRequest build() {
            return new CreateWebExperienceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
