/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A document deleted from an Amazon Q data source connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDocument implements SdkPojo, Serializable, ToCopyableBuilder<DeleteDocument.Builder, DeleteDocument> {
    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentId").getter(getter(DeleteDocument::documentId)).setter(setter(Builder::documentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String documentId;

    private DeleteDocument(BuilderImpl builder) {
        this.documentId = builder.documentId;
    }

    /**
     * <p>
     * The identifier of the deleted document.
     * </p>
     * 
     * @return The identifier of the deleted document.
     */
    public final String documentId() {
        return documentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDocument)) {
            return false;
        }
        DeleteDocument other = (DeleteDocument) obj;
        return Objects.equals(documentId(), other.documentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDocument").add("DocumentId", documentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "documentId":
            return Optional.ofNullable(clazz.cast(documentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDocument, T> g) {
        return obj -> g.apply((DeleteDocument) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeleteDocument> {
        /**
         * <p>
         * The identifier of the deleted document.
         * </p>
         * 
         * @param documentId
         *        The identifier of the deleted document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentId(String documentId);
    }

    static final class BuilderImpl implements Builder {
        private String documentId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDocument model) {
            documentId(model.documentId);
        }

        public final String getDocumentId() {
            return documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        @Override
        public DeleteDocument build() {
            return new DeleteDocument(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
