/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataSourceSyncJobsRequest extends QBusinessRequest implements
        ToCopyableBuilder<ListDataSourceSyncJobsRequest.Builder, ListDataSourceSyncJobsRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(ListDataSourceSyncJobsRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceId").getter(getter(ListDataSourceSyncJobsRequest::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataSourceId").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(ListDataSourceSyncJobsRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexId").getter(getter(ListDataSourceSyncJobsRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("indexId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListDataSourceSyncJobsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDataSourceSyncJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(ListDataSourceSyncJobsRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build()).build();

    private static final SdkField<String> STATUS_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusFilter").getter(getter(ListDataSourceSyncJobsRequest::statusFilterAsString))
            .setter(setter(Builder::statusFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("syncStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            DATA_SOURCE_ID_FIELD, END_TIME_FIELD, INDEX_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, START_TIME_FIELD,
            STATUS_FILTER_FIELD));

    private final String applicationId;

    private final String dataSourceId;

    private final Instant endTime;

    private final String indexId;

    private final Integer maxResults;

    private final String nextToken;

    private final Instant startTime;

    private final String statusFilter;

    private ListDataSourceSyncJobsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.dataSourceId = builder.dataSourceId;
        this.endTime = builder.endTime;
        this.indexId = builder.indexId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.startTime = builder.startTime;
        this.statusFilter = builder.statusFilter;
    }

    /**
     * <p>
     * The identifier of the Amazon Q application connected to the data source.
     * </p>
     * 
     * @return The identifier of the Amazon Q application connected to the data source.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The identifier of the data source connector.
     * </p>
     * 
     * @return The identifier of the data source connector.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * The end time of the data source connector sync.
     * </p>
     * 
     * @return The end time of the data source connector sync.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The identifier of the index used with the Amazon Q data source connector.
     * </p>
     * 
     * @return The identifier of the index used with the Amazon Q data source connector.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The maximum number of synchronization jobs to return in the response.
     * </p>
     * 
     * @return The maximum number of synchronization jobs to return in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the <code>maxResults</code> response was incpmplete because there is more data to retriever, Amazon Q returns
     * a pagination token in the response. You can use this pagination token to retrieve the next set of responses.
     * </p>
     * 
     * @return If the <code>maxResults</code> response was incpmplete because there is more data to retriever, Amazon Q
     *         returns a pagination token in the response. You can use this pagination token to retrieve the next set of
     *         responses.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The start time of the data source connector sync.
     * </p>
     * 
     * @return The start time of the data source connector sync.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Only returns synchronization jobs with the <code>Status</code> field equal to the specified status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusFilter} will
     * return {@link DataSourceSyncJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusFilterAsString}.
     * </p>
     * 
     * @return Only returns synchronization jobs with the <code>Status</code> field equal to the specified status.
     * @see DataSourceSyncJobStatus
     */
    public final DataSourceSyncJobStatus statusFilter() {
        return DataSourceSyncJobStatus.fromValue(statusFilter);
    }

    /**
     * <p>
     * Only returns synchronization jobs with the <code>Status</code> field equal to the specified status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusFilter} will
     * return {@link DataSourceSyncJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusFilterAsString}.
     * </p>
     * 
     * @return Only returns synchronization jobs with the <code>Status</code> field equal to the specified status.
     * @see DataSourceSyncJobStatus
     */
    public final String statusFilterAsString() {
        return statusFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusFilterAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSourceSyncJobsRequest)) {
            return false;
        }
        ListDataSourceSyncJobsRequest other = (ListDataSourceSyncJobsRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(dataSourceId(), other.dataSourceId())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(indexId(), other.indexId())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(startTime(), other.startTime())
                && Objects.equals(statusFilterAsString(), other.statusFilterAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDataSourceSyncJobsRequest").add("ApplicationId", applicationId())
                .add("DataSourceId", dataSourceId()).add("EndTime", endTime()).add("IndexId", indexId())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("StartTime", startTime())
                .add("StatusFilter", statusFilterAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "dataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "indexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "statusFilter":
            return Optional.ofNullable(clazz.cast(statusFilterAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDataSourceSyncJobsRequest, T> g) {
        return obj -> g.apply((ListDataSourceSyncJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDataSourceSyncJobsRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q application connected to the data source.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q application connected to the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The identifier of the data source connector.
         * </p>
         * 
         * @param dataSourceId
         *        The identifier of the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * The end time of the data source connector sync.
         * </p>
         * 
         * @param endTime
         *        The end time of the data source connector sync.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The identifier of the index used with the Amazon Q data source connector.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index used with the Amazon Q data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The maximum number of synchronization jobs to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of synchronization jobs to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the <code>maxResults</code> response was incpmplete because there is more data to retriever, Amazon Q
         * returns a pagination token in the response. You can use this pagination token to retrieve the next set of
         * responses.
         * </p>
         * 
         * @param nextToken
         *        If the <code>maxResults</code> response was incpmplete because there is more data to retriever, Amazon
         *        Q returns a pagination token in the response. You can use this pagination token to retrieve the next
         *        set of responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The start time of the data source connector sync.
         * </p>
         * 
         * @param startTime
         *        The start time of the data source connector sync.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Only returns synchronization jobs with the <code>Status</code> field equal to the specified status.
         * </p>
         * 
         * @param statusFilter
         *        Only returns synchronization jobs with the <code>Status</code> field equal to the specified status.
         * @see DataSourceSyncJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceSyncJobStatus
         */
        Builder statusFilter(String statusFilter);

        /**
         * <p>
         * Only returns synchronization jobs with the <code>Status</code> field equal to the specified status.
         * </p>
         * 
         * @param statusFilter
         *        Only returns synchronization jobs with the <code>Status</code> field equal to the specified status.
         * @see DataSourceSyncJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceSyncJobStatus
         */
        Builder statusFilter(DataSourceSyncJobStatus statusFilter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String dataSourceId;

        private Instant endTime;

        private String indexId;

        private Integer maxResults;

        private String nextToken;

        private Instant startTime;

        private String statusFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSourceSyncJobsRequest model) {
            super(model);
            applicationId(model.applicationId);
            dataSourceId(model.dataSourceId);
            endTime(model.endTime);
            indexId(model.indexId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            startTime(model.startTime);
            statusFilter(model.statusFilter);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatusFilter() {
            return statusFilter;
        }

        public final void setStatusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
        }

        @Override
        public final Builder statusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
            return this;
        }

        @Override
        public final Builder statusFilter(DataSourceSyncJobStatus statusFilter) {
            this.statusFilter(statusFilter == null ? null : statusFilter.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDataSourceSyncJobsRequest build() {
            return new ListDataSourceSyncJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
