/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about text documents in an index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextDocumentStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<TextDocumentStatistics.Builder, TextDocumentStatistics> {
    private static final SdkField<Long> INDEXED_TEXT_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("indexedTextBytes").getter(getter(TextDocumentStatistics::indexedTextBytes))
            .setter(setter(Builder::indexedTextBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexedTextBytes").build()).build();

    private static final SdkField<Integer> INDEXED_TEXT_DOCUMENT_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("indexedTextDocumentCount")
            .getter(getter(TextDocumentStatistics::indexedTextDocumentCount)).setter(setter(Builder::indexedTextDocumentCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexedTextDocumentCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEXED_TEXT_BYTES_FIELD,
            INDEXED_TEXT_DOCUMENT_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long indexedTextBytes;

    private final Integer indexedTextDocumentCount;

    private TextDocumentStatistics(BuilderImpl builder) {
        this.indexedTextBytes = builder.indexedTextBytes;
        this.indexedTextDocumentCount = builder.indexedTextDocumentCount;
    }

    /**
     * <p>
     * The total size, in bytes, of the indexed documents.
     * </p>
     * 
     * @return The total size, in bytes, of the indexed documents.
     */
    public final Long indexedTextBytes() {
        return indexedTextBytes;
    }

    /**
     * <p>
     * The number of text documents indexed.
     * </p>
     * 
     * @return The number of text documents indexed.
     */
    public final Integer indexedTextDocumentCount() {
        return indexedTextDocumentCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexedTextBytes());
        hashCode = 31 * hashCode + Objects.hashCode(indexedTextDocumentCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextDocumentStatistics)) {
            return false;
        }
        TextDocumentStatistics other = (TextDocumentStatistics) obj;
        return Objects.equals(indexedTextBytes(), other.indexedTextBytes())
                && Objects.equals(indexedTextDocumentCount(), other.indexedTextDocumentCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextDocumentStatistics").add("IndexedTextBytes", indexedTextBytes())
                .add("IndexedTextDocumentCount", indexedTextDocumentCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "indexedTextBytes":
            return Optional.ofNullable(clazz.cast(indexedTextBytes()));
        case "indexedTextDocumentCount":
            return Optional.ofNullable(clazz.cast(indexedTextDocumentCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TextDocumentStatistics, T> g) {
        return obj -> g.apply((TextDocumentStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextDocumentStatistics> {
        /**
         * <p>
         * The total size, in bytes, of the indexed documents.
         * </p>
         * 
         * @param indexedTextBytes
         *        The total size, in bytes, of the indexed documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexedTextBytes(Long indexedTextBytes);

        /**
         * <p>
         * The number of text documents indexed.
         * </p>
         * 
         * @param indexedTextDocumentCount
         *        The number of text documents indexed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexedTextDocumentCount(Integer indexedTextDocumentCount);
    }

    static final class BuilderImpl implements Builder {
        private Long indexedTextBytes;

        private Integer indexedTextDocumentCount;

        private BuilderImpl() {
        }

        private BuilderImpl(TextDocumentStatistics model) {
            indexedTextBytes(model.indexedTextBytes);
            indexedTextDocumentCount(model.indexedTextDocumentCount);
        }

        public final Long getIndexedTextBytes() {
            return indexedTextBytes;
        }

        public final void setIndexedTextBytes(Long indexedTextBytes) {
            this.indexedTextBytes = indexedTextBytes;
        }

        @Override
        public final Builder indexedTextBytes(Long indexedTextBytes) {
            this.indexedTextBytes = indexedTextBytes;
            return this;
        }

        public final Integer getIndexedTextDocumentCount() {
            return indexedTextDocumentCount;
        }

        public final void setIndexedTextDocumentCount(Integer indexedTextDocumentCount) {
            this.indexedTextDocumentCount = indexedTextDocumentCount;
        }

        @Override
        public final Builder indexedTextDocumentCount(Integer indexedTextDocumentCount) {
            this.indexedTextDocumentCount = indexedTextDocumentCount;
            return this;
        }

        @Override
        public TextDocumentStatistics build() {
            return new TextDocumentStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
