/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The topic specific controls configured for an Amazon Q application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicConfiguration.Builder, TopicConfiguration> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(TopicConfiguration::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> EXAMPLE_CHAT_MESSAGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("exampleChatMessages")
            .getter(getter(TopicConfiguration::exampleChatMessages))
            .setter(setter(Builder::exampleChatMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exampleChatMessages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(TopicConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<Rule>> RULES_FIELD = SdkField
            .<List<Rule>> builder(MarshallingType.LIST)
            .memberName("rules")
            .getter(getter(TopicConfiguration::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Rule> builder(MarshallingType.SDK_POJO)
                                            .constructor(Rule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            EXAMPLE_CHAT_MESSAGES_FIELD, NAME_FIELD, RULES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final List<String> exampleChatMessages;

    private final String name;

    private final List<Rule> rules;

    private TopicConfiguration(BuilderImpl builder) {
        this.description = builder.description;
        this.exampleChatMessages = builder.exampleChatMessages;
        this.name = builder.name;
        this.rules = builder.rules;
    }

    /**
     * <p>
     * A description for your topic control configuration. Use this outline how the large language model (LLM) should
     * use this topic control configuration.
     * </p>
     * 
     * @return A description for your topic control configuration. Use this outline how the large language model (LLM)
     *         should use this topic control configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExampleChatMessages property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExampleChatMessages() {
        return exampleChatMessages != null && !(exampleChatMessages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of example phrases that you expect the end user to use in relation to the topic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExampleChatMessages} method.
     * </p>
     * 
     * @return A list of example phrases that you expect the end user to use in relation to the topic.
     */
    public final List<String> exampleChatMessages() {
        return exampleChatMessages;
    }

    /**
     * <p>
     * A name for your topic control configuration.
     * </p>
     * 
     * @return A name for your topic control configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Rules defined for a topic configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return Rules defined for a topic configuration.
     */
    public final List<Rule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasExampleChatMessages() ? exampleChatMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicConfiguration)) {
            return false;
        }
        TopicConfiguration other = (TopicConfiguration) obj;
        return Objects.equals(description(), other.description()) && hasExampleChatMessages() == other.hasExampleChatMessages()
                && Objects.equals(exampleChatMessages(), other.exampleChatMessages()) && Objects.equals(name(), other.name())
                && hasRules() == other.hasRules() && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicConfiguration").add("Description", description())
                .add("ExampleChatMessages", hasExampleChatMessages() ? exampleChatMessages() : null).add("Name", name())
                .add("Rules", hasRules() ? rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "exampleChatMessages":
            return Optional.ofNullable(clazz.cast(exampleChatMessages()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicConfiguration, T> g) {
        return obj -> g.apply((TopicConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicConfiguration> {
        /**
         * <p>
         * A description for your topic control configuration. Use this outline how the large language model (LLM)
         * should use this topic control configuration.
         * </p>
         * 
         * @param description
         *        A description for your topic control configuration. Use this outline how the large language model
         *        (LLM) should use this topic control configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of example phrases that you expect the end user to use in relation to the topic.
         * </p>
         * 
         * @param exampleChatMessages
         *        A list of example phrases that you expect the end user to use in relation to the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exampleChatMessages(Collection<String> exampleChatMessages);

        /**
         * <p>
         * A list of example phrases that you expect the end user to use in relation to the topic.
         * </p>
         * 
         * @param exampleChatMessages
         *        A list of example phrases that you expect the end user to use in relation to the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exampleChatMessages(String... exampleChatMessages);

        /**
         * <p>
         * A name for your topic control configuration.
         * </p>
         * 
         * @param name
         *        A name for your topic control configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Rules defined for a topic configuration.
         * </p>
         * 
         * @param rules
         *        Rules defined for a topic configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<Rule> rules);

        /**
         * <p>
         * Rules defined for a topic configuration.
         * </p>
         * 
         * @param rules
         *        Rules defined for a topic configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Rule... rules);

        /**
         * <p>
         * Rules defined for a topic configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.Rule.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.qbusiness.model.Rule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.Rule.Builder#build()} is called immediately and its
         * result is passed to {@link #rules(List<Rule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.Rule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<Rule>)
         */
        Builder rules(Consumer<Rule.Builder>... rules);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private List<String> exampleChatMessages = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TopicConfiguration model) {
            description(model.description);
            exampleChatMessages(model.exampleChatMessages);
            name(model.name);
            rules(model.rules);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getExampleChatMessages() {
            if (exampleChatMessages instanceof SdkAutoConstructList) {
                return null;
            }
            return exampleChatMessages;
        }

        public final void setExampleChatMessages(Collection<String> exampleChatMessages) {
            this.exampleChatMessages = ExampleChatMessagesCopier.copy(exampleChatMessages);
        }

        @Override
        public final Builder exampleChatMessages(Collection<String> exampleChatMessages) {
            this.exampleChatMessages = ExampleChatMessagesCopier.copy(exampleChatMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exampleChatMessages(String... exampleChatMessages) {
            exampleChatMessages(Arrays.asList(exampleChatMessages));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<Rule.Builder> getRules() {
            List<Rule.Builder> result = RulesCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RulesCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> Rule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TopicConfiguration build() {
            return new TopicConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
