/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Enables filtering of Amazon Q web experience responses based on document attributes or metadata fields.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeFilter implements SdkPojo, Serializable, ToCopyableBuilder<AttributeFilter.Builder, AttributeFilter> {
    private static final SdkField<List<AttributeFilter>> AND_ALL_FILTERS_FIELD = SdkField
            .<List<AttributeFilter>> builder(MarshallingType.LIST)
            .memberName("andAllFilters")
            .getter(getter(AttributeFilter::andAllFilters))
            .setter(setter(Builder::andAllFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("andAllFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DocumentAttribute> CONTAINS_ALL_FIELD = SdkField
            .<DocumentAttribute> builder(MarshallingType.SDK_POJO).memberName("containsAll")
            .getter(getter(AttributeFilter::containsAll)).setter(setter(Builder::containsAll))
            .constructor(DocumentAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containsAll").build()).build();

    private static final SdkField<DocumentAttribute> CONTAINS_ANY_FIELD = SdkField
            .<DocumentAttribute> builder(MarshallingType.SDK_POJO).memberName("containsAny")
            .getter(getter(AttributeFilter::containsAny)).setter(setter(Builder::containsAny))
            .constructor(DocumentAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containsAny").build()).build();

    private static final SdkField<DocumentAttribute> EQUALS_TO_FIELD = SdkField
            .<DocumentAttribute> builder(MarshallingType.SDK_POJO).memberName("equalsTo")
            .getter(getter(AttributeFilter::equalsTo)).setter(setter(Builder::equalsTo)).constructor(DocumentAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("equalsTo").build()).build();

    private static final SdkField<DocumentAttribute> GREATER_THAN_FIELD = SdkField
            .<DocumentAttribute> builder(MarshallingType.SDK_POJO).memberName("greaterThan")
            .getter(getter(AttributeFilter::greaterThan)).setter(setter(Builder::greaterThan))
            .constructor(DocumentAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greaterThan").build()).build();

    private static final SdkField<DocumentAttribute> GREATER_THAN_OR_EQUALS_FIELD = SdkField
            .<DocumentAttribute> builder(MarshallingType.SDK_POJO).memberName("greaterThanOrEquals")
            .getter(getter(AttributeFilter::greaterThanOrEquals)).setter(setter(Builder::greaterThanOrEquals))
            .constructor(DocumentAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greaterThanOrEquals").build())
            .build();

    private static final SdkField<DocumentAttribute> LESS_THAN_FIELD = SdkField
            .<DocumentAttribute> builder(MarshallingType.SDK_POJO).memberName("lessThan")
            .getter(getter(AttributeFilter::lessThan)).setter(setter(Builder::lessThan)).constructor(DocumentAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lessThan").build()).build();

    private static final SdkField<DocumentAttribute> LESS_THAN_OR_EQUALS_FIELD = SdkField
            .<DocumentAttribute> builder(MarshallingType.SDK_POJO).memberName("lessThanOrEquals")
            .getter(getter(AttributeFilter::lessThanOrEquals)).setter(setter(Builder::lessThanOrEquals))
            .constructor(DocumentAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lessThanOrEquals").build()).build();

    private static final SdkField<AttributeFilter> NOT_FILTER_FIELD = SdkField
            .<AttributeFilter> builder(MarshallingType.SDK_POJO).memberName("notFilter")
            .getter(getter(AttributeFilter::notFilter)).setter(setter(Builder::notFilter)).constructor(AttributeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notFilter").build()).build();

    private static final SdkField<List<AttributeFilter>> OR_ALL_FILTERS_FIELD = SdkField
            .<List<AttributeFilter>> builder(MarshallingType.LIST)
            .memberName("orAllFilters")
            .getter(getter(AttributeFilter::orAllFilters))
            .setter(setter(Builder::orAllFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orAllFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AND_ALL_FILTERS_FIELD,
            CONTAINS_ALL_FIELD, CONTAINS_ANY_FIELD, EQUALS_TO_FIELD, GREATER_THAN_FIELD, GREATER_THAN_OR_EQUALS_FIELD,
            LESS_THAN_FIELD, LESS_THAN_OR_EQUALS_FIELD, NOT_FILTER_FIELD, OR_ALL_FILTERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AttributeFilter> andAllFilters;

    private final DocumentAttribute containsAll;

    private final DocumentAttribute containsAny;

    private final DocumentAttribute equalsTo;

    private final DocumentAttribute greaterThan;

    private final DocumentAttribute greaterThanOrEquals;

    private final DocumentAttribute lessThan;

    private final DocumentAttribute lessThanOrEquals;

    private final AttributeFilter notFilter;

    private final List<AttributeFilter> orAllFilters;

    private AttributeFilter(BuilderImpl builder) {
        this.andAllFilters = builder.andAllFilters;
        this.containsAll = builder.containsAll;
        this.containsAny = builder.containsAny;
        this.equalsTo = builder.equalsTo;
        this.greaterThan = builder.greaterThan;
        this.greaterThanOrEquals = builder.greaterThanOrEquals;
        this.lessThan = builder.lessThan;
        this.lessThanOrEquals = builder.lessThanOrEquals;
        this.notFilter = builder.notFilter;
        this.orAllFilters = builder.orAllFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the AndAllFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAndAllFilters() {
        return andAllFilters != null && !(andAllFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Performs a logical <code>AND</code> operation on all supplied filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAndAllFilters} method.
     * </p>
     * 
     * @return Performs a logical <code>AND</code> operation on all supplied filters.
     */
    public final List<AttributeFilter> andAllFilters() {
        return andAllFilters;
    }

    /**
     * <p>
     * Returns <code>true</code> when a document contains all the specified document attributes or metadata fields.
     * </p>
     * 
     * @return Returns <code>true</code> when a document contains all the specified document attributes or metadata
     *         fields.
     */
    public final DocumentAttribute containsAll() {
        return containsAll;
    }

    /**
     * <p>
     * Returns <code>true</code> when a document contains any of the specified document attributes or metadata fields.
     * </p>
     * 
     * @return Returns <code>true</code> when a document contains any of the specified document attributes or metadata
     *         fields.
     */
    public final DocumentAttribute containsAny() {
        return containsAny;
    }

    /**
     * <p>
     * Performs an equals operation on two document attributes or metadata fields.
     * </p>
     * 
     * @return Performs an equals operation on two document attributes or metadata fields.
     */
    public final DocumentAttribute equalsTo() {
        return equalsTo;
    }

    /**
     * <p>
     * Performs a greater than operation on two document attributes or metadata fields. Use with a document attribute of
     * type <code>Date</code> or <code>Long</code>.
     * </p>
     * 
     * @return Performs a greater than operation on two document attributes or metadata fields. Use with a document
     *         attribute of type <code>Date</code> or <code>Long</code>.
     */
    public final DocumentAttribute greaterThan() {
        return greaterThan;
    }

    /**
     * <p>
     * Performs a greater or equals than operation on two document attributes or metadata fields. Use with a document
     * attribute of type <code>Date</code> or <code>Long</code>.
     * </p>
     * 
     * @return Performs a greater or equals than operation on two document attributes or metadata fields. Use with a
     *         document attribute of type <code>Date</code> or <code>Long</code>.
     */
    public final DocumentAttribute greaterThanOrEquals() {
        return greaterThanOrEquals;
    }

    /**
     * <p>
     * Performs a less than operation on two document attributes or metadata fields. Use with a document attribute of
     * type <code>Date</code> or <code>Long</code>.
     * </p>
     * 
     * @return Performs a less than operation on two document attributes or metadata fields. Use with a document
     *         attribute of type <code>Date</code> or <code>Long</code>.
     */
    public final DocumentAttribute lessThan() {
        return lessThan;
    }

    /**
     * <p>
     * Performs a less than or equals operation on two document attributes or metadata fields. Use with a document
     * attribute of type <code>Date</code> or <code>Long</code>.
     * </p>
     * 
     * @return Performs a less than or equals operation on two document attributes or metadata fields. Use with a
     *         document attribute of type <code>Date</code> or <code>Long</code>.
     */
    public final DocumentAttribute lessThanOrEquals() {
        return lessThanOrEquals;
    }

    /**
     * <p>
     * Performs a logical <code>NOT</code> operation on all supplied filters.
     * </p>
     * 
     * @return Performs a logical <code>NOT</code> operation on all supplied filters.
     */
    public final AttributeFilter notFilter() {
        return notFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrAllFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrAllFilters() {
        return orAllFilters != null && !(orAllFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Performs a logical <code>OR</code> operation on all supplied filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrAllFilters} method.
     * </p>
     * 
     * @return Performs a logical <code>OR</code> operation on all supplied filters.
     */
    public final List<AttributeFilter> orAllFilters() {
        return orAllFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAndAllFilters() ? andAllFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(containsAll());
        hashCode = 31 * hashCode + Objects.hashCode(containsAny());
        hashCode = 31 * hashCode + Objects.hashCode(equalsTo());
        hashCode = 31 * hashCode + Objects.hashCode(greaterThan());
        hashCode = 31 * hashCode + Objects.hashCode(greaterThanOrEquals());
        hashCode = 31 * hashCode + Objects.hashCode(lessThan());
        hashCode = 31 * hashCode + Objects.hashCode(lessThanOrEquals());
        hashCode = 31 * hashCode + Objects.hashCode(notFilter());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrAllFilters() ? orAllFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeFilter)) {
            return false;
        }
        AttributeFilter other = (AttributeFilter) obj;
        return hasAndAllFilters() == other.hasAndAllFilters() && Objects.equals(andAllFilters(), other.andAllFilters())
                && Objects.equals(containsAll(), other.containsAll()) && Objects.equals(containsAny(), other.containsAny())
                && Objects.equals(equalsTo(), other.equalsTo()) && Objects.equals(greaterThan(), other.greaterThan())
                && Objects.equals(greaterThanOrEquals(), other.greaterThanOrEquals())
                && Objects.equals(lessThan(), other.lessThan()) && Objects.equals(lessThanOrEquals(), other.lessThanOrEquals())
                && Objects.equals(notFilter(), other.notFilter()) && hasOrAllFilters() == other.hasOrAllFilters()
                && Objects.equals(orAllFilters(), other.orAllFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeFilter").add("AndAllFilters", hasAndAllFilters() ? andAllFilters() : null)
                .add("ContainsAll", containsAll()).add("ContainsAny", containsAny()).add("EqualsTo", equalsTo())
                .add("GreaterThan", greaterThan()).add("GreaterThanOrEquals", greaterThanOrEquals()).add("LessThan", lessThan())
                .add("LessThanOrEquals", lessThanOrEquals()).add("NotFilter", notFilter())
                .add("OrAllFilters", hasOrAllFilters() ? orAllFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "andAllFilters":
            return Optional.ofNullable(clazz.cast(andAllFilters()));
        case "containsAll":
            return Optional.ofNullable(clazz.cast(containsAll()));
        case "containsAny":
            return Optional.ofNullable(clazz.cast(containsAny()));
        case "equalsTo":
            return Optional.ofNullable(clazz.cast(equalsTo()));
        case "greaterThan":
            return Optional.ofNullable(clazz.cast(greaterThan()));
        case "greaterThanOrEquals":
            return Optional.ofNullable(clazz.cast(greaterThanOrEquals()));
        case "lessThan":
            return Optional.ofNullable(clazz.cast(lessThan()));
        case "lessThanOrEquals":
            return Optional.ofNullable(clazz.cast(lessThanOrEquals()));
        case "notFilter":
            return Optional.ofNullable(clazz.cast(notFilter()));
        case "orAllFilters":
            return Optional.ofNullable(clazz.cast(orAllFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttributeFilter, T> g) {
        return obj -> g.apply((AttributeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeFilter> {
        /**
         * <p>
         * Performs a logical <code>AND</code> operation on all supplied filters.
         * </p>
         * 
         * @param andAllFilters
         *        Performs a logical <code>AND</code> operation on all supplied filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andAllFilters(Collection<AttributeFilter> andAllFilters);

        /**
         * <p>
         * Performs a logical <code>AND</code> operation on all supplied filters.
         * </p>
         * 
         * @param andAllFilters
         *        Performs a logical <code>AND</code> operation on all supplied filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andAllFilters(AttributeFilter... andAllFilters);

        /**
         * <p>
         * Performs a logical <code>AND</code> operation on all supplied filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.AttributeFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qbusiness.model.AttributeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.AttributeFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #andAllFilters(List<AttributeFilter>)}.
         * 
         * @param andAllFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.AttributeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #andAllFilters(java.util.Collection<AttributeFilter>)
         */
        Builder andAllFilters(Consumer<Builder>... andAllFilters);

        /**
         * <p>
         * Returns <code>true</code> when a document contains all the specified document attributes or metadata fields.
         * </p>
         * 
         * @param containsAll
         *        Returns <code>true</code> when a document contains all the specified document attributes or metadata
         *        fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containsAll(DocumentAttribute containsAll);

        /**
         * <p>
         * Returns <code>true</code> when a document contains all the specified document attributes or metadata fields.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentAttribute.Builder} avoiding the
         * need to create one manually via {@link DocumentAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #containsAll(DocumentAttribute)}.
         * 
         * @param containsAll
         *        a consumer that will call methods on {@link DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containsAll(DocumentAttribute)
         */
        default Builder containsAll(Consumer<DocumentAttribute.Builder> containsAll) {
            return containsAll(DocumentAttribute.builder().applyMutation(containsAll).build());
        }

        /**
         * <p>
         * Returns <code>true</code> when a document contains any of the specified document attributes or metadata
         * fields.
         * </p>
         * 
         * @param containsAny
         *        Returns <code>true</code> when a document contains any of the specified document attributes or
         *        metadata fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containsAny(DocumentAttribute containsAny);

        /**
         * <p>
         * Returns <code>true</code> when a document contains any of the specified document attributes or metadata
         * fields.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentAttribute.Builder} avoiding the
         * need to create one manually via {@link DocumentAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #containsAny(DocumentAttribute)}.
         * 
         * @param containsAny
         *        a consumer that will call methods on {@link DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containsAny(DocumentAttribute)
         */
        default Builder containsAny(Consumer<DocumentAttribute.Builder> containsAny) {
            return containsAny(DocumentAttribute.builder().applyMutation(containsAny).build());
        }

        /**
         * <p>
         * Performs an equals operation on two document attributes or metadata fields.
         * </p>
         * 
         * @param equalsTo
         *        Performs an equals operation on two document attributes or metadata fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equalsTo(DocumentAttribute equalsTo);

        /**
         * <p>
         * Performs an equals operation on two document attributes or metadata fields.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentAttribute.Builder} avoiding the
         * need to create one manually via {@link DocumentAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #equalsTo(DocumentAttribute)}.
         * 
         * @param equalsTo
         *        a consumer that will call methods on {@link DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #equalsTo(DocumentAttribute)
         */
        default Builder equalsTo(Consumer<DocumentAttribute.Builder> equalsTo) {
            return equalsTo(DocumentAttribute.builder().applyMutation(equalsTo).build());
        }

        /**
         * <p>
         * Performs a greater than operation on two document attributes or metadata fields. Use with a document
         * attribute of type <code>Date</code> or <code>Long</code>.
         * </p>
         * 
         * @param greaterThan
         *        Performs a greater than operation on two document attributes or metadata fields. Use with a document
         *        attribute of type <code>Date</code> or <code>Long</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greaterThan(DocumentAttribute greaterThan);

        /**
         * <p>
         * Performs a greater than operation on two document attributes or metadata fields. Use with a document
         * attribute of type <code>Date</code> or <code>Long</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentAttribute.Builder} avoiding the
         * need to create one manually via {@link DocumentAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #greaterThan(DocumentAttribute)}.
         * 
         * @param greaterThan
         *        a consumer that will call methods on {@link DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #greaterThan(DocumentAttribute)
         */
        default Builder greaterThan(Consumer<DocumentAttribute.Builder> greaterThan) {
            return greaterThan(DocumentAttribute.builder().applyMutation(greaterThan).build());
        }

        /**
         * <p>
         * Performs a greater or equals than operation on two document attributes or metadata fields. Use with a
         * document attribute of type <code>Date</code> or <code>Long</code>.
         * </p>
         * 
         * @param greaterThanOrEquals
         *        Performs a greater or equals than operation on two document attributes or metadata fields. Use with a
         *        document attribute of type <code>Date</code> or <code>Long</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greaterThanOrEquals(DocumentAttribute greaterThanOrEquals);

        /**
         * <p>
         * Performs a greater or equals than operation on two document attributes or metadata fields. Use with a
         * document attribute of type <code>Date</code> or <code>Long</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentAttribute.Builder} avoiding the
         * need to create one manually via {@link DocumentAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #greaterThanOrEquals(DocumentAttribute)}.
         * 
         * @param greaterThanOrEquals
         *        a consumer that will call methods on {@link DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #greaterThanOrEquals(DocumentAttribute)
         */
        default Builder greaterThanOrEquals(Consumer<DocumentAttribute.Builder> greaterThanOrEquals) {
            return greaterThanOrEquals(DocumentAttribute.builder().applyMutation(greaterThanOrEquals).build());
        }

        /**
         * <p>
         * Performs a less than operation on two document attributes or metadata fields. Use with a document attribute
         * of type <code>Date</code> or <code>Long</code>.
         * </p>
         * 
         * @param lessThan
         *        Performs a less than operation on two document attributes or metadata fields. Use with a document
         *        attribute of type <code>Date</code> or <code>Long</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lessThan(DocumentAttribute lessThan);

        /**
         * <p>
         * Performs a less than operation on two document attributes or metadata fields. Use with a document attribute
         * of type <code>Date</code> or <code>Long</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentAttribute.Builder} avoiding the
         * need to create one manually via {@link DocumentAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #lessThan(DocumentAttribute)}.
         * 
         * @param lessThan
         *        a consumer that will call methods on {@link DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lessThan(DocumentAttribute)
         */
        default Builder lessThan(Consumer<DocumentAttribute.Builder> lessThan) {
            return lessThan(DocumentAttribute.builder().applyMutation(lessThan).build());
        }

        /**
         * <p>
         * Performs a less than or equals operation on two document attributes or metadata fields. Use with a document
         * attribute of type <code>Date</code> or <code>Long</code>.
         * </p>
         * 
         * @param lessThanOrEquals
         *        Performs a less than or equals operation on two document attributes or metadata fields. Use with a
         *        document attribute of type <code>Date</code> or <code>Long</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lessThanOrEquals(DocumentAttribute lessThanOrEquals);

        /**
         * <p>
         * Performs a less than or equals operation on two document attributes or metadata fields. Use with a document
         * attribute of type <code>Date</code> or <code>Long</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentAttribute.Builder} avoiding the
         * need to create one manually via {@link DocumentAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #lessThanOrEquals(DocumentAttribute)}.
         * 
         * @param lessThanOrEquals
         *        a consumer that will call methods on {@link DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lessThanOrEquals(DocumentAttribute)
         */
        default Builder lessThanOrEquals(Consumer<DocumentAttribute.Builder> lessThanOrEquals) {
            return lessThanOrEquals(DocumentAttribute.builder().applyMutation(lessThanOrEquals).build());
        }

        /**
         * <p>
         * Performs a logical <code>NOT</code> operation on all supplied filters.
         * </p>
         * 
         * @param notFilter
         *        Performs a logical <code>NOT</code> operation on all supplied filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notFilter(AttributeFilter notFilter);

        /**
         * <p>
         * Performs a logical <code>NOT</code> operation on all supplied filters.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeFilter.Builder} avoiding the
         * need to create one manually via {@link AttributeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #notFilter(AttributeFilter)}.
         * 
         * @param notFilter
         *        a consumer that will call methods on {@link AttributeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notFilter(AttributeFilter)
         */
        default Builder notFilter(Consumer<Builder> notFilter) {
            return notFilter(AttributeFilter.builder().applyMutation(notFilter).build());
        }

        /**
         * <p>
         * Performs a logical <code>OR</code> operation on all supplied filters.
         * </p>
         * 
         * @param orAllFilters
         *        Performs a logical <code>OR</code> operation on all supplied filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orAllFilters(Collection<AttributeFilter> orAllFilters);

        /**
         * <p>
         * Performs a logical <code>OR</code> operation on all supplied filters.
         * </p>
         * 
         * @param orAllFilters
         *        Performs a logical <code>OR</code> operation on all supplied filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orAllFilters(AttributeFilter... orAllFilters);

        /**
         * <p>
         * Performs a logical <code>OR</code> operation on all supplied filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.AttributeFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qbusiness.model.AttributeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.AttributeFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #orAllFilters(List<AttributeFilter>)}.
         * 
         * @param orAllFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.AttributeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orAllFilters(java.util.Collection<AttributeFilter>)
         */
        Builder orAllFilters(Consumer<Builder>... orAllFilters);
    }

    static final class BuilderImpl implements Builder {
        private List<AttributeFilter> andAllFilters = DefaultSdkAutoConstructList.getInstance();

        private DocumentAttribute containsAll;

        private DocumentAttribute containsAny;

        private DocumentAttribute equalsTo;

        private DocumentAttribute greaterThan;

        private DocumentAttribute greaterThanOrEquals;

        private DocumentAttribute lessThan;

        private DocumentAttribute lessThanOrEquals;

        private AttributeFilter notFilter;

        private List<AttributeFilter> orAllFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeFilter model) {
            andAllFilters(model.andAllFilters);
            containsAll(model.containsAll);
            containsAny(model.containsAny);
            equalsTo(model.equalsTo);
            greaterThan(model.greaterThan);
            greaterThanOrEquals(model.greaterThanOrEquals);
            lessThan(model.lessThan);
            lessThanOrEquals(model.lessThanOrEquals);
            notFilter(model.notFilter);
            orAllFilters(model.orAllFilters);
        }

        public final List<Builder> getAndAllFilters() {
            List<Builder> result = AttributeFiltersCopier.copyToBuilder(this.andAllFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndAllFilters(Collection<BuilderImpl> andAllFilters) {
            this.andAllFilters = AttributeFiltersCopier.copyFromBuilder(andAllFilters);
        }

        @Override
        public final Builder andAllFilters(Collection<AttributeFilter> andAllFilters) {
            this.andAllFilters = AttributeFiltersCopier.copy(andAllFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andAllFilters(AttributeFilter... andAllFilters) {
            andAllFilters(Arrays.asList(andAllFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andAllFilters(Consumer<Builder>... andAllFilters) {
            andAllFilters(Stream.of(andAllFilters).map(c -> AttributeFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final DocumentAttribute.Builder getContainsAll() {
            return containsAll != null ? containsAll.toBuilder() : null;
        }

        public final void setContainsAll(DocumentAttribute.BuilderImpl containsAll) {
            this.containsAll = containsAll != null ? containsAll.build() : null;
        }

        @Override
        public final Builder containsAll(DocumentAttribute containsAll) {
            this.containsAll = containsAll;
            return this;
        }

        public final DocumentAttribute.Builder getContainsAny() {
            return containsAny != null ? containsAny.toBuilder() : null;
        }

        public final void setContainsAny(DocumentAttribute.BuilderImpl containsAny) {
            this.containsAny = containsAny != null ? containsAny.build() : null;
        }

        @Override
        public final Builder containsAny(DocumentAttribute containsAny) {
            this.containsAny = containsAny;
            return this;
        }

        public final DocumentAttribute.Builder getEqualsTo() {
            return equalsTo != null ? equalsTo.toBuilder() : null;
        }

        public final void setEqualsTo(DocumentAttribute.BuilderImpl equalsTo) {
            this.equalsTo = equalsTo != null ? equalsTo.build() : null;
        }

        @Override
        public final Builder equalsTo(DocumentAttribute equalsTo) {
            this.equalsTo = equalsTo;
            return this;
        }

        public final DocumentAttribute.Builder getGreaterThan() {
            return greaterThan != null ? greaterThan.toBuilder() : null;
        }

        public final void setGreaterThan(DocumentAttribute.BuilderImpl greaterThan) {
            this.greaterThan = greaterThan != null ? greaterThan.build() : null;
        }

        @Override
        public final Builder greaterThan(DocumentAttribute greaterThan) {
            this.greaterThan = greaterThan;
            return this;
        }

        public final DocumentAttribute.Builder getGreaterThanOrEquals() {
            return greaterThanOrEquals != null ? greaterThanOrEquals.toBuilder() : null;
        }

        public final void setGreaterThanOrEquals(DocumentAttribute.BuilderImpl greaterThanOrEquals) {
            this.greaterThanOrEquals = greaterThanOrEquals != null ? greaterThanOrEquals.build() : null;
        }

        @Override
        public final Builder greaterThanOrEquals(DocumentAttribute greaterThanOrEquals) {
            this.greaterThanOrEquals = greaterThanOrEquals;
            return this;
        }

        public final DocumentAttribute.Builder getLessThan() {
            return lessThan != null ? lessThan.toBuilder() : null;
        }

        public final void setLessThan(DocumentAttribute.BuilderImpl lessThan) {
            this.lessThan = lessThan != null ? lessThan.build() : null;
        }

        @Override
        public final Builder lessThan(DocumentAttribute lessThan) {
            this.lessThan = lessThan;
            return this;
        }

        public final DocumentAttribute.Builder getLessThanOrEquals() {
            return lessThanOrEquals != null ? lessThanOrEquals.toBuilder() : null;
        }

        public final void setLessThanOrEquals(DocumentAttribute.BuilderImpl lessThanOrEquals) {
            this.lessThanOrEquals = lessThanOrEquals != null ? lessThanOrEquals.build() : null;
        }

        @Override
        public final Builder lessThanOrEquals(DocumentAttribute lessThanOrEquals) {
            this.lessThanOrEquals = lessThanOrEquals;
            return this;
        }

        public final Builder getNotFilter() {
            return notFilter != null ? notFilter.toBuilder() : null;
        }

        public final void setNotFilter(BuilderImpl notFilter) {
            this.notFilter = notFilter != null ? notFilter.build() : null;
        }

        @Override
        public final Builder notFilter(AttributeFilter notFilter) {
            this.notFilter = notFilter;
            return this;
        }

        public final List<Builder> getOrAllFilters() {
            List<Builder> result = AttributeFiltersCopier.copyToBuilder(this.orAllFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrAllFilters(Collection<BuilderImpl> orAllFilters) {
            this.orAllFilters = AttributeFiltersCopier.copyFromBuilder(orAllFilters);
        }

        @Override
        public final Builder orAllFilters(Collection<AttributeFilter> orAllFilters) {
            this.orAllFilters = AttributeFiltersCopier.copy(orAllFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orAllFilters(AttributeFilter... orAllFilters) {
            orAllFilters(Arrays.asList(orAllFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orAllFilters(Consumer<Builder>... orAllFilters) {
            orAllFilters(Stream.of(orAllFilters).map(c -> AttributeFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AttributeFilter build() {
            return new AttributeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
