/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChatSyncRequest extends QBusinessRequest implements
        ToCopyableBuilder<ChatSyncRequest.Builder, ChatSyncRequest> {
    private static final SdkField<ActionExecution> ACTION_EXECUTION_FIELD = SdkField
            .<ActionExecution> builder(MarshallingType.SDK_POJO).memberName("actionExecution")
            .getter(getter(ChatSyncRequest::actionExecution)).setter(setter(Builder::actionExecution))
            .constructor(ActionExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionExecution").build()).build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(ChatSyncRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<List<AttachmentInput>> ATTACHMENTS_FIELD = SdkField
            .<List<AttachmentInput>> builder(MarshallingType.LIST)
            .memberName("attachments")
            .getter(getter(ChatSyncRequest::attachments))
            .setter(setter(Builder::attachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttachmentInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttachmentInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AttributeFilter> ATTRIBUTE_FILTER_FIELD = SdkField
            .<AttributeFilter> builder(MarshallingType.SDK_POJO).memberName("attributeFilter")
            .getter(getter(ChatSyncRequest::attributeFilter)).setter(setter(Builder::attributeFilter))
            .constructor(AttributeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeFilter").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(ChatSyncRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conversationId").getter(getter(ChatSyncRequest::conversationId)).setter(setter(Builder::conversationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationId").build()).build();

    private static final SdkField<String> PARENT_MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentMessageId").getter(getter(ChatSyncRequest::parentMessageId))
            .setter(setter(Builder::parentMessageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentMessageId").build()).build();

    private static final SdkField<List<String>> USER_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("userGroups")
            .getter(getter(ChatSyncRequest::userGroups))
            .setter(setter(Builder::userGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(ChatSyncRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userId").build()).build();

    private static final SdkField<String> USER_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userMessage").getter(getter(ChatSyncRequest::userMessage)).setter(setter(Builder::userMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_EXECUTION_FIELD,
            APPLICATION_ID_FIELD, ATTACHMENTS_FIELD, ATTRIBUTE_FILTER_FIELD, CLIENT_TOKEN_FIELD, CONVERSATION_ID_FIELD,
            PARENT_MESSAGE_ID_FIELD, USER_GROUPS_FIELD, USER_ID_FIELD, USER_MESSAGE_FIELD));

    private final ActionExecution actionExecution;

    private final String applicationId;

    private final List<AttachmentInput> attachments;

    private final AttributeFilter attributeFilter;

    private final String clientToken;

    private final String conversationId;

    private final String parentMessageId;

    private final List<String> userGroups;

    private final String userId;

    private final String userMessage;

    private ChatSyncRequest(BuilderImpl builder) {
        super(builder);
        this.actionExecution = builder.actionExecution;
        this.applicationId = builder.applicationId;
        this.attachments = builder.attachments;
        this.attributeFilter = builder.attributeFilter;
        this.clientToken = builder.clientToken;
        this.conversationId = builder.conversationId;
        this.parentMessageId = builder.parentMessageId;
        this.userGroups = builder.userGroups;
        this.userId = builder.userId;
        this.userMessage = builder.userMessage;
    }

    /**
     * <p>
     * A request from an end user to perform an Amazon Q plugin action.
     * </p>
     * 
     * @return A request from an end user to perform an Amazon Q plugin action.
     */
    public final ActionExecution actionExecution() {
        return actionExecution;
    }

    /**
     * <p>
     * The identifier of the Amazon Q application linked to the Amazon Q conversation.
     * </p>
     * 
     * @return The identifier of the Amazon Q application linked to the Amazon Q conversation.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attachments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttachments() {
        return attachments != null && !(attachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of files uploaded directly during chat. You can upload a maximum of 5 files of upto 10 MB each.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachments} method.
     * </p>
     * 
     * @return A list of files uploaded directly during chat. You can upload a maximum of 5 files of upto 10 MB each.
     */
    public final List<AttachmentInput> attachments() {
        return attachments;
    }

    /**
     * <p>
     * Enables filtering of Amazon Q web experience responses based on document attributes or metadata fields.
     * </p>
     * 
     * @return Enables filtering of Amazon Q web experience responses based on document attributes or metadata fields.
     */
    public final AttributeFilter attributeFilter() {
        return attributeFilter;
    }

    /**
     * <p>
     * A token that you provide to identify a chat request.
     * </p>
     * 
     * @return A token that you provide to identify a chat request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The identifier of the Amazon Q conversation.
     * </p>
     * 
     * @return The identifier of the Amazon Q conversation.
     */
    public final String conversationId() {
        return conversationId;
    }

    /**
     * <p>
     * The identifier of the previous end user text input message in a conversation.
     * </p>
     * 
     * @return The identifier of the previous end user text input message in a conversation.
     */
    public final String parentMessageId() {
        return parentMessageId;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserGroups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUserGroups() {
        return userGroups != null && !(userGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The groups that a user associated with the chat input belongs to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserGroups} method.
     * </p>
     * 
     * @return The groups that a user associated with the chat input belongs to.
     */
    public final List<String> userGroups() {
        return userGroups;
    }

    /**
     * <p>
     * The identifier of the user attached to the chat input.
     * </p>
     * 
     * @return The identifier of the user attached to the chat input.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * A end user message in a conversation.
     * </p>
     * 
     * @return A end user message in a conversation.
     */
    public final String userMessage() {
        return userMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionExecution());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachments() ? attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(attributeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(parentMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserGroups() ? userGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(userMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatSyncRequest)) {
            return false;
        }
        ChatSyncRequest other = (ChatSyncRequest) obj;
        return Objects.equals(actionExecution(), other.actionExecution())
                && Objects.equals(applicationId(), other.applicationId()) && hasAttachments() == other.hasAttachments()
                && Objects.equals(attachments(), other.attachments())
                && Objects.equals(attributeFilter(), other.attributeFilter())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(conversationId(), other.conversationId())
                && Objects.equals(parentMessageId(), other.parentMessageId()) && hasUserGroups() == other.hasUserGroups()
                && Objects.equals(userGroups(), other.userGroups()) && Objects.equals(userId(), other.userId())
                && Objects.equals(userMessage(), other.userMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChatSyncRequest").add("ActionExecution", actionExecution())
                .add("ApplicationId", applicationId()).add("Attachments", hasAttachments() ? attachments() : null)
                .add("AttributeFilter", attributeFilter()).add("ClientToken", clientToken())
                .add("ConversationId", conversationId()).add("ParentMessageId", parentMessageId())
                .add("UserGroups", hasUserGroups() ? userGroups() : null).add("UserId", userId())
                .add("UserMessage", userMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionExecution":
            return Optional.ofNullable(clazz.cast(actionExecution()));
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        case "attributeFilter":
            return Optional.ofNullable(clazz.cast(attributeFilter()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "conversationId":
            return Optional.ofNullable(clazz.cast(conversationId()));
        case "parentMessageId":
            return Optional.ofNullable(clazz.cast(parentMessageId()));
        case "userGroups":
            return Optional.ofNullable(clazz.cast(userGroups()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "userMessage":
            return Optional.ofNullable(clazz.cast(userMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChatSyncRequest, T> g) {
        return obj -> g.apply((ChatSyncRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, ChatSyncRequest> {
        /**
         * <p>
         * A request from an end user to perform an Amazon Q plugin action.
         * </p>
         * 
         * @param actionExecution
         *        A request from an end user to perform an Amazon Q plugin action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionExecution(ActionExecution actionExecution);

        /**
         * <p>
         * A request from an end user to perform an Amazon Q plugin action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionExecution.Builder} avoiding the
         * need to create one manually via {@link ActionExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #actionExecution(ActionExecution)}.
         * 
         * @param actionExecution
         *        a consumer that will call methods on {@link ActionExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionExecution(ActionExecution)
         */
        default Builder actionExecution(Consumer<ActionExecution.Builder> actionExecution) {
            return actionExecution(ActionExecution.builder().applyMutation(actionExecution).build());
        }

        /**
         * <p>
         * The identifier of the Amazon Q application linked to the Amazon Q conversation.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q application linked to the Amazon Q conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * A list of files uploaded directly during chat. You can upload a maximum of 5 files of upto 10 MB each.
         * </p>
         * 
         * @param attachments
         *        A list of files uploaded directly during chat. You can upload a maximum of 5 files of upto 10 MB each.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<AttachmentInput> attachments);

        /**
         * <p>
         * A list of files uploaded directly during chat. You can upload a maximum of 5 files of upto 10 MB each.
         * </p>
         * 
         * @param attachments
         *        A list of files uploaded directly during chat. You can upload a maximum of 5 files of upto 10 MB each.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(AttachmentInput... attachments);

        /**
         * <p>
         * A list of files uploaded directly during chat. You can upload a maximum of 5 files of upto 10 MB each.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.AttachmentInput.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qbusiness.model.AttachmentInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.AttachmentInput.Builder#build()} is called immediately
         * and its result is passed to {@link #attachments(List<AttachmentInput>)}.
         * 
         * @param attachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.AttachmentInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(java.util.Collection<AttachmentInput>)
         */
        Builder attachments(Consumer<AttachmentInput.Builder>... attachments);

        /**
         * <p>
         * Enables filtering of Amazon Q web experience responses based on document attributes or metadata fields.
         * </p>
         * 
         * @param attributeFilter
         *        Enables filtering of Amazon Q web experience responses based on document attributes or metadata
         *        fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeFilter(AttributeFilter attributeFilter);

        /**
         * <p>
         * Enables filtering of Amazon Q web experience responses based on document attributes or metadata fields.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeFilter.Builder} avoiding the
         * need to create one manually via {@link AttributeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #attributeFilter(AttributeFilter)}.
         * 
         * @param attributeFilter
         *        a consumer that will call methods on {@link AttributeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeFilter(AttributeFilter)
         */
        default Builder attributeFilter(Consumer<AttributeFilter.Builder> attributeFilter) {
            return attributeFilter(AttributeFilter.builder().applyMutation(attributeFilter).build());
        }

        /**
         * <p>
         * A token that you provide to identify a chat request.
         * </p>
         * 
         * @param clientToken
         *        A token that you provide to identify a chat request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The identifier of the Amazon Q conversation.
         * </p>
         * 
         * @param conversationId
         *        The identifier of the Amazon Q conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationId(String conversationId);

        /**
         * <p>
         * The identifier of the previous end user text input message in a conversation.
         * </p>
         * 
         * @param parentMessageId
         *        The identifier of the previous end user text input message in a conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentMessageId(String parentMessageId);

        /**
         * <p>
         * The groups that a user associated with the chat input belongs to.
         * </p>
         * 
         * @param userGroups
         *        The groups that a user associated with the chat input belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(Collection<String> userGroups);

        /**
         * <p>
         * The groups that a user associated with the chat input belongs to.
         * </p>
         * 
         * @param userGroups
         *        The groups that a user associated with the chat input belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(String... userGroups);

        /**
         * <p>
         * The identifier of the user attached to the chat input.
         * </p>
         * 
         * @param userId
         *        The identifier of the user attached to the chat input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * A end user message in a conversation.
         * </p>
         * 
         * @param userMessage
         *        A end user message in a conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMessage(String userMessage);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private ActionExecution actionExecution;

        private String applicationId;

        private List<AttachmentInput> attachments = DefaultSdkAutoConstructList.getInstance();

        private AttributeFilter attributeFilter;

        private String clientToken;

        private String conversationId;

        private String parentMessageId;

        private List<String> userGroups = DefaultSdkAutoConstructList.getInstance();

        private String userId;

        private String userMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ChatSyncRequest model) {
            super(model);
            actionExecution(model.actionExecution);
            applicationId(model.applicationId);
            attachments(model.attachments);
            attributeFilter(model.attributeFilter);
            clientToken(model.clientToken);
            conversationId(model.conversationId);
            parentMessageId(model.parentMessageId);
            userGroups(model.userGroups);
            userId(model.userId);
            userMessage(model.userMessage);
        }

        public final ActionExecution.Builder getActionExecution() {
            return actionExecution != null ? actionExecution.toBuilder() : null;
        }

        public final void setActionExecution(ActionExecution.BuilderImpl actionExecution) {
            this.actionExecution = actionExecution != null ? actionExecution.build() : null;
        }

        @Override
        public final Builder actionExecution(ActionExecution actionExecution) {
            this.actionExecution = actionExecution;
            return this;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final List<AttachmentInput.Builder> getAttachments() {
            List<AttachmentInput.Builder> result = AttachmentsInputCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<AttachmentInput.BuilderImpl> attachments) {
            this.attachments = AttachmentsInputCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<AttachmentInput> attachments) {
            this.attachments = AttachmentsInputCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(AttachmentInput... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<AttachmentInput.Builder>... attachments) {
            attachments(Stream.of(attachments).map(c -> AttachmentInput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AttributeFilter.Builder getAttributeFilter() {
            return attributeFilter != null ? attributeFilter.toBuilder() : null;
        }

        public final void setAttributeFilter(AttributeFilter.BuilderImpl attributeFilter) {
            this.attributeFilter = attributeFilter != null ? attributeFilter.build() : null;
        }

        @Override
        public final Builder attributeFilter(AttributeFilter attributeFilter) {
            this.attributeFilter = attributeFilter;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getConversationId() {
            return conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getParentMessageId() {
            return parentMessageId;
        }

        public final void setParentMessageId(String parentMessageId) {
            this.parentMessageId = parentMessageId;
        }

        @Override
        public final Builder parentMessageId(String parentMessageId) {
            this.parentMessageId = parentMessageId;
            return this;
        }

        public final Collection<String> getUserGroups() {
            if (userGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return userGroups;
        }

        public final void setUserGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupsCopier.copy(userGroups);
        }

        @Override
        public final Builder userGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupsCopier.copy(userGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroups(String... userGroups) {
            userGroups(Arrays.asList(userGroups));
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getUserMessage() {
            return userMessage;
        }

        public final void setUserMessage(String userMessage) {
            this.userMessage = userMessage;
        }

        @Override
        public final Builder userMessage(String userMessage) {
            this.userMessage = userMessage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ChatSyncRequest build() {
            return new ChatSyncRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
