/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule for configuring how Amazon Q responds when it encounters a a blocked topic. You can configure a custom message
 * to inform your end users that they have asked about a restricted topic and suggest any next steps they should take.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContentBlockerRule implements SdkPojo, Serializable,
        ToCopyableBuilder<ContentBlockerRule.Builder, ContentBlockerRule> {
    private static final SdkField<String> SYSTEM_MESSAGE_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("systemMessageOverride").getter(getter(ContentBlockerRule::systemMessageOverride))
            .setter(setter(Builder::systemMessageOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessageOverride").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SYSTEM_MESSAGE_OVERRIDE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String systemMessageOverride;

    private ContentBlockerRule(BuilderImpl builder) {
        this.systemMessageOverride = builder.systemMessageOverride;
    }

    /**
     * <p>
     * The configured custom message displayed to an end user informing them that they've used a blocked phrase during
     * chat.
     * </p>
     * 
     * @return The configured custom message displayed to an end user informing them that they've used a blocked phrase
     *         during chat.
     */
    public final String systemMessageOverride() {
        return systemMessageOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(systemMessageOverride());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentBlockerRule)) {
            return false;
        }
        ContentBlockerRule other = (ContentBlockerRule) obj;
        return Objects.equals(systemMessageOverride(), other.systemMessageOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContentBlockerRule").add("SystemMessageOverride", systemMessageOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "systemMessageOverride":
            return Optional.ofNullable(clazz.cast(systemMessageOverride()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContentBlockerRule, T> g) {
        return obj -> g.apply((ContentBlockerRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentBlockerRule> {
        /**
         * <p>
         * The configured custom message displayed to an end user informing them that they've used a blocked phrase
         * during chat.
         * </p>
         * 
         * @param systemMessageOverride
         *        The configured custom message displayed to an end user informing them that they've used a blocked
         *        phrase during chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemMessageOverride(String systemMessageOverride);
    }

    static final class BuilderImpl implements Builder {
        private String systemMessageOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(ContentBlockerRule model) {
            systemMessageOverride(model.systemMessageOverride);
        }

        public final String getSystemMessageOverride() {
            return systemMessageOverride;
        }

        public final void setSystemMessageOverride(String systemMessageOverride) {
            this.systemMessageOverride = systemMessageOverride;
        }

        @Override
        public final Builder systemMessageOverride(String systemMessageOverride) {
            this.systemMessageOverride = systemMessageOverride;
            return this;
        }

        @Override
        public ContentBlockerRule build() {
            return new ContentBlockerRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
